/*
 * Decompiled with CFR 0.152.
 */
package cavern.entity.boss;

import cavern.entity.ai.EntityAIAttackMoveRanged;
import cavern.entity.ai.EntityAISeekerChase;
import cavern.entity.ai.EntityAISeekerStatus;
import cavern.entity.ai.EntityAISeekerThunder;
import cavern.entity.ai.EntityFlyHelper;
import cavern.entity.projectile.EntityBeam;
import cavern.util.CaveUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.AbstractIllager;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntitySkySeeker
extends EntityMob
implements IRangedAttackMob {
    private static final ResourceLocation LOOT_SEEKER = LootTableList.func_186375_a((ResourceLocation)CaveUtils.getKey("entities/sky_seeker"));
    private static final DataParameter<Boolean> SLEEP = EntityDataManager.func_187226_a(EntitySkySeeker.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<String> ATTACK_STATUS = EntityDataManager.func_187226_a(EntitySkySeeker.class, (DataSerializer)DataSerializers.field_187194_d);
    private float heightOffset = 0.5f;
    private int heightOffsetUpdateTime;
    private int ticksProgress;
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.WHITE, BossInfo.Overlay.PROGRESS);

    public EntitySkySeeker(World world) {
        super(world);
        this.func_70105_a(0.75f, 1.9f);
        this.field_70178_ae = true;
        this.field_70765_h = new EntityFlyHelper((EntityLiving)this);
        this.field_70728_aV = 100;
        this.bossInfo.func_186758_d(false);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public BossInfoServer getBossInfo() {
        return this.bossInfo;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIDoNothing());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISeekerStatus(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISeekerChase(this, 1.25));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAISeekerThunder(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMoveRanged<EntitySkySeeker>(this, 1.0, 50, 16.0f){

            @Override
            public boolean func_75250_a() {
                return super.func_75250_a() && EntitySkySeeker.this.isBeamStatus();
            }

            @Override
            public boolean func_75253_b() {
                return super.func_75253_b() && EntitySkySeeker.this.isBeamStatus();
            }
        });
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.1));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, AbstractIllager.class, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(340.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.262896);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(30.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(0.44);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SLEEP, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(ATTACK_STATUS, (Object)Status.NONE.name());
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_SEEKER;
    }

    public void func_70110_aj() {
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public void func_70624_b(@Nullable EntityLivingBase living) {
        super.func_70624_b(living);
        if (living == null) {
            this.setAttackStatus(Status.NONE);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setSleep(compound.func_74767_n("Sleep"));
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Sleep", this.isSleep());
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    protected void func_82167_n(Entity entity) {
        super.func_82167_n(entity);
        if (this.getAttackStatus() == Status.STOMP) {
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 10.0f);
            if (entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70653_a((Entity)this, 0.625f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
            } else {
                entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * 1.25f * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * 1.25f * 0.5f));
            }
        }
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_70089_S() ? this.func_174813_aQ() : null;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_145773_az() {
        return true;
    }

    protected PathNavigate func_175447_b(World world) {
        PathNavigateFlying flying = new PathNavigateFlying((EntityLiving)this, world);
        flying.func_192879_a(false);
        flying.func_192877_c(true);
        flying.func_192878_b(true);
        return flying;
    }

    public void func_70636_d() {
        if (this.getAttackStatus() != Status.STOMP && !this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        this.setTicksProgress(this.getTicksProgress() + 1);
        if (this.getAttackStatus() != Status.NONE && this.getTicksProgress() >= this.getMaxTicksForStatus()) {
            this.updateStatus();
        }
        super.func_70636_d();
    }

    private void updateStatus() {
        if (this.getAttackStatus() == Status.CHASE) {
            this.setAttackStatus(Status.STOMP);
        } else if (this.getAttackStatus() == Status.THUNDER_PRE) {
            this.setAttackStatus(Status.THUNDER);
        } else if (this.getAttackStatus() != Status.NONE) {
            this.setAttackStatus(Status.NONE);
        }
    }

    public void setAttackStatus(String statusName) {
        this.setTicksProgress(0);
        this.field_70180_af.func_187227_b(ATTACK_STATUS, (Object)statusName);
    }

    public void setAttackStatus(Status status) {
        this.setTicksProgress(0);
        this.field_70180_af.func_187227_b(ATTACK_STATUS, (Object)status.name());
    }

    public Status getAttackStatus() {
        return Status.getTypeByName((String)this.field_70180_af.func_187225_a(EntitySkySeeker.ATTACK_STATUS));
    }

    public int getMaxTicksForStatus() {
        return this.getAttackStatus().duration;
    }

    public boolean isBeamStatus() {
        return this.getAttackStatus() == Status.BEAM;
    }

    public boolean isThunderPreAttack() {
        return this.getAttackStatus() == Status.THUNDER_PRE;
    }

    public boolean isThunderAttack() {
        return this.getAttackStatus() == Status.THUNDER;
    }

    public boolean isMagicPreAttack() {
        return this.getAttackStatus() == Status.THUNDER_PRE;
    }

    public boolean isMagicAttack() {
        return this.getAttackStatus() == Status.THUNDER;
    }

    public int getTicksProgress() {
        return this.ticksProgress;
    }

    public void setTicksProgress(int progress) {
        this.ticksProgress = progress;
    }

    protected void func_70619_bc() {
        if (!this.isSleep()) {
            EntityLivingBase target;
            --this.heightOffsetUpdateTime;
            if (this.heightOffsetUpdateTime <= 0) {
                this.heightOffsetUpdateTime = 100;
                this.heightOffset = 0.5f + (float)this.field_70146_Z.nextGaussian() * 2.0f;
            }
            if ((target = this.func_70638_az()) != null && target.func_70089_S() && target.field_70163_u + (double)target.func_70047_e() > this.field_70163_u + (double)this.func_70047_e() + (double)this.heightOffset) {
                this.field_70181_x = (0.2 - this.field_70181_x) * 0.2;
                this.field_70160_al = true;
            }
            super.func_70619_bc();
            this.bossInfo.func_186758_d(true);
        } else {
            this.bossInfo.func_186758_d(false);
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public boolean isSleep() {
        return (Boolean)this.field_70180_af.func_187225_a(SLEEP);
    }

    public void setSleep(boolean sleep) {
        this.field_70180_af.func_187227_b(SLEEP, (Object)sleep);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        double d1 = target.field_70165_t - this.field_70165_t;
        double d2 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
        double d3 = target.field_70161_v - this.field_70161_v;
        EntityBeam projectile = new EntityBeam(this.field_70170_p, (EntityLivingBase)this, d1 + this.func_70681_au().nextGaussian() * 0.01 - 0.005, d2, d3 + this.func_70681_au().nextGaussian() * 0.01 - 0.005);
        Vec3d vec3d = this.func_70676_i(1.0f);
        this.func_184185_a(SoundEvents.field_187606_E, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        projectile.func_70012_b(this.field_70165_t + vec3d.field_72450_a * 1.3, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v + vec3d.field_72449_c * 1.3, this.field_70177_z, this.field_70125_A);
        projectile.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 0.5;
        this.field_70170_p.func_72838_d((Entity)projectile);
    }

    public void func_184724_a(boolean swingingArms) {
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source.func_76347_k() || source == DamageSource.field_180137_b) {
            return false;
        }
        if (this.isSleep() && source.func_76364_f() instanceof EntityLivingBase) {
            this.setSleep(false);
            return false;
        }
        if (source.func_76364_f() instanceof EntityArrow) {
            return false;
        }
        if (source.func_76352_a()) {
            return super.func_70097_a(source, amount * 0.65f);
        }
        return super.func_70097_a(source, amount * 0.85f);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.getAttackStatus() == Status.STOMP) {
            for (int i = 0; i < 10; ++i) {
                int z;
                int y;
                int x = MathHelper.func_76128_c((double)this.field_70165_t);
                IBlockState state = this.field_70170_p.func_180495_p(new BlockPos(x, y = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), z = MathHelper.func_76128_c((double)this.field_70161_v)));
                if (state.func_185904_a() == Material.field_151579_a) continue;
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)state)});
            }
            this.setAttackStatus(Status.NONE);
        }
    }

    protected void func_184231_a(double y, boolean onGround, IBlockState state, BlockPos pos) {
    }

    private class AIDoNothing
    extends EntityAIBase {
        private AIDoNothing() {
            this.func_75248_a(7);
        }

        public boolean func_75250_a() {
            return EntitySkySeeker.this.isSleep();
        }

        public void func_75246_d() {
            super.func_75246_d();
            EntitySkySeeker.this.func_70661_as().func_75499_g();
        }
    }

    public static enum Status {
        NONE(0),
        THUNDER_PRE(80),
        THUNDER(100),
        BEAM(120),
        CHASE(100),
        STOMP(60);

        private final int duration;

        private Status(int duration) {
            this.duration = duration;
        }

        private static Status getTypeByName(String name) {
            for (Status type : Status.values()) {
                if (!type.name().equals(name)) continue;
                return type;
            }
            return NONE;
        }
    }
}

