/*
 * Decompiled with CFR 0.152.
 */
package cavern.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityMob;

public class EntityAIAttackMoveRanged<T extends EntityMob>
extends EntityAIBase {
    private final T entity;
    private final double moveSpeedAmp;
    private int attackCooldown;
    private final float maxAttackDistance;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public EntityAIAttackMoveRanged(T entity, double move, int cooldown, float distance) {
        this.entity = entity;
        this.moveSpeedAmp = move;
        this.attackCooldown = cooldown;
        this.maxAttackDistance = distance * distance;
        this.func_75248_a(3);
    }

    public void setAttackCooldown(int time) {
        this.attackCooldown = time;
    }

    public boolean func_75250_a() {
        return this.entity.func_70638_az() != null;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.entity.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        super.func_75249_e();
        ((IRangedAttackMob)this.entity).func_184724_a(true);
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.entity.func_70661_as().func_75499_g();
        ((IRangedAttackMob)this.entity).func_184724_a(false);
        this.seeTime = 0;
        this.setAttackTime(-1);
    }

    public void func_75246_d() {
        EntityLivingBase target = this.entity.func_70638_az();
        if (target != null) {
            boolean seeing;
            double dist = this.entity.func_70092_e(target.field_70165_t, target.func_174813_aQ().field_72338_b, target.field_70161_v);
            boolean canSee = this.entity.func_70635_at().func_75522_a((Entity)target);
            boolean bl = seeing = this.seeTime > 0;
            if (canSee != seeing) {
                this.seeTime = 0;
            }
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            if (dist <= (double)this.maxAttackDistance) {
                this.entity.func_70661_as().func_75499_g();
                ++this.strafingTime;
            } else {
                this.entity.func_70661_as().func_75497_a((Entity)target, this.moveSpeedAmp);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (dist > (double)(this.maxAttackDistance * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (dist < (double)(this.maxAttackDistance * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.entity.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.entity.func_70625_a((Entity)target, 30.0f, 30.0f);
            }
            this.entity.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            if (canSee && this.seeTime > 60) {
                ((IRangedAttackMob)this.entity).func_82196_d(target, 0.6f);
                this.setAttackTime(this.attackCooldown);
                this.seeTime = 0;
            }
        }
    }

    public int getAttackTime() {
        return this.attackTime;
    }

    public void setAttackTime(int time) {
        this.attackTime = time;
    }
}

