/*
 * Decompiled with CFR 0.152.
 */
package cavern.entity;

import cavern.core.Cavern;
import cavern.entity.boss.EntitySkySeeker;
import cavern.entity.monster.EntityCaveman;
import cavern.entity.monster.EntityCavenicBear;
import cavern.entity.monster.EntityCavenicCreeper;
import cavern.entity.monster.EntityCavenicSkeleton;
import cavern.entity.monster.EntityCavenicSpider;
import cavern.entity.monster.EntityCavenicWitch;
import cavern.entity.monster.EntityCavenicZombie;
import cavern.entity.monster.EntityCrazyCreeper;
import cavern.entity.monster.EntityCrazySkeleton;
import cavern.entity.monster.EntityCrazySpider;
import cavern.entity.monster.EntityCrazyZombie;
import cavern.entity.monster.EntityCrystalTurret;
import cavern.entity.monster.EntitySummonCavenicSkeleton;
import cavern.entity.monster.EntitySummonCavenicZombie;
import cavern.entity.monster.EntitySummonSkeleton;
import cavern.entity.monster.EntitySummonZombie;
import cavern.entity.passive.EntityAquaSquid;
import cavern.entity.passive.EntityDurangHog;
import cavern.entity.projectile.EntityBeam;
import cavern.entity.projectile.EntityMagicTorcher;
import cavern.util.CaveUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class CaveEntityRegistry {
    public static final NonNullList<Biome.SpawnListEntry> SPAWNS = NonNullList.func_191196_a();
    public static final NonNullList<Biome.SpawnListEntry> CRAZY_SPAWNS = NonNullList.func_191196_a();
    public static final NonNullList<Biome.SpawnListEntry> ANIMAL_SPAWNS = NonNullList.func_191196_a();
    private static int entityId;

    public static void registerEntity(Class<? extends Entity> entityClass, String key, String name, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.registerModEntity((ResourceLocation)CaveUtils.getKey(key), entityClass, (String)name, (int)entityId++, (Object)Cavern.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
    }

    public static void registerEntity(Class<? extends Entity> entityClass, String key, String name, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int primaryColor, int secondaryColor) {
        EntityRegistry.registerModEntity((ResourceLocation)CaveUtils.getKey(key), entityClass, (String)name, (int)entityId++, (Object)Cavern.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates, (int)primaryColor, (int)secondaryColor);
    }

    private static EntityEntry createEntry(Class<? extends Entity> entityClass, String key, String name) {
        return (EntityEntry)new EntityEntry(entityClass, name).setRegistryName(CaveUtils.getKey(key));
    }

    private static EntityEntry createEntry(Class<? extends Entity> entityClass, String key, String name, int primaryColor, int secondaryColor) {
        EntityEntry entry = new EntityEntry(entityClass, name);
        ResourceLocation regKey = CaveUtils.getKey(key);
        entry.setRegistryName(regKey);
        entry.setEgg(new EntityList.EntityEggInfo(regKey, primaryColor, secondaryColor));
        return entry;
    }

    public static void registerEntities(IForgeRegistry<EntityEntry> registry) {
        registry.register((IForgeRegistryEntry)CaveEntityRegistry.createEntry(EntityCavenicSkeleton.class, "cavenic_skeleton", "CavenicSkeleton", 0xAAAAAA, 0xDDDDDD));
        registry.register((IForgeRegistryEntry)CaveEntityRegistry.createEntry(EntityCavenicCreeper.class, "cavenic_creeper", "CavenicCreeper", 0xAAAAAA, 3050327));
        registry.register((IForgeRegistryEntry)CaveEntityRegistry.createEntry(EntityCavenicZombie.class, "cavenic_zombie", "CavenicZombie", 0xAAAAAA, 41120));
        registry.register((IForgeRegistryEntry)CaveEntityRegistry.createEntry(EntityCavenicSpider.class, "cavenic_spider", "CavenicSpider", 0xAAAAAA, 0x811F1F));
        registry.register((IForgeRegistryEntry)CaveEntityRegistry.createEntry(EntityCavenicWitch.class, "cavenic_witch", "CavenicWitch", 0xAAAAAA, 4870984));
        registry.register((IForgeRegistryEntry)CaveEntityRegistry.createEntry(EntityCavenicBear.class, "cavenic_bear", "CavenicBear", 0xAAAAAA, 0xFFFFFF));
        registry.register((IForgeRegistryEntry)CaveEntityRegistry.createEntry(EntityCrazySkeleton.class, "crazy_skeleton", "CrazySkeleton", 0x909090, 0xDDDDDD));
        registry.register((IForgeRegistryEntry)CaveEntityRegistry.createEntry(EntityCrazyCreeper.class, "crazy_creeper", "CrazyCreeper", 0x909090, 3050327));
        registry.register((IForgeRegistryEntry)CaveEntityRegistry.createEntry(EntityCrazyZombie.class, "crazy_zombie", "CrazyZombie", 0x909090, 41120));
        registry.register((IForgeRegistryEntry)CaveEntityRegistry.createEntry(EntityCrazySpider.class, "crazy_spider", "CrazySpider", 0x909090, 0x811F1F));
        registry.register((IForgeRegistryEntry)CaveEntityRegistry.createEntry(EntityCaveman.class, "caveman", "Caveman", 0xAAAAAA, 0xCCCCCC));
        registry.register((IForgeRegistryEntry)CaveEntityRegistry.createEntry(EntityCrystalTurret.class, "crystal_turret", "CrystalTurret", 0xAAAAAA, 13756150));
        registry.register((IForgeRegistryEntry)CaveEntityRegistry.createEntry(EntitySkySeeker.class, "sky_seeker", "SkySeeker", 0xAAAAAA, 13756150));
        registry.register((IForgeRegistryEntry)CaveEntityRegistry.createEntry(EntityDurangHog.class, "durang_hog", "DurangHog", 13016736, 8212816));
        registry.register((IForgeRegistryEntry)CaveEntityRegistry.createEntry(EntitySummonZombie.class, "summon_zombie", "Zombie"));
        registry.register((IForgeRegistryEntry)CaveEntityRegistry.createEntry(EntitySummonSkeleton.class, "summon_skeleton", "Skeleton"));
        registry.register((IForgeRegistryEntry)CaveEntityRegistry.createEntry(EntitySummonCavenicZombie.class, "summon_cavenic_zombie", "CavenicZombie"));
        registry.register((IForgeRegistryEntry)CaveEntityRegistry.createEntry(EntitySummonCavenicSkeleton.class, "summon_cavenic_skeleton", "CavenicSkeleton"));
        registry.register((IForgeRegistryEntry)CaveEntityRegistry.createEntry(EntityAquaSquid.class, "squid", "Squid"));
        registry.register((IForgeRegistryEntry)CaveEntityRegistry.createEntry(EntityMagicTorcher.class, "magic_torcher", "MagicTorcher"));
        CaveEntityRegistry.registerEntity(EntityBeam.class, "beam", "Beam", 100, 1, true);
    }

    public static void regsiterSpawns() {
        SPAWNS.add((Object)new Biome.SpawnListEntry(EntityCavenicSkeleton.class, 20, 1, 1));
        SPAWNS.add((Object)new Biome.SpawnListEntry(EntityCavenicCreeper.class, 30, 1, 1));
        SPAWNS.add((Object)new Biome.SpawnListEntry(EntityCavenicZombie.class, 30, 2, 2));
        SPAWNS.add((Object)new Biome.SpawnListEntry(EntityCavenicSpider.class, 30, 1, 1));
        SPAWNS.add((Object)new Biome.SpawnListEntry(EntityCavenicWitch.class, 15, 1, 1));
        SPAWNS.add((Object)new Biome.SpawnListEntry(EntityCavenicBear.class, 30, 1, 1));
        SPAWNS.add((Object)new Biome.SpawnListEntry(EntityCaveman.class, 35, 1, 1));
        CRAZY_SPAWNS.add((Object)new Biome.SpawnListEntry(EntityCrazySkeleton.class, 1, 1, 1));
        CRAZY_SPAWNS.add((Object)new Biome.SpawnListEntry(EntityCrazyCreeper.class, 1, 1, 1));
        CRAZY_SPAWNS.add((Object)new Biome.SpawnListEntry(EntityCrazyZombie.class, 1, 1, 1));
        CRAZY_SPAWNS.add((Object)new Biome.SpawnListEntry(EntityCrazySpider.class, 1, 1, 1));
        ANIMAL_SPAWNS.add((Object)new Biome.SpawnListEntry(EntityDurangHog.class, 5, 1, 2));
        EntitySpawnPlacementRegistry.setPlacementType(EntityAquaSquid.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
    }
}

