/*
 * Decompiled with CFR 0.152.
 */
package cavern.data;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import org.apache.commons.lang3.ObjectUtils;

public class PortalCache {
    private final Map<ResourceLocation, DimensionType> lastDim = Maps.newHashMap();
    private final Table<ResourceLocation, DimensionType, BlockPos> lastPos = HashBasedTable.create();

    public DimensionType getLastDim(ResourceLocation key) {
        return this.getLastDim(key, DimensionType.OVERWORLD);
    }

    public DimensionType getLastDim(ResourceLocation key, DimensionType nullDefault) {
        return this.lastDim.getOrDefault(key, nullDefault);
    }

    public void setLastDim(ResourceLocation key, DimensionType type) {
        this.lastDim.put(key, type);
    }

    public BlockPos getLastPos(ResourceLocation key, DimensionType type) {
        return (BlockPos)this.lastPos.get((Object)key, (Object)type);
    }

    public BlockPos getLastPos(ResourceLocation key, DimensionType type, BlockPos pos) {
        return (BlockPos)ObjectUtils.defaultIfNull((Object)this.getLastPos(key, type), (Object)ObjectUtils.defaultIfNull((Object)pos, (Object)BlockPos.field_177992_a));
    }

    public boolean hasLastPos(ResourceLocation key, DimensionType type) {
        return this.lastPos.contains((Object)key, (Object)type);
    }

    public void setLastPos(ResourceLocation key, DimensionType type, BlockPos pos) {
        if (pos == null) {
            this.lastPos.remove((Object)key, (Object)type);
        } else {
            this.lastPos.put((Object)key, (Object)type, (Object)pos);
        }
    }

    public void clearLastPos(ResourceLocation key, DimensionType type) {
        for (Table.Cell entry : this.lastPos.cellSet()) {
            if (key != null && !((ResourceLocation)entry.getRowKey()).equals((Object)key) || entry.getColumnKey() != type) continue;
            this.lastPos.remove(entry.getRowKey(), entry.getColumnKey());
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        DimensionType type;
        ResourceLocation key;
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<ResourceLocation, DimensionType> entry : this.lastDim.entrySet()) {
            key = entry.getKey();
            type = entry.getValue();
            if (key == null || type == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("Key", key.toString());
            tag.func_74768_a("Dim", type.func_186068_a());
            tagList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("LastDim", (NBTBase)tagList);
        tagList = new NBTTagList();
        for (Table.Cell cell : this.lastPos.cellSet()) {
            key = (ResourceLocation)cell.getRowKey();
            type = (DimensionType)cell.getColumnKey();
            BlockPos pos = (BlockPos)cell.getValue();
            if (key == null || type == null || pos == null) continue;
            NBTTagCompound tag = NBTUtil.func_186859_a((BlockPos)pos);
            tag.func_74778_a("Key", key.toString());
            tag.func_74768_a("Dim", type.func_186068_a());
            tagList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("LastPos", (NBTBase)tagList);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        DimensionType type;
        NBTTagCompound tag;
        int i;
        NBTTagList tagList = nbt.func_150295_c("LastDim", 10);
        if (tagList != null && tagList.func_74745_c() > 0) {
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                tag = tagList.func_150305_b(i);
                type = null;
                try {
                    type = DimensionType.func_186069_a((int)tag.func_74762_e("Dim"));
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                if (type == null || !tag.func_150297_b("Key", 8)) continue;
                this.lastDim.put(new ResourceLocation(tag.func_74779_i("Key")), type);
            }
        }
        tagList = nbt.func_150295_c("LastPos", 10);
        for (i = 0; i < tagList.func_74745_c(); ++i) {
            tag = tagList.func_150305_b(i);
            type = null;
            try {
                type = DimensionType.func_186069_a((int)tag.func_74762_e("Dim"));
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            if (type == null || !tag.func_150297_b("Key", 8)) continue;
            this.lastPos.put((Object)new ResourceLocation(tag.func_74779_i("Key")), (Object)type, (Object)NBTUtil.func_186861_c((NBTTagCompound)tag));
        }
    }
}

