/*
 * Decompiled with CFR 0.152.
 */
package cavern.data;

import cavern.capability.CaveCapabilities;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.apache.commons.lang3.ObjectUtils;

public class PlayerData {
    private final Map<DimensionType, Long> lastTeleportTimes = Maps.newHashMap();
    private long lastSleepTime;

    public long getLastTeleportTime(DimensionType type) {
        return this.lastTeleportTimes.getOrDefault(type, 0L);
    }

    public void setLastTeleportTime(DimensionType type, long time) {
        this.lastTeleportTimes.put(type, time);
    }

    public long getLastSleepTime() {
        return this.lastSleepTime;
    }

    public void setLastSleepTime(long time) {
        this.lastSleepTime = time;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<DimensionType, Long> entry : this.lastTeleportTimes.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("Dim", entry.getKey().func_186068_a());
            tag.func_74772_a("Time", entry.getValue().longValue());
        }
        nbt.func_74782_a("LastTeleportTimes", (NBTBase)tagList);
        nbt.func_74772_a("LastSleepTime", this.lastSleepTime);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList tagList = nbt.func_150295_c("LastTeleportTime", 10);
        if (tagList != null && tagList.func_74745_c() > 0) {
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                DimensionType type = null;
                try {
                    type = DimensionType.func_186069_a((int)tag.func_74762_e("Dim"));
                }
                catch (IllegalArgumentException e) {
                    continue;
                }
                if (type == null) continue;
                this.lastTeleportTimes.put(type, tag.func_74763_f("Time"));
            }
        }
        this.lastSleepTime = nbt.func_74763_f("LastSleepTime");
    }

    public static PlayerData get(EntityPlayer player) {
        return (PlayerData)ObjectUtils.defaultIfNull((Object)CaveCapabilities.getCapability((ICapabilityProvider)player, CaveCapabilities.PLAYER_DATA), (Object)new PlayerData());
    }
}

