/*
 * Decompiled with CFR 0.152.
 */
package cavern.data;

import cavern.api.data.IMiningData;
import cavern.capability.CaveCapabilities;
import cavern.config.GeneralConfig;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.apache.commons.lang3.ObjectUtils;

public class MiningData
implements IMiningData {
    private final EntityPlayer player;
    private IBlockState lastMiningBlock;
    private int lastMiningPoint;
    private int miningCombo;
    private long lastMiningTime;

    public MiningData(EntityPlayer player) {
        this.player = player;
    }

    @Override
    public IBlockState getLastMiningBlock() {
        return this.lastMiningBlock;
    }

    @Override
    public int getLastMiningPoint() {
        return this.lastMiningPoint;
    }

    @Override
    public int getMiningCombo() {
        return this.miningCombo;
    }

    @Override
    public long getLastMiningTime() {
        return this.lastMiningTime;
    }

    @Override
    public void notifyMining(IBlockState state, int point) {
        this.lastMiningBlock = state;
        this.lastMiningPoint = point;
        this.lastMiningTime = this.player.field_70170_p.func_82737_E();
        if (GeneralConfig.miningCombo) {
            ++this.miningCombo;
        }
    }

    @Override
    public void onUpdate() {
        if (this.miningCombo == 0) {
            return;
        }
        if (this.player.field_70170_p.func_82737_E() - this.lastMiningTime > 300L) {
            this.miningCombo = 0;
        }
    }

    public static IMiningData get(EntityPlayer player) {
        return (IMiningData)ObjectUtils.defaultIfNull((Object)CaveCapabilities.getCapability((ICapabilityProvider)player, CaveCapabilities.MINING_DATA), (Object)new MiningData(null));
    }
}

