/*
 * Decompiled with CFR 0.152.
 */
package cavern.data;

import cavern.item.CaveItems;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum MinerRank {
    BEGINNER(0, 0, 1.0f, "beginner", new ItemStack(Items.field_151039_o)),
    STONE_MINER(1, 50, 1.0f, "stoneMiner", new ItemStack(Items.field_151050_s)),
    IRON_MINER(2, 100, 1.0f, "ironMiner", new ItemStack(Items.field_151035_b)),
    MAGNITE_MINER(3, 300, 1.1f, "magniteMiner", new ItemStack((Item)CaveItems.MAGNITE_PICKAXE)),
    GOLD_MINER(4, 1000, 1.2f, "goldMiner", new ItemStack(Items.field_151005_D)),
    AQUA_MINER(5, 1500, 1.25f, "aquaMiner", new ItemStack((Item)CaveItems.AQUAMARINE_PICKAXE)),
    HEXCITE_MINER(6, 3000, 1.5f, "hexciteMiner", new ItemStack((Item)CaveItems.HEXCITE_PICKAXE)),
    DIAMOND_MINER(7, 5000, 1.75f, "diamondMiner", new ItemStack(Items.field_151046_w));

    public static final MinerRank[] VALUES;
    private final int rank;
    private final int phase;
    private final float boost;
    private final String name;
    private final ItemStack theItemStack;

    private MinerRank(int rank, int phase, @Nullable float boost, String name, ItemStack stack) {
        this.rank = rank;
        this.phase = phase;
        this.boost = boost;
        this.name = name;
        this.theItemStack = stack;
    }

    public int getRank() {
        return this.rank;
    }

    public int getPhase() {
        return this.phase;
    }

    public float getBoost() {
        return this.boost;
    }

    public String getName() {
        return this.name;
    }

    public String getUnlocalizedName() {
        return "cavern.minerrank." + this.name;
    }

    public ItemStack getItemStack() {
        return this.theItemStack == null ? ItemStack.field_190927_a : this.theItemStack;
    }

    public static MinerRank get(int rank) {
        int max;
        if (rank < 0) {
            rank = 0;
        }
        if (rank > (max = VALUES.length - 1)) {
            rank = max;
        }
        return VALUES[rank];
    }

    static {
        VALUES = new MinerRank[MinerRank.values().length];
        MinerRank[] minerRankArray = MinerRank.values();
        int n = minerRankArray.length;
        for (int i = 0; i < n; ++i) {
            MinerRank rank;
            MinerRank.VALUES[rank.getRank()] = rank = minerRankArray[i];
        }
    }
}

