/*
 * Decompiled with CFR 0.152.
 */
package cavern.data;

import cavern.api.data.IMiner;
import cavern.api.event.MinerEvent;
import cavern.capability.CaveCapabilities;
import cavern.config.MiningAssistConfig;
import cavern.core.CaveSounds;
import cavern.data.MinerRank;
import cavern.miningassist.MiningAssist;
import cavern.network.CaveNetworkRegistry;
import cavern.network.client.MinerDataMessage;
import cavern.network.client.MiningRecordsMessage;
import cavern.util.BlockMeta;
import cavern.util.PlayerHelper;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ObjectUtils;

public class Miner
implements IMiner {
    public static final Table<Block, Integer, Integer> MINING_POINTS = HashBasedTable.create();
    private final EntityPlayer entityPlayer;
    private int point = -1;
    private int rank;
    private int miningAssist;
    private final Map<BlockMeta, Integer> records = Maps.newHashMap();

    public Miner() {
        this(null);
    }

    public Miner(@Nullable EntityPlayer player) {
        this.entityPlayer = player;
    }

    @Override
    public int getPoint() {
        return this.point;
    }

    @Override
    public void setPoint(int value) {
        this.setPoint(value, true);
    }

    @Override
    public void setPoint(int value, boolean adjust) {
        int prev = this.point;
        this.point = Math.max(value, 0);
        if (this.point != prev && adjust) {
            this.adjustData();
        }
    }

    @Override
    public void addPoint(int value) {
        this.addPoint(value, true);
    }

    @Override
    public void addPoint(int value, boolean adjust) {
        MinerRank next;
        MinerEvent.AddPoint event = new MinerEvent.AddPoint(this.entityPlayer, this, value);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        this.setPoint(this.point + event.getNewPoint(), adjust);
        if (this.entityPlayer != null && value > 0 && this.point > 0 && this.point % 100 == 0) {
            this.entityPlayer.func_71023_q(this.entityPlayer.func_71050_bK() / 2);
        }
        MinerRank current = MinerRank.get(this.rank);
        int max = MinerRank.values().length - 1;
        boolean promoted = false;
        while (current.getRank() < max && this.point >= (next = MinerRank.get(this.rank + 1)).getPhase()) {
            ++this.rank;
            promoted = true;
            current = next;
            this.setPoint(this.point - current.getPhase(), false);
        }
        if (promoted) {
            if (adjust) {
                this.adjustData();
            }
            if (this.entityPlayer != null && this.entityPlayer instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)this.entityPlayer;
                MinecraftServer server = player.field_71133_b;
                TextComponentTranslation name = new TextComponentTranslation(current.getUnlocalizedName(), new Object[0]);
                name.func_150256_b().func_150227_a(Boolean.valueOf(true));
                TextComponentTranslation component = new TextComponentTranslation("cavern.minerrank.promoted", new Object[]{player.func_145748_c_(), name});
                component.func_150256_b().func_150238_a(TextFormatting.GRAY).func_150217_b(Boolean.valueOf(true));
                server.func_184103_al().func_148539_a((ITextComponent)component);
                double x = player.field_70165_t;
                double y = player.field_70163_u + (double)player.func_70047_e();
                double z = player.field_70161_v;
                player.func_71121_q().func_184148_a(null, x, y, z, (SoundEvent)CaveSounds.RANK_PROMOTE, SoundCategory.AMBIENT, 0.5f, 1.0f);
                switch (current) {
                    case IRON_MINER: {
                        PlayerHelper.grantAdvancement((EntityPlayer)player, "iron_miner");
                        break;
                    }
                    case GOLD_MINER: {
                        PlayerHelper.grantAdvancement((EntityPlayer)player, "gold_miner");
                        break;
                    }
                    case HEXCITE_MINER: {
                        PlayerHelper.grantAdvancement((EntityPlayer)player, "hexcite_miner");
                        break;
                    }
                    case DIAMOND_MINER: {
                        PlayerHelper.grantAdvancement((EntityPlayer)player, "diamond_miner");
                        break;
                    }
                }
                if (current.getRank() >= MiningAssistConfig.minerRank.getValue()) {
                    PlayerHelper.grantToast((EntityPlayer)player, "mining_assist");
                }
            }
            MinecraftForge.EVENT_BUS.post((Event)new MinerEvent.PromoteRank(this.entityPlayer, this));
        }
    }

    @Override
    public int getRank() {
        return this.rank;
    }

    @Override
    public void setRank(int value) {
        this.setRank(value, true);
    }

    @Override
    public void setRank(int value, boolean adjust) {
        int prev = this.rank;
        this.rank = MinerRank.get(value).getRank();
        if (this.rank != prev && adjust) {
            this.adjustData();
        }
    }

    @Override
    public int getMiningAssist() {
        return this.miningAssist;
    }

    @Override
    public void setMiningAssist(int type) {
        this.setMiningAssist(type, true);
    }

    @Override
    public void setMiningAssist(int type, boolean adjust) {
        int prev = this.miningAssist;
        this.miningAssist = MiningAssist.get(type).getType();
        if (this.miningAssist != prev && adjust) {
            this.adjustData();
        }
    }

    @Override
    public void toggleMiningAssist() {
        this.setMiningAssist(this.miningAssist + 1);
    }

    @Override
    public void setMiningRecord(BlockMeta blockMeta, int count) {
        this.records.put(blockMeta, count);
    }

    @Override
    public void addMiningRecord(BlockMeta blockMeta) {
        int count = this.records.getOrDefault(blockMeta, 0);
        this.setMiningRecord(blockMeta, ++count);
    }

    @Override
    public Map<BlockMeta, Integer> getMiningRecords() {
        return this.records;
    }

    @Override
    public void adjustData() {
        CaveNetworkRegistry.sendTo(() -> new MinerDataMessage(this), this.entityPlayer);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("Point", this.getPoint());
        nbt.func_74768_a("Rank", this.getRank());
        nbt.func_74768_a("MiningAssist", this.getMiningAssist());
        NBTTagList list = new NBTTagList();
        for (Map.Entry<BlockMeta, Integer> record : this.records.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("Name", record.getKey().getBlockName());
            tag.func_74768_a("Meta", record.getKey().getMeta());
            tag.func_74768_a("Count", record.getValue().intValue());
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Records", (NBTBase)list);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.setPoint(nbt.func_74762_e("Point"), false);
        this.setRank(nbt.func_74762_e("Rank"), false);
        this.setMiningAssist(nbt.func_74762_e("MiningAssist"), false);
        NBTTagList list = nbt.func_150295_c("Records", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            this.records.put(new BlockMeta(tag.func_74779_i("Name"), tag.func_74762_e("Meta")), tag.func_74762_e("Count"));
        }
    }

    public static IMiner get(EntityPlayer player) {
        return Miner.get(player, false);
    }

    public static IMiner get(EntityPlayer player, boolean nullable) {
        return (IMiner)ObjectUtils.defaultIfNull((Object)CaveCapabilities.getCapability((ICapabilityProvider)player, CaveCapabilities.MINER), (Object)(nullable ? null : new Miner(player)));
    }

    public static void adjustData(EntityPlayerMP player) {
        IMiner miner = Miner.get((EntityPlayer)player, true);
        if (miner != null) {
            miner.adjustData();
            CaveNetworkRegistry.sendTo(() -> new MiningRecordsMessage(miner), (EntityPlayer)player);
        }
    }

    public static int getPointAmount(Block block, int meta) {
        Integer ret = (Integer)MINING_POINTS.get((Object)block, (Object)meta);
        return ret == null ? 0 : ret;
    }

    public static int getPointAmount(IBlockState state) {
        return Miner.getPointAmount(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
    }

    public static void setPointAmount(Block block, int meta, int amount) {
        if (meta == Short.MAX_VALUE) {
            for (int i = 0; i < 16; ++i) {
                MINING_POINTS.put((Object)block, (Object)i, (Object)amount);
            }
        } else {
            MINING_POINTS.put((Object)block, (Object)meta, (Object)amount);
        }
    }

    public static void setPointAmount(IBlockState state, int amount) {
        Miner.setPointAmount(state.func_177230_c(), state.func_177230_c().func_176201_c(state), amount);
    }

    public static void setPointAmount(BlockMeta blockMeta, int amount) {
        Miner.setPointAmount(blockMeta.getBlock(), blockMeta.getMeta(), amount);
    }

    public static void setPointAmount(String name, int amount) {
        NonNullList ores = OreDictionary.getOres((String)name, (boolean)false);
        if (ores.isEmpty()) {
            return;
        }
        for (ItemStack stack : ores) {
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            if (block == null || block == Blocks.field_150350_a) continue;
            Miner.setPointAmount(block, stack.func_77960_j(), amount);
        }
    }
}

