/*
 * Decompiled with CFR 0.152.
 */
package cavern.config.property;

import cavern.util.ItemMeta;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ConfigItems {
    private String[] values;
    private final Set<ItemMeta> items = Sets.newHashSet();

    public String[] getValues() {
        if (this.values == null) {
            this.values = new String[0];
        }
        return this.values;
    }

    public void setValues(String[] items) {
        this.values = items;
    }

    public Set<ItemMeta> getItems() {
        return this.items;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public String[] createValues(NonNullList<ItemStack> items) {
        TreeSet set = Sets.newTreeSet();
        for (ItemStack stack : items) {
            String registryName = stack.func_77973_b().getRegistryName().toString();
            if (stack.func_77981_g()) {
                set.add(registryName + ":" + stack.func_77960_j());
                continue;
            }
            set.add(registryName);
        }
        return set.toArray(new String[set.size()]);
    }

    public boolean hasItemStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (ItemMeta itemMeta : this.items) {
            if (itemMeta.getItem() != stack.func_77973_b()) continue;
            if (itemMeta.getHasSubtypes()) {
                if (itemMeta.getMeta() != stack.func_77960_j()) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public void refreshItems() {
        this.items.clear();
        Arrays.stream(this.getValues()).map(String::trim).filter(StringUtils::isNotEmpty).forEach(value -> {
            ItemMeta itemMeta;
            if (!value.contains(":")) {
                value = "minecraft:" + value;
            }
            if (value.indexOf(58) != value.lastIndexOf(58)) {
                int i = value.lastIndexOf(58);
                itemMeta = new ItemMeta(value.substring(0, i), NumberUtils.toInt((String)value.substring(i + 1)));
            } else {
                itemMeta = new ItemMeta((String)value, 0);
            }
            if (!itemMeta.isEmpty()) {
                this.items.add(itemMeta);
            }
        });
    }
}

