/*
 * Decompiled with CFR 0.152.
 */
package cavern.config.property;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public class ConfigEntities {
    private String[] values;
    private final Set<Class<? extends Entity>> entities = Sets.newHashSet();
    private final Set<ResourceLocation> keys = Sets.newHashSet();

    public String[] getValues() {
        if (this.values == null) {
            this.values = new String[0];
        }
        return this.values;
    }

    public void setValues(String[] entities) {
        this.values = entities;
    }

    public Set<Class<? extends Entity>> getEntities() {
        return this.entities;
    }

    public Set<ResourceLocation> getKeys() {
        return this.keys;
    }

    public boolean isEmpty() {
        return this.entities.isEmpty();
    }

    public void refreshEntities() {
        this.entities.clear();
        this.keys.clear();
        Arrays.stream(this.getValues()).map(String::trim).filter(StringUtils::isNotEmpty).map(ResourceLocation::new).forEach(value -> {
            Class entityClass = EntityList.getClass((ResourceLocation)value);
            if (entityClass != null) {
                this.entities.add(entityClass);
                this.keys.add((ResourceLocation)value);
            }
        });
    }
}

