/*
 * Decompiled with CFR 0.152.
 */
package cavern.config.property;

public class ConfigDisplayPos {
    private int value;

    public int getValue() {
        return this.value;
    }

    public void setValue(int pos) {
        this.value = pos;
    }

    public Type getType() {
        return Type.get(this.getValue());
    }

    public static enum Type {
        TOP_RIGHT(0),
        TOP_LEFT(1),
        BOTTOM_RIGHT(2),
        BOTTOM_LEFT(3),
        HIDDEN(4);

        public static final Type[] VALUES;
        private int type;

        private Type(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public boolean isTop() {
            return this == TOP_RIGHT || this == TOP_LEFT;
        }

        public boolean isBottom() {
            return this == BOTTOM_RIGHT || this == BOTTOM_LEFT;
        }

        public boolean isRight() {
            return this == TOP_RIGHT || this == BOTTOM_RIGHT;
        }

        public boolean isLeft() {
            return this == TOP_LEFT || this == BOTTOM_LEFT;
        }

        public boolean isHidden() {
            return this == HIDDEN;
        }

        public static Type get(int type) {
            int max;
            if (type < 0) {
                type = 0;
            }
            if (type > (max = VALUES.length - 1)) {
                type = max;
            }
            return VALUES[type];
        }

        static {
            VALUES = new Type[Type.values().length];
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type;
                Type.VALUES[type.getType()] = type = typeArray[i];
            }
        }
    }
}

