/*
 * Decompiled with CFR 0.152.
 */
package cavern.config.property;

import cavern.util.BlockMeta;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;

public class ConfigBlocks {
    private String[] values;
    private final Set<BlockMeta> blocks = Sets.newHashSet();

    public String[] getValues() {
        if (this.values == null) {
            this.values = new String[0];
        }
        return this.values;
    }

    public void setValues(String[] blocks) {
        this.values = blocks;
    }

    public Set<BlockMeta> getBlocks() {
        return this.blocks;
    }

    public boolean isEmpty() {
        return this.blocks.isEmpty();
    }

    public boolean hasBlock(Block block, int meta) {
        if (block == null) {
            return false;
        }
        for (BlockMeta blockMeta : this.blocks) {
            if (blockMeta.getBlock() != block) continue;
            if (meta < 0 || meta == Short.MAX_VALUE) {
                return true;
            }
            if (blockMeta.getMeta() != meta) continue;
            return true;
        }
        return false;
    }

    public boolean hasBlockState(IBlockState state) {
        if (state == null) {
            return false;
        }
        Block block = state.func_177230_c();
        return this.hasBlock(block, block.func_176201_c(state));
    }

    public void refreshBlocks() {
        this.blocks.clear();
        Arrays.stream(this.getValues()).map(String::trim).filter(StringUtils::isNotEmpty).forEach(value -> {
            if (OreDictionary.doesOreNameExist((String)value)) {
                for (ItemStack stack : OreDictionary.getOres((String)value, (boolean)false)) {
                    Block block;
                    if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBlock) || (block = ((ItemBlock)stack.func_77973_b()).func_179223_d()) == null) continue;
                    this.blocks.add(new BlockMeta(block, stack.func_77960_j()));
                }
            } else {
                BlockMeta blockMeta;
                if (!value.contains(":")) {
                    value = "minecraft:" + value;
                }
                if (value.indexOf(58) != value.lastIndexOf(58)) {
                    int i = value.lastIndexOf(58);
                    blockMeta = new BlockMeta(value.substring(0, i), value.substring(i + 1));
                } else {
                    blockMeta = new BlockMeta((String)value, 0);
                }
                if (blockMeta.getBlock() != null) {
                    this.blocks.add(blockMeta);
                }
            }
        });
    }
}

