/*
 * Decompiled with CFR 0.152.
 */
package cavern.config.manager;

import cavern.config.manager.CaveBiome;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.config.Configuration;

public class CaveBiomeManager {
    private final Map<Biome, CaveBiome> CAVE_BIOMES = Maps.newHashMap();
    public Configuration config;

    public boolean addCaveBiome(CaveBiome biomeEntry) {
        return this.addCaveBiome(biomeEntry, false);
    }

    public boolean addCaveBiome(CaveBiome biomeEntry, boolean absent) {
        Biome biome = biomeEntry.getBiome();
        if (absent) {
            if (this.getCaveBiomes().containsKey(biome)) {
                return false;
            }
            this.getCaveBiomes().put(biome, biomeEntry);
            return true;
        }
        return this.getCaveBiomes().put(biome, biomeEntry) != biomeEntry;
    }

    @Nullable
    public CaveBiome getCaveBiome(Biome biome) {
        return this.getCaveBiome(biome, false);
    }

    public CaveBiome getCaveBiome(Biome biome, boolean identity) {
        CaveBiome ret = this.getCaveBiomes().get(biome);
        if (identity && ret == null) {
            return new CaveBiome(biome, 50);
        }
        return ret;
    }

    public CaveBiome getRandomCaveBiome(Random random) {
        return (CaveBiome)WeightedRandom.func_76271_a((Random)random, (List)Lists.newArrayList(this.getCaveBiomes().values()));
    }

    public Biome getRandomBiome(Random random, Biome defaultBiome) {
        CaveBiome caveBiome = this.getRandomCaveBiome(random);
        if (caveBiome != null) {
            return caveBiome.getBiome();
        }
        return defaultBiome;
    }

    public Map<Biome, CaveBiome> getCaveBiomes() {
        return this.CAVE_BIOMES;
    }
}

