/*
 * Decompiled with CFR 0.152.
 */
package cavern.config;

import cavern.client.config.CaveConfigEntries;
import cavern.config.Config;
import cavern.config.property.ConfigCaveborn;
import cavern.config.property.ConfigItems;
import cavern.config.property.ConfigMiningPoints;
import cavern.core.Cavern;
import cavern.util.CaveUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;

public class GeneralConfig {
    public static Configuration config;
    public static boolean versionNotify;
    public static ConfigItems miningPointItems;
    public static ConfigMiningPoints miningPoints;
    public static boolean miningCombo;
    public static boolean criticalMining;
    public static ConfigCaveborn caveborn;
    public static ConfigItems cavebornBonusItems;
    public static int findPortalRange;
    public static boolean portalCache;
    public static boolean portalMenu;
    public static boolean generousRandomite;
    public static ConfigItems randomiteExcludeItems;
    public static int sleepWaitTime;
    public static boolean sleepRefresh;
    protected static final Side SIDE;

    public static void syncConfig() {
        String category = "general";
        ArrayList propOrder = Lists.newArrayList();
        if (config == null) {
            config = Config.loadConfig(category);
        }
        Property prop = config.get(category, "versionNotify", true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        String comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, does not have to match client-side and server-side.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        versionNotify = prop.getBoolean(versionNotify);
        prop = config.get(category, "miningPointItems", new String[0]);
        prop.setConfigEntryClass(CaveConfigEntries.selectItems);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        miningPointItems.setValues(prop.getStringList());
        miningPoints.setInit(!config.getCategory(category).containsKey("miningPoints"));
        prop = config.get(category, "miningPoints", new String[0]);
        prop.setConfigEntryClass(CaveConfigEntries.miningPoints);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        miningPoints.setValues(prop.getStringList());
        prop = config.get(category, "miningCombo", true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, does not have to match client-side and server-side.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        miningCombo = prop.getBoolean(miningCombo);
        prop = config.get(category, "criticalMining", true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        criticalMining = prop.getBoolean(criticalMining);
        prop = config.get(category, "caveborn", ConfigCaveborn.Type.DISABLED.ordinal());
        prop.setMinValue(0).setMaxValue(ConfigCaveborn.Type.values().length - 1).setConfigEntryClass(CaveConfigEntries.cycleInteger);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [range: " + prop.getMinValue() + " ~ " + prop.getMaxValue() + ", default: " + prop.getDefault() + "]";
        int min = Integer.parseInt(prop.getMinValue());
        int max = Integer.parseInt(prop.getMaxValue());
        for (int i = min; i <= max; ++i) {
            comment = comment + Configuration.NEW_LINE + i + ": " + Cavern.proxy.translate(prop.getLanguageKey() + "." + i);
            if (i >= max) continue;
            comment = comment + ",";
        }
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        caveborn.setValue(prop.getInt(caveborn.getValue()));
        NonNullList items = NonNullList.func_191196_a();
        items.add((Object)new ItemStack(Items.field_151050_s));
        items.add((Object)new ItemStack(Items.field_151052_q));
        items.add((Object)new ItemStack(Blocks.field_150478_aa));
        items.add((Object)new ItemStack(Items.field_151025_P));
        prop = config.get(category, "cavebornBonusItems", cavebornBonusItems.createValues((NonNullList<ItemStack>)items));
        prop.setConfigEntryClass(CaveConfigEntries.selectBlocksAndItems);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        cavebornBonusItems.setValues(prop.getStringList());
        prop = config.get(category, "findPortalRange", 32);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        findPortalRange = prop.getInt(findPortalRange);
        prop = config.get(category, "portalCache", false);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        portalCache = prop.getBoolean(portalCache);
        prop = config.get(category, "portalMenu", true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        portalMenu = prop.getBoolean(portalMenu);
        prop = config.get(category, "generousRandomite", false);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        generousRandomite = prop.getBoolean(generousRandomite);
        items = NonNullList.func_191196_a();
        items.add((Object)new ItemStack(Blocks.field_150357_h));
        items.add((Object)new ItemStack(Blocks.field_150474_ac));
        prop = config.get(category, "randomiteExcludeItems", randomiteExcludeItems.createValues((NonNullList<ItemStack>)items));
        prop.setConfigEntryClass(CaveConfigEntries.selectBlocksAndItems);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        randomiteExcludeItems.setValues(prop.getStringList());
        prop = config.get(category, "sleepWaitTime", 300);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        sleepWaitTime = prop.getInt(sleepWaitTime);
        prop = config.get(category, "sleepRefresh", true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        sleepRefresh = prop.getBoolean(sleepRefresh);
        config.setCategoryPropertyOrder(category, (List)propOrder);
        Config.saveConfig(config);
    }

    public static boolean isMiningPointItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (miningPointItems.isEmpty()) {
            return CaveUtils.isPickaxe(stack);
        }
        return miningPointItems.hasItemStack(stack);
    }

    static {
        miningPointItems = new ConfigItems();
        miningPoints = new ConfigMiningPoints();
        caveborn = new ConfigCaveborn();
        cavebornBonusItems = new ConfigItems();
        randomiteExcludeItems = new ConfigItems();
        SIDE = FMLLaunchHandler.side();
    }
}

