/*
 * Decompiled with CFR 0.152.
 */
package cavern.config;

import cavern.util.CaveLog;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import org.apache.logging.log4j.Level;

public class ConfigChecker
implements FilenameFilter {
    public static final String CONFIG_VERSION = "2.0";
    private final File internalFile;
    private final File configDir;
    private Properties properties;
    private boolean isUpdated;
    private boolean isNotified;

    public ConfigChecker(File file, File dir) {
        this.internalFile = file;
        this.configDir = dir;
    }

    @Nullable
    public Properties getProperties() {
        return this.properties;
    }

    public boolean isUpdated() {
        return this.isUpdated;
    }

    public boolean isNotified() {
        return this.isNotified;
    }

    public void setNotified(boolean notify) {
        this.isNotified = notify;
    }

    public boolean isOutdated() {
        String value;
        if (!this.internalFile.exists()) {
            return true;
        }
        if (this.properties == null || !this.properties.containsKey("config.version")) {
            this.properties = new Properties();
            try (FileInputStream stream = new FileInputStream(this.internalFile);){
                this.properties.load(stream);
            }
            catch (IOException e) {
                CaveLog.log(Level.WARN, e, "An error occurred reading the %s file.", this.internalFile.getName());
            }
        }
        if ((value = this.properties.getProperty("config.update", "true").toLowerCase(Locale.ENGLISH)).equals("false") || value.equals("0")) {
            return false;
        }
        value = this.properties.getProperty("config.version");
        if (Strings.isNullOrEmpty((String)value)) {
            return true;
        }
        ComparableVersion configVersion = new ComparableVersion(CONFIG_VERSION);
        ComparableVersion currentVersion = new ComparableVersion(value);
        return configVersion.compareTo(currentVersion) > 0;
    }

    public void updateFile() {
        if (this.internalFile.exists()) {
            this.internalFile.delete();
        }
        this.properties = new Properties();
        this.properties.setProperty("config.version", CONFIG_VERSION);
        this.properties.setProperty("config.update", "true");
        try (FileOutputStream stream = new FileOutputStream(this.internalFile);){
            this.properties.store(stream, null);
        }
        catch (IOException e) {
            CaveLog.log(Level.WARN, e, "An error occurred writing the %s file.", this.internalFile.getName());
        }
    }

    public boolean updateConfigFiles() {
        if (!this.isOutdated()) {
            return false;
        }
        this.updateFile();
        for (File file : this.configDir.listFiles(this)) {
            if (!file.delete()) continue;
            this.isUpdated = true;
        }
        return this.isUpdated;
    }

    @Override
    public boolean accept(File dir, String name) {
        return !Strings.isNullOrEmpty((String)name) && name.endsWith(".cfg");
    }
}

