/*
 * Decompiled with CFR 0.152.
 */
package cavern.config;

import cavern.block.BlockCave;
import cavern.block.CaveBlocks;
import cavern.config.CavernConfig;
import cavern.config.Config;
import cavern.config.manager.CaveVein;
import cavern.config.manager.CaveVeinManager;
import cavern.core.Cavern;
import cavern.util.BlockMeta;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.io.FileUtils;

public class CavelandConfig {
    public static Configuration config;
    public static int dimensionId;
    public static int worldHeight;
    public static boolean generateRiver;
    public static boolean generateLakes;
    public static int monsterSpawn;
    public static double caveBrightness;
    public static boolean autoVeins;
    public static final CaveVeinManager VEINS;

    public static void syncConfig() {
        String category = "dimension";
        ArrayList propOrder = Lists.newArrayList();
        if (config == null) {
            config = Config.loadConfig("caveland", category);
        }
        Property prop = config.get(category, "dimension", -53);
        prop.setRequiresMcRestart(true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        String comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        dimensionId = prop.getInt(dimensionId);
        prop = config.get(category, "worldHeight", 256);
        prop.setMinValue(64).setMaxValue(256);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [range: " + prop.getMinValue() + " ~ " + prop.getMaxValue() + ", default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        worldHeight = prop.getInt(worldHeight);
        prop = config.get(category, "generateRiver", true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        generateRiver = prop.getBoolean(generateRiver);
        prop = config.get(category, "generateLakes", true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        generateLakes = prop.getBoolean(generateLakes);
        prop = config.get(category, "monsterSpawn", 150);
        prop.setMinValue(0).setMaxValue(5000);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [range: " + prop.getMinValue() + " ~ " + prop.getMaxValue() + ", default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        monsterSpawn = prop.getInt(monsterSpawn);
        prop = config.get(category, "caveBrightness", 0.075);
        prop.setMinValue(0.0).setMaxValue(1.0);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [range: " + prop.getMinValue() + " ~ " + prop.getMaxValue() + ", default: " + prop.getDefault() + "]";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        caveBrightness = prop.getDouble(caveBrightness);
        prop = config.get(category, "autoVeins", false);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        autoVeins = prop.getBoolean(autoVeins);
        config.setCategoryPropertyOrder(category, (List)propOrder);
        Config.saveConfig(config);
    }

    public static void syncVeinsConfig() {
        if (CavelandConfig.VEINS.config == null) {
            CavelandConfig.VEINS.config = Config.loadConfig("caveland", "veins");
        } else {
            VEINS.getCaveVeins().clear();
        }
        if (CavelandConfig.VEINS.config.getCategoryNames().isEmpty()) {
            ArrayList veins = Lists.newArrayList();
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150365_q, 0), 30, 17, 1, 127, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150365_q, 0), 20, 15, 1, 10, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150366_p, 0), 30, 10, 1, 127, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150366_p, 0), 20, 8, 1, 10, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150351_n, 0), 30, 20, 1, 127, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150351_n, 0), 10, 10, 1, 10, new Object[0]));
            veins.add(new CaveVein(new BlockMeta((Block)Blocks.field_150354_m, BlockSand.EnumType.SAND.func_176688_a()), 20, 20, 1, 127, new Object[0]));
            veins.add(new CaveVein(new BlockMeta((Block)Blocks.field_150354_m, BlockSand.EnumType.SAND.func_176688_a()), 7, 10, 1, 10, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.FISSURED_STONE.getMetadata()), 30, 2, 1, 10, new Object[0]));
            CavernConfig.generateVeinsConfig(VEINS, veins);
        } else if (CavernConfig.addVeinsFromConfig(VEINS)) {
            try {
                FileUtils.forceDelete((File)new File(CavelandConfig.VEINS.config.toString()));
                VEINS.getCaveVeins().clear();
                CavelandConfig.VEINS.config = null;
                CavelandConfig.syncVeinsConfig();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Config.saveConfig(CavelandConfig.VEINS.config);
    }

    static {
        VEINS = new CaveVeinManager();
    }
}

