/*
 * Decompiled with CFR 0.152.
 */
package cavern.config;

import cavern.util.CaveLog;
import cavern.util.CaveUtils;
import com.google.common.collect.Maps;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.TreeMap;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.Level;

public class CaveConfiguration
extends Configuration
implements Comparator<String> {
    public CaveConfiguration() {
    }

    public CaveConfiguration(File file) {
        super(file);
    }

    public CaveConfiguration(File file, String configVersion) {
        super(file, configVersion);
    }

    public CaveConfiguration(File file, String configVersion, boolean caseSensitiveCustomCategories) {
        super(file, configVersion, caseSensitiveCustomCategories);
    }

    public CaveConfiguration(File file, boolean caseSensitiveCustomCategories) {
        super(file, caseSensitiveCustomCategories);
    }

    public void save() {
        this.setNewCategoriesMap();
        super.save();
    }

    private void setNewCategoriesMap() {
        try {
            Field field = Configuration.class.getDeclaredField("categories");
            field.setAccessible(true);
            TreeMap treeMap = (TreeMap)field.get(this);
            TreeMap newMap = Maps.newTreeMap((Comparator)this);
            newMap.putAll(treeMap);
            field.set(this, newMap);
        }
        catch (Throwable e) {
            CaveLog.log(Level.WARN, e, "An error occurred on replace configuration categories map.", new Object[0]);
        }
    }

    @Override
    public int compare(String o1, String o2) {
        boolean flag2;
        boolean flag1;
        int result = CaveUtils.compareWithNull(o1, o2);
        if (result == 0 && o1 != null && o2 != null && (result = Boolean.compare(flag1 = NumberUtils.isCreatable((String)o1), flag2 = NumberUtils.isCreatable((String)o2))) == 0) {
            if (flag1 && flag2) {
                result = Integer.compare(NumberUtils.toInt((String)o1), NumberUtils.toInt((String)o2));
            } else if (!flag1 && !flag2) {
                result = o1.compareTo(o2);
            }
        }
        return result;
    }
}

