/*
 * Decompiled with CFR 0.152.
 */
package cavern.client.renderer;

import cavern.entity.passive.EntityDurangHog;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelDurangHog
extends ModelBase {
    private float headRotationAngleX;
    private float childYOffset = 4.0f;
    private float childZOffset = 4.0f;
    private ModelRenderer head;
    private ModelRenderer nose;
    private ModelRenderer legR;
    private ModelRenderer backLegR;
    private ModelRenderer legL;
    private ModelRenderer backLegL;
    private ModelRenderer body;
    private ModelRenderer fangR;
    private ModelRenderer fangL;

    public ModelDurangHog() {
        this.field_78090_t = 64;
        this.field_78089_u = 32;
        this.legL = new ModelRenderer((ModelBase)this, 0, 16);
        this.legL.func_78793_a(3.0f, 18.0f, -5.0f);
        this.legL.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 6, 4, 0.0f);
        this.backLegL = new ModelRenderer((ModelBase)this, 0, 16);
        this.backLegL.func_78793_a(3.0f, 18.0f, 7.0f);
        this.backLegL.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 6, 4, 0.0f);
        this.backLegR = new ModelRenderer((ModelBase)this, 0, 16);
        this.backLegR.func_78793_a(-3.0f, 18.0f, 7.0f);
        this.backLegR.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 6, 4, 0.0f);
        this.nose = new ModelRenderer((ModelBase)this, 16, 16);
        this.nose.func_78793_a(0.0f, 12.0f, -6.0f);
        this.nose.func_78790_a(-2.0f, 0.0f, -9.0f, 4, 3, 1, 0.0f);
        this.legR = new ModelRenderer((ModelBase)this, 0, 16);
        this.legR.func_78793_a(-3.0f, 18.0f, -5.0f);
        this.legR.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 6, 4, 0.0f);
        this.body = new ModelRenderer((ModelBase)this, 28, 8);
        this.body.func_78793_a(0.0f, 11.0f, 2.0f);
        this.body.func_78790_a(-5.0f, -10.0f, -7.0f, 10, 16, 8, 0.0f);
        this.setRotateAngle(this.body, 1.5707964f, 0.0f, 0.0f);
        this.fangR = new ModelRenderer((ModelBase)this, 0, 0);
        this.fangR.func_78793_a(-2.0f, 2.1f, -8.5f);
        this.fangR.func_78790_a(-1.0f, -3.0f, -0.5f, 1, 3, 1, 0.0f);
        this.setRotateAngle(this.fangR, 0.3642502f, 0.0f, 0.0f);
        this.fangL = new ModelRenderer((ModelBase)this, 0, 0);
        this.fangL.func_78793_a(2.0f, 2.1f, -8.5f);
        this.fangL.func_78790_a(0.0f, -3.0f, -0.5f, 1, 3, 1, 0.0f);
        this.setRotateAngle(this.fangL, 0.3642502f, 0.0f, 0.0f);
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.func_78793_a(0.0f, 12.0f, -6.0f);
        this.head.func_78790_a(-4.0f, -4.0f, -8.0f, 8, 8, 8, 0.0f);
        this.nose.func_78792_a(this.fangR);
        this.nose.func_78792_a(this.fangL);
    }

    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (this.field_78091_s) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)(this.childYOffset * scale), (float)(this.childZOffset * scale));
            this.head.func_78785_a(scale);
            this.nose.func_78785_a(scale);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179109_b((float)0.0f, (float)(24.0f * scale), (float)0.0f);
            this.body.func_78785_a(scale);
            this.legR.func_78785_a(scale);
            this.legL.func_78785_a(scale);
            this.backLegL.func_78785_a(scale);
            this.backLegR.func_78785_a(scale);
            GlStateManager.func_179121_F();
        } else {
            this.head.func_78785_a(scale);
            this.nose.func_78785_a(scale);
            this.body.func_78785_a(scale);
            this.legR.func_78785_a(scale);
            this.legL.func_78785_a(scale);
            this.backLegL.func_78785_a(scale);
            this.backLegR.func_78785_a(scale);
        }
    }

    public void func_78086_a(EntityLivingBase entity, float limbSwing, float limbSwingAmount, float partialTickTime) {
        super.func_78086_a(entity, limbSwing, limbSwingAmount, partialTickTime);
        this.headRotationAngleX = ((EntityDurangHog)entity).getHeadRotationAngleX(partialTickTime);
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entity) {
        super.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entity);
        this.head.field_78795_f = this.headRotationAngleX;
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.body.field_78795_f = 1.5707964f;
        this.legR.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.legL.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.backLegR.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.backLegL.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        ModelDurangHog.func_178685_a((ModelRenderer)this.head, (ModelRenderer)this.nose);
    }

    public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

