/*
 * Decompiled with CFR 0.152.
 */
package cavern.client.handler;

import cavern.client.CaveKeyBindings;
import cavern.client.particle.ParticleMagicSpell;
import cavern.handler.CaveEventHooks;
import cavern.item.ItemMagicBook;
import cavern.magic.Magic;
import cavern.magic.MagicBook;
import cavern.magic.MagicInfinity;
import cavern.magic.SpecialMagic;
import cavern.network.CaveNetworkRegistry;
import cavern.network.server.MagicBookMessage;
import cavern.network.server.MagicResultMessage;
import cavern.network.server.SpecialMagicMessage;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public final class MagicEventHooks {
    private final Random rand = CaveEventHooks.RANDOM;
    private int spellingSlot;
    private int spellingSoundTicks;
    private EnumActionResult spellingResult;
    private boolean sendResult;

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        Magic magic;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc.field_71441_e == null || mc.field_71439_g == null || mc.field_71462_r != null) {
            return;
        }
        MagicBook book = MagicBook.get((EntityPlayer)mc.field_71439_g);
        boolean isMagicKeyDown = CaveKeyBindings.KEY_MAGIC_BOOK.func_151470_d();
        if (isMagicKeyDown || mc.field_71474_y.field_74313_G.func_151470_d()) {
            boolean infinity;
            ItemStack stack = book.getSpellingMagicBook();
            Magic magic2 = book.getSpellingMagic();
            if (this.spellingResult != null && this.spellingResult != EnumActionResult.PASS) {
                if (!this.sendResult) {
                    if (magic2 != null) {
                        if (this.spellingResult == EnumActionResult.SUCCESS) {
                            ActionResult<ITextComponent> result = magic2.fireMagic();
                            CaveNetworkRegistry.NETWORK.sendToServer((IMessage)new MagicResultMessage(result.func_188397_a()));
                            ITextComponent message = (ITextComponent)result.func_188398_b();
                            if (message != null) {
                                mc.field_71456_v.func_175188_a(message, true);
                            }
                            if (magic2.isOverload()) {
                                book.setSpecialMagic(null);
                            }
                        } else {
                            CaveNetworkRegistry.NETWORK.sendToServer((IMessage)new MagicResultMessage(EnumActionResult.FAIL));
                        }
                        magic2.onCloseBook();
                        SoundEvent sound = magic2.getCloseSound();
                        if (sound != null) {
                            mc.func_147118_V().func_147681_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)sound, (float)1.0f), 5);
                        }
                    }
                    book.setSpellingMagic(null);
                    this.sendResult = true;
                }
                return;
            }
            if (book.isSpellingCanceled()) {
                this.spellingResult = EnumActionResult.FAIL;
                return;
            }
            if (magic2 == null) {
                Pair<EnumHand, ItemStack> magicBook = this.getMagicBook((EntityPlayer)mc.field_71439_g);
                if (magicBook == null) {
                    this.spellingResult = EnumActionResult.FAIL;
                    return;
                }
                stack = (ItemStack)magicBook.getRight();
                magic2 = ItemMagicBook.EnumType.byItemStack(stack).createMagic((World)mc.field_71441_e, (EntityPlayer)mc.field_71439_g, (EnumHand)magicBook.getLeft());
                if (magic2 == null) {
                    this.spellingResult = EnumActionResult.FAIL;
                    return;
                }
                book.setSpellingMagic(magic2);
                if (magic2.getSpellingHand() == EnumHand.MAIN_HAND) {
                    this.spellingSlot = mc.field_71439_g.field_71071_by.field_70461_c;
                }
                CaveNetworkRegistry.NETWORK.sendToServer((IMessage)new MagicBookMessage(magic2.getSpellingHand()));
            }
            boolean hasSpecialMagic = book.getSpecialMagic() != null;
            boolean bl = infinity = hasSpecialMagic && book.getSpecialMagic() instanceof MagicInfinity;
            if (hasSpecialMagic && magic2 instanceof SpecialMagic) {
                this.spellingResult = EnumActionResult.FAIL;
                return;
            }
            if (!mc.field_71439_g.field_71075_bZ.field_75098_d && ItemMagicBook.isInCoolTime((EntityPlayer)mc.field_71439_g, stack)) {
                mc.field_71456_v.func_175188_a((ITextComponent)new TextComponentTranslation("item.magicBook.fail.time", new Object[0]), false);
                this.spellingResult = EnumActionResult.FAIL;
                return;
            }
            if (magic2.getSpellingHand() == EnumHand.MAIN_HAND) {
                mc.field_71439_g.field_71071_by.field_70461_c = this.spellingSlot;
            }
            double progress = magic2.getSpellingProgress();
            if (infinity) {
                progress = MathHelper.func_151237_a((double)(progress * 2.5), (double)0.0, (double)1.0);
            }
            if (progress >= 1.0) {
                this.spellingResult = EnumActionResult.SUCCESS;
                return;
            }
            EnumActionResult result = magic2.onSpelling();
            if (result != EnumActionResult.PASS) {
                this.spellingResult = result;
                return;
            }
            if (++this.spellingSoundTicks >= (infinity ? 8 : 12)) {
                SoundEvent sound = magic2.getSpellingSound();
                if (sound != null) {
                    mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)sound, (float)1.0f));
                }
                this.spellingSoundTicks = 0;
            }
            for (int i = 0; i < 2; ++i) {
                int var1 = this.rand.nextInt(2) * 2 - 1;
                int var2 = this.rand.nextInt(2) * 2 - 1;
                double ptX = mc.field_71439_g.field_70165_t + 0.25 * (double)var1;
                double ptY = mc.field_71439_g.field_70163_u + 0.7 + (double)this.rand.nextFloat();
                double ptZ = mc.field_71439_g.field_70161_v + 0.25 * (double)var2;
                double motionX = this.rand.nextFloat() * 1.0f * (float)var1;
                double motionY = ((double)this.rand.nextFloat() - 0.25) * 0.125;
                double motionZ = this.rand.nextFloat() * 1.0f * (float)var2;
                ParticleMagicSpell particle = new ParticleMagicSpell((World)mc.field_71441_e, ptX, ptY, ptZ, motionX, motionY, motionZ);
                mc.field_71452_i.func_78873_a((Particle)particle);
            }
        } else {
            magic = book.getSpellingMagic();
            if (magic != null) {
                CaveNetworkRegistry.NETWORK.sendToServer((IMessage)new MagicResultMessage(EnumActionResult.FAIL));
                magic.onCloseBook();
                SoundEvent sound = magic.getCloseSound();
                if (sound != null) {
                    mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)sound, (float)1.0f));
                }
            }
            book.setSpellingMagic(null);
            this.spellingResult = null;
            this.spellingSlot = 0;
            this.spellingSoundTicks = 0;
            this.sendResult = false;
        }
        magic = book.getSpecialMagic();
        if (magic != null && ((SpecialMagic)magic).getEffectProgress() >= 1.0) {
            ITextComponent message = ((SpecialMagic)magic).finishMagic();
            if (message != null) {
                mc.field_71456_v.func_175188_a(message, false);
            }
            CaveNetworkRegistry.NETWORK.sendToServer((IMessage)new SpecialMagicMessage());
            book.setSpecialMagic(null);
        }
    }

    @Nullable
    private Pair<EnumHand, ItemStack> getMagicBook(EntityPlayer player) {
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemMagicBook && ItemMagicBook.getMana(stack) > 0) {
            return Pair.of((Object)EnumHand.MAIN_HAND, (Object)stack);
        }
        stack = player.func_184592_cb();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemMagicBook && ItemMagicBook.getMana(stack) > 0) {
            return Pair.of((Object)EnumHand.OFF_HAND, (Object)stack);
        }
        return null;
    }
}

