/*
 * Decompiled with CFR 0.152.
 */
package cavern.client.gui;

import cavern.util.BlockMeta;
import cavern.util.CaveLog;
import cavern.util.ItemMeta;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class SelectListHelper {
    protected static final NonNullList<BlockMeta> BLOCKS = NonNullList.func_191196_a();
    protected static final NonNullList<ItemMeta> ITEMS = NonNullList.func_191196_a();

    public static void setupBlocks() {
        NonNullList subList = NonNullList.func_191196_a();
        for (Block block : ForgeRegistries.BLOCKS.getValuesCollection()) {
            try {
                Item item;
                if (block instanceof BlockAir || block instanceof ITileEntityProvider || (item = Item.func_150898_a((Block)block)) == Items.field_190931_a || block != Block.func_149634_a((Item)item)) continue;
                subList.clear();
                block.func_149666_a(CreativeTabs.field_78027_g, subList);
                for (ItemStack stack : subList) {
                    BlockMeta blockMeta;
                    IBlockState state;
                    int meta;
                    if (stack.func_190926_b() || stack.func_77973_b() != item || (meta = stack.func_77952_i()) != block.func_176201_c(state = block.func_176203_a(meta)) || BLOCKS.contains((Object)(blockMeta = new BlockMeta(block, meta)))) continue;
                    BLOCKS.add((Object)blockMeta);
                }
            }
            catch (Exception e) {
                CaveLog.log(Level.ERROR, "An error occurred while setup. Skip: %s", block.toString());
            }
        }
    }

    public static void setupItems() {
        NonNullList subList = NonNullList.func_191196_a();
        for (Item item : ForgeRegistries.ITEMS.getValuesCollection()) {
            try {
                if (item == Items.field_190931_a) continue;
                subList.clear();
                item.func_150895_a(CreativeTabs.field_78027_g, subList);
                for (ItemStack stack : subList) {
                    ItemMeta itemMeta = new ItemMeta(stack);
                    if (ITEMS.contains((Object)itemMeta)) continue;
                    ITEMS.add((Object)itemMeta);
                }
            }
            catch (Exception e) {
                CaveLog.log(Level.ERROR, "An error occurred while setup. Skip: %s", item.toString());
            }
        }
    }
}

