/*
 * Decompiled with CFR 0.152.
 */
package cavern.client.gui;

import cavern.block.CaveBlocks;
import cavern.client.gui.GuiListSlot;
import cavern.item.ItemMirageBook;
import cavern.network.CaveNetworkRegistry;
import cavern.network.server.MirageTeleportMessage;
import cavern.util.PanoramaPaths;
import cavern.world.CaveDimensions;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.DimensionType;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class GuiSelectMirageWorld
extends GuiScreen {
    protected WorldList worldList;
    protected GuiButton doneButton;
    public final Set<DimensionType> dimensions = Sets.newHashSet();

    public void func_73866_w_() {
        if (this.worldList == null) {
            this.worldList = new WorldList();
        }
        this.worldList.func_148122_a(this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - 28);
        if (this.doneButton == null) {
            this.doneButton = new GuiButtonExt(0, 0, 0, 145, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        }
        this.doneButton.field_146128_h = this.field_146294_l / 2 - this.doneButton.field_146120_f / 2;
        this.doneButton.field_146129_i = this.field_146295_m - this.doneButton.field_146121_g - 4;
        this.field_146292_n.clear();
        this.field_146292_n.add(this.doneButton);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l && button.field_146127_k == 0) {
            if (this.worldList.selected != null) {
                CaveNetworkRegistry.NETWORK.sendToServer((IMessage)new MirageTeleportMessage((DimensionType)this.worldList.selected.getLeft()));
            }
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        }
    }

    public void func_73876_c() {
        if (this.worldList.selected == null) {
            this.doneButton.field_146124_l = true;
        } else if (!this.dimensions.isEmpty()) {
            this.doneButton.field_146124_l = this.dimensions.contains(this.worldList.selected.getLeft());
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.worldList.func_148128_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)(CaveBlocks.MIRAGE_PORTAL.func_149739_a() + ".select"), (Object[])new Object[0]), this.field_146294_l / 2, 15, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.worldList.func_178039_p();
    }

    protected void func_73869_a(char c, int code) throws IOException {
        if (code == 1) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        } else if (code == 14) {
            this.worldList.selected = null;
        } else if (code == 200) {
            this.worldList.scrollUp();
        } else if (code == 208) {
            this.worldList.scrollDown();
        } else if (code == 199) {
            this.worldList.scrollToTop();
        } else if (code == 207) {
            this.worldList.scrollToEnd();
        } else if (code == 57) {
            this.worldList.scrollToSelected();
        } else if (code == 201) {
            this.worldList.scrollToPrev();
        } else if (code == 209) {
            this.worldList.scrollToNext();
        } else if (code == 28) {
            this.func_146284_a(this.doneButton);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected class WorldList
    extends GuiListSlot
    implements Comparator<Pair<DimensionType, ItemStack>> {
        protected final NonNullList<Pair<DimensionType, ItemStack>> types;
        protected boolean clickFlag;
        protected Pair<DimensionType, ItemStack> selected;

        protected WorldList() {
            ItemStack stack;
            super(GuiSelectMirageWorld.this.field_146297_k, 0, 0, 0, 0, 18);
            this.types = NonNullList.func_191196_a();
            DimensionType select = null;
            Iterator iterator = this.field_148161_k.field_71439_g.func_184214_aD().iterator();
            while (iterator.hasNext() && ((stack = (ItemStack)iterator.next()).func_190926_b() || !(stack.func_77973_b() instanceof ItemMirageBook) || (select = ItemMirageBook.EnumType.byItemStack(stack).getDimension()) == null)) {
            }
            this.loadEntries((NonNullList<ItemStack>)this.field_148161_k.field_71439_g.field_71071_by.field_70462_a, select);
            this.loadEntries((NonNullList<ItemStack>)this.field_148161_k.field_71439_g.field_71071_by.field_184439_c, select);
            this.types.sort((Comparator)this);
        }

        public void loadEntries(NonNullList<ItemStack> list, @Nullable DimensionType select) {
            HashSet dimensions = Sets.newHashSet();
            for (ItemStack stack : list) {
                DimensionType type;
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemMirageBook) || (type = ItemMirageBook.EnumType.byItemStack(stack).getDimension()) == null || !dimensions.add(type)) continue;
                Pair entry = Pair.of((Object)type, (Object)stack);
                this.types.add((Object)entry);
                if (select == null || type != select) continue;
                this.selected = entry;
            }
        }

        @Override
        public PanoramaPaths getPanoramaPaths() {
            return null;
        }

        @Override
        public void scrollToSelected() {
            if (this.selected != null) {
                int amount = this.types.indexOf(this.selected) * this.func_148146_j();
                if (this.func_148148_g() != amount) {
                    return;
                }
                this.scrollToTop();
                this.func_148145_f(amount);
            }
        }

        protected int func_148127_b() {
            return this.types.size();
        }

        protected void func_148123_a() {
            GuiSelectMirageWorld.this.func_146276_q_();
        }

        protected void func_192637_a(int slot, int par2, int par3, int par4, int mouseX, int mouseY, float partialTicks) {
            Pair entry = (Pair)this.types.get(slot);
            DimensionType type = (DimensionType)entry.getLeft();
            ItemStack stack = (ItemStack)entry.getRight();
            GuiSelectMirageWorld.this.func_73732_a(GuiSelectMirageWorld.this.field_146289_q, CaveDimensions.getLocalizedName(type), this.field_148155_a / 2, par3 + 1, 0xFFFFFF);
            this.drawItemStack(GuiSelectMirageWorld.this.field_146296_j, stack, this.field_148155_a / 2 - 100, par3 - 1);
        }

        protected void func_148144_a(int slot, boolean flag, int mouseX, int mouseY) {
            Pair entry = (Pair)this.types.get(slot);
            this.clickFlag = !this.clickFlag;
            if (this.clickFlag) {
                this.selected = this.selected == entry ? null : entry;
            }
        }

        protected boolean func_148131_a(int slot) {
            return this.selected == this.types.get(slot);
        }

        @Override
        public int compare(Pair<DimensionType, ItemStack> o1, Pair<DimensionType, ItemStack> o2) {
            return Integer.compareUnsigned(((DimensionType)o2.getLeft()).func_186068_a(), ((DimensionType)o1.getLeft()).func_186068_a());
        }
    }
}

