/*
 * Decompiled with CFR 0.152.
 */
package cavern.client.gui;

import cavern.client.config.CaveConfigGui;
import cavern.client.gui.GuiListSlot;
import cavern.client.gui.ISelectorCallback;
import cavern.client.gui.SelectListHelper;
import cavern.util.CaveFilters;
import cavern.util.ItemMeta;
import cavern.util.PanoramaPaths;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.math.NumberUtils;

@SideOnly(value=Side.CLIENT)
public class GuiSelectItem
extends GuiScreen {
    protected final GuiScreen parent;
    protected ISelectorCallback<ItemMeta> selectorCallback;
    protected GuiTextField nameField;
    protected GuiTextField metaField;
    protected GuiConfigEntries.ArrayEntry arrayEntry;
    protected ItemList itemList;
    protected GuiButton doneButton;
    protected GuiCheckBox detailInfo;
    protected GuiCheckBox instantFilter;
    protected GuiTextField filterTextField;
    protected HoverChecker selectedHoverChecker;
    protected HoverChecker detailHoverChecker;
    protected HoverChecker instantHoverChecker;

    public GuiSelectItem(GuiScreen parent) {
        this.parent = parent;
    }

    public GuiSelectItem(GuiScreen parent, @Nullable ISelectorCallback<ItemMeta> callback) {
        this(parent);
        this.selectorCallback = callback;
    }

    public GuiSelectItem(GuiScreen parent, @Nullable GuiTextField nameField, @Nullable GuiTextField metaField) {
        this(parent);
        this.nameField = nameField;
        this.metaField = metaField;
    }

    public GuiSelectItem(GuiScreen parent, @Nullable GuiTextField nameField, @Nullable GuiTextField metaField, @Nullable ISelectorCallback<ItemMeta> callback) {
        this(parent, nameField, metaField);
        this.selectorCallback = callback;
    }

    public GuiSelectItem(GuiScreen parent, @Nullable GuiConfigEntries.ArrayEntry arrayEntry) {
        this(parent);
        this.arrayEntry = arrayEntry;
    }

    public GuiSelectItem(GuiScreen parent, @Nullable GuiConfigEntries.ArrayEntry arrayEntry, @Nullable ISelectorCallback<ItemMeta> callback) {
        this(parent, arrayEntry);
        this.selectorCallback = callback;
    }

    public void func_73866_w_() {
        if (this.itemList == null) {
            this.itemList = new ItemList();
        }
        this.itemList.func_148122_a(this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - 28);
        if (this.doneButton == null) {
            this.doneButton = new GuiButtonExt(0, 0, 0, 145, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        }
        this.doneButton.field_146128_h = this.field_146294_l / 2 + 10;
        this.doneButton.field_146129_i = this.field_146295_m - this.doneButton.field_146121_g - 4;
        if (this.detailInfo == null) {
            this.detailInfo = new GuiCheckBox(1, 0, 5, I18n.func_135052_a((String)"cavern.config.detail", (Object[])new Object[0]), true);
        }
        this.detailInfo.setIsChecked(CaveConfigGui.detailInfo);
        this.detailInfo.field_146128_h = this.field_146294_l / 2 + 95;
        if (this.instantFilter == null) {
            this.instantFilter = new GuiCheckBox(2, 0, this.detailInfo.field_146129_i + this.detailInfo.field_146121_g + 2, I18n.func_135052_a((String)"cavern.config.instant", (Object[])new Object[0]), true);
        }
        this.instantFilter.setIsChecked(CaveConfigGui.instantFilter);
        this.instantFilter.field_146128_h = this.detailInfo.field_146128_h;
        this.field_146292_n.clear();
        this.field_146292_n.add(this.doneButton);
        this.field_146292_n.add(this.detailInfo);
        this.field_146292_n.add(this.instantFilter);
        if (this.filterTextField == null) {
            this.filterTextField = new GuiTextField(0, this.field_146289_q, 0, 0, 150, 16);
            this.filterTextField.func_146203_f(100);
        }
        this.filterTextField.field_146209_f = this.field_146294_l / 2 - this.filterTextField.field_146218_h - 5;
        this.filterTextField.field_146210_g = this.field_146295_m - this.filterTextField.field_146219_i - 6;
        this.selectedHoverChecker = new HoverChecker(0, 20, 0, 100, 800);
        this.detailHoverChecker = new HoverChecker((GuiButton)this.detailInfo, 800);
        this.instantHoverChecker = new HoverChecker((GuiButton)this.instantFilter, 800);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 0: {
                    if (this.selectorCallback != null) {
                        this.selectorCallback.onSelected((List<ItemMeta>)ImmutableList.copyOf(this.itemList.selected));
                    }
                    if (this.arrayEntry != null) {
                        if (this.itemList.selected.isEmpty()) {
                            this.arrayEntry.setListFromChildScreen(new Object[0]);
                        } else {
                            this.arrayEntry.setListFromChildScreen(this.itemList.selected.stream().map(ItemMeta::getName).collect(Collectors.toList()).toArray());
                        }
                    }
                    if (this.itemList.selected.isEmpty()) {
                        if (this.nameField != null) {
                            this.nameField.func_146180_a("");
                        }
                        if (this.metaField != null) {
                            this.metaField.func_146180_a("");
                        }
                    } else {
                        Iterator<ItemMeta> iterator = this.itemList.selected.iterator();
                        if (iterator.hasNext()) {
                            ItemMeta itemMeta = iterator.next();
                            if (this.nameField != null) {
                                this.nameField.func_146180_a(itemMeta.getItemName());
                            }
                            if (this.metaField != null) {
                                this.metaField.func_146180_a(Integer.toString(itemMeta.getMeta()));
                            }
                        }
                    }
                    if (this.nameField != null) {
                        this.nameField.func_146195_b(true);
                        this.nameField.func_146202_e();
                    } else if (this.metaField != null) {
                        this.metaField.func_146195_b(true);
                        this.metaField.func_146202_e();
                    }
                    this.field_146297_k.func_147108_a(this.parent);
                    this.itemList.selected.clear();
                    this.itemList.scrollToTop();
                    break;
                }
                case 1: {
                    CaveConfigGui.detailInfo = this.detailInfo.isChecked();
                    break;
                }
                case 2: {
                    CaveConfigGui.instantFilter = this.instantFilter.isChecked();
                    break;
                }
                default: {
                    this.itemList.func_148147_a(button);
                }
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.filterTextField.func_146178_a();
    }

    public void func_73863_a(int mouseX, int mouseY, float ticks) {
        this.itemList.func_148128_a(mouseX, mouseY, ticks);
        boolean single = this.nameField != null || this.metaField != null;
        String name = null;
        name = single ? I18n.func_135052_a((String)"cavern.config.select.item", (Object[])new Object[0]) : I18n.func_135052_a((String)"cavern.config.select.item.multiple", (Object[])new Object[0]);
        if (!Strings.isNullOrEmpty((String)name)) {
            this.func_73732_a(this.field_146289_q, name, this.field_146294_l / 2, 15, 0xFFFFFF);
        }
        super.func_73863_a(mouseX, mouseY, ticks);
        this.filterTextField.func_146194_f();
        if (this.detailHoverChecker.checkHover(mouseX, mouseY)) {
            this.func_146283_a(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)"cavern.config.detail.hover", (Object[])new Object[0]), 300), mouseX, mouseY);
        } else if (this.instantHoverChecker.checkHover(mouseX, mouseY)) {
            this.func_146283_a(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)"cavern.config.instant.hover", (Object[])new Object[0]), 300), mouseX, mouseY);
        }
        if (!single && !this.itemList.selected.isEmpty()) {
            if (mouseX <= 100 && mouseY <= 20) {
                this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"cavern.config.select.item.selected", (Object[])new Object[]{this.itemList.selected.size()}), 5, 5, 0xEFEFEF);
            }
            if (this.selectedHoverChecker.checkHover(mouseX, mouseY)) {
                ArrayList texts = Lists.newArrayList();
                for (ItemMeta itemMeta : this.itemList.selected) {
                    name = this.itemList.getItemMetaTypeName(itemMeta);
                    if (Strings.isNullOrEmpty((String)name)) continue;
                    texts.add(name);
                }
                this.func_146283_a(texts, mouseX, mouseY);
            }
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.itemList.func_178039_p();
    }

    protected void func_73864_a(int x, int y, int code) throws IOException {
        super.func_73864_a(x, y, code);
        this.filterTextField.func_146192_a(x, y, code);
    }

    protected void func_73869_a(char c, int code) throws IOException {
        if (this.filterTextField.func_146206_l()) {
            boolean changed;
            if (code == 1) {
                this.filterTextField.func_146195_b(false);
            }
            String prev = this.filterTextField.func_146179_b();
            this.filterTextField.func_146201_a(c, code);
            String text = this.filterTextField.func_146179_b();
            boolean bl = changed = text != prev;
            if (Strings.isNullOrEmpty((String)text) && changed) {
                this.itemList.setFilter(null);
            } else if (this.instantFilter.isChecked() && changed || code == 28) {
                this.itemList.setFilter(text);
            }
        } else if (code == 1) {
            this.field_146297_k.func_147108_a(this.parent);
        } else if (code == 14) {
            this.itemList.selected.clear();
        } else if (code == 15) {
            if (++this.itemList.nameType > 2) {
                this.itemList.nameType = 0;
            }
        } else if (code == 200) {
            this.itemList.scrollUp();
        } else if (code == 208) {
            this.itemList.scrollDown();
        } else if (code == 199) {
            this.itemList.scrollToTop();
        } else if (code == 207) {
            this.itemList.scrollToEnd();
        } else if (code == 57) {
            this.itemList.scrollToSelected();
        } else if (code == 201) {
            this.itemList.scrollToPrev();
        } else if (code == 209) {
            this.itemList.scrollToNext();
        } else if (code == 33 || code == this.field_146297_k.field_71474_y.field_74310_D.func_151463_i()) {
            this.filterTextField.func_146195_b(true);
        } else if (GuiSelectItem.func_146271_m() && code == 30) {
            this.itemList.contents.forEach(entry -> this.itemList.selected.add((ItemMeta)entry));
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected class ItemList
    extends GuiListSlot {
        protected final NonNullList<ItemMeta> entries;
        protected final NonNullList<ItemMeta> contents;
        protected final Set<ItemMeta> selected;
        protected final Map<String, List<ItemMeta>> filterCache;
        protected int nameType;
        protected boolean clickFlag;

        protected ItemList() {
            super(GuiSelectItem.this.field_146297_k, 0, 0, 0, 0, 18);
            this.entries = NonNullList.func_191196_a();
            this.contents = NonNullList.func_191196_a();
            this.selected = Sets.newTreeSet();
            this.filterCache = Maps.newHashMap();
            HashSet select = Sets.newHashSet();
            if (GuiSelectItem.this.nameField != null) {
                String name = GuiSelectItem.this.nameField.func_146179_b();
                int meta = -1;
                if (GuiSelectItem.this.metaField != null) {
                    meta = NumberUtils.toInt((String)GuiSelectItem.this.metaField.func_146179_b(), (int)-1);
                }
                if (!Strings.isNullOrEmpty((String)name)) {
                    select.add(new ItemMeta(name, meta));
                }
            }
            if (GuiSelectItem.this.arrayEntry != null) {
                Arrays.stream(GuiSelectItem.this.arrayEntry.getCurrentValues()).map(Object::toString).filter(value -> !Strings.isNullOrEmpty((String)value)).forEach(value -> {
                    ItemMeta itemMeta;
                    if (!value.contains(":")) {
                        value = "minecraft:" + value;
                    }
                    if (value.indexOf(58) != value.lastIndexOf(58)) {
                        int i = value.lastIndexOf(58);
                        itemMeta = new ItemMeta(value.substring(0, i), NumberUtils.toInt((String)value.substring(i + 1)));
                    } else {
                        itemMeta = new ItemMeta((String)value, 0);
                    }
                    if (!itemMeta.isEmpty()) {
                        select.add(itemMeta);
                    }
                });
            }
            for (ItemMeta itemMeta : SelectListHelper.ITEMS) {
                if (GuiSelectItem.this.selectorCallback != null && !GuiSelectItem.this.selectorCallback.isValidEntry(itemMeta)) continue;
                this.entries.add((Object)itemMeta);
                this.contents.add((Object)itemMeta);
                if (!select.contains(itemMeta)) continue;
                this.selected.add(itemMeta);
            }
            if (!this.selected.isEmpty()) {
                this.scrollToTop();
                this.scrollToSelected();
            }
        }

        @Override
        public PanoramaPaths getPanoramaPaths() {
            return null;
        }

        @Override
        public void scrollToSelected() {
            if (!this.selected.isEmpty()) {
                int amount = 0;
                for (ItemMeta itemMeta : this.selected) {
                    amount = this.contents.indexOf((Object)itemMeta) * this.func_148146_j();
                    if (this.func_148148_g() == amount) continue;
                    break;
                }
                this.scrollToTop();
                this.func_148145_f(amount);
            }
        }

        protected int func_148127_b() {
            return this.contents.size();
        }

        @Nullable
        public String getItemMetaTypeName(ItemMeta itemMeta, ItemStack stack) {
            if (itemMeta == null) {
                return null;
            }
            if (stack.func_190926_b()) {
                stack = itemMeta.getItemStack();
            }
            String name = null;
            switch (this.nameType) {
                case 1: {
                    name = itemMeta.getName();
                    break;
                }
                case 2: {
                    name = stack.func_77977_a();
                    name = name.substring(name.indexOf(".") + 1);
                    break;
                }
                default: {
                    name = stack.func_82833_r();
                }
            }
            return name;
        }

        public String getItemMetaTypeName(ItemMeta itemMeta) {
            return this.getItemMetaTypeName(itemMeta, ItemStack.field_190927_a);
        }

        protected void func_148123_a() {
            GuiSelectItem.this.func_146276_q_();
        }

        protected void func_192637_a(int slot, int par2, int par3, int par4, int mouseX, int mouseY, float partialTicks) {
            ItemStack stack;
            ItemMeta itemMeta = (ItemMeta)this.contents.get(slot);
            String name = this.getItemMetaTypeName(itemMeta, stack = itemMeta.getItemStack());
            if (!Strings.isNullOrEmpty((String)name)) {
                GuiSelectItem.this.func_73732_a(GuiSelectItem.this.field_146289_q, name, this.field_148155_a / 2, par3 + 1, 0xFFFFFF);
            }
            if (GuiSelectItem.this.detailInfo.isChecked()) {
                this.drawItemStack(GuiSelectItem.this.field_146296_j, stack, this.field_148155_a / 2 - 100, par3 - 1);
            }
        }

        protected void func_148144_a(int slot, boolean flag, int mouseX, int mouseY) {
            ItemMeta itemMeta = (ItemMeta)this.contents.get(slot);
            this.clickFlag = !this.clickFlag;
            if (this.clickFlag && !this.selected.remove(itemMeta)) {
                if (GuiSelectItem.this.nameField != null || GuiSelectItem.this.metaField != null) {
                    this.selected.clear();
                }
                this.selected.add(itemMeta);
            }
        }

        protected boolean func_148131_a(int slot) {
            return this.selected.contains(this.contents.get(slot));
        }

        protected void setFilter(String filter) {
            Object result;
            if (Strings.isNullOrEmpty((String)filter)) {
                result = this.entries;
            } else if (filter.equals("selected")) {
                result = Lists.newArrayList(this.selected);
            } else {
                if (!this.filterCache.containsKey(filter)) {
                    this.filterCache.put(filter, this.entries.parallelStream().filter(e -> this.filterMatch((ItemMeta)e, filter)).collect(Collectors.toList()));
                }
                result = this.filterCache.get(filter);
            }
            if (!this.contents.equals(result)) {
                this.contents.clear();
                this.contents.addAll(result);
            }
        }

        protected boolean filterMatch(ItemMeta itemMeta, String filter) {
            return CaveFilters.itemFilter(itemMeta, filter);
        }
    }
}

