/*
 * Decompiled with CFR 0.152.
 */
package cavern.client.gui;

import cavern.client.config.CaveConfigGui;
import cavern.client.gui.GuiListSlot;
import cavern.client.gui.ISelectorCallback;
import cavern.client.gui.SelectListHelper;
import cavern.client.gui.SelectSwitchEntry;
import cavern.util.BlockMeta;
import cavern.util.CaveFilters;
import cavern.util.PanoramaPaths;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

@SideOnly(value=Side.CLIENT)
public class GuiSelectBlock
extends GuiScreen {
    protected final GuiScreen parent;
    protected ISelectorCallback<BlockMeta> selectorCallback;
    protected SelectSwitchEntry switchEntry;
    protected GuiTextField nameField;
    protected GuiTextField metaField;
    protected GuiConfigEntries.ArrayEntry arrayEntry;
    protected BlockList blockList;
    protected GuiButton doneButton;
    protected GuiButton switchButton;
    protected GuiCheckBox detailInfo;
    protected GuiCheckBox instantFilter;
    protected GuiTextField filterTextField;
    protected HoverChecker selectedHoverChecker;
    protected HoverChecker detailHoverChecker;
    protected HoverChecker instantHoverChecker;

    public GuiSelectBlock(GuiScreen parent) {
        this.parent = parent;
    }

    public GuiSelectBlock(GuiScreen parent, @Nullable ISelectorCallback<BlockMeta> callback) {
        this(parent);
        this.selectorCallback = callback;
    }

    public GuiSelectBlock(GuiScreen parent, @Nullable GuiTextField nameField, @Nullable GuiTextField metaField) {
        this(parent);
        this.nameField = nameField;
        this.metaField = metaField;
    }

    public GuiSelectBlock(GuiScreen parent, @Nullable GuiTextField nameField, @Nullable GuiTextField metaField, @Nullable ISelectorCallback<BlockMeta> callback) {
        this(parent, nameField, metaField);
        this.selectorCallback = callback;
    }

    public GuiSelectBlock(GuiScreen parent, @Nullable GuiConfigEntries.ArrayEntry arrayEntry) {
        this(parent);
        this.arrayEntry = arrayEntry;
    }

    public GuiSelectBlock(GuiScreen parent, @Nullable GuiConfigEntries.ArrayEntry arrayEntry, @Nullable ISelectorCallback<BlockMeta> callback) {
        this(parent, arrayEntry);
        this.selectorCallback = callback;
    }

    public void setSwitchEntry(@Nullable SelectSwitchEntry entry) {
        this.switchEntry = entry;
    }

    public void func_73866_w_() {
        int buttonWidth;
        if (this.blockList == null) {
            this.blockList = new BlockList();
        }
        this.blockList.func_148122_a(this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - 28);
        boolean hasSwitch = this.switchEntry != null;
        int n = buttonWidth = hasSwitch ? 70 : 145;
        if (this.doneButton == null) {
            this.doneButton = new GuiButtonExt(0, 0, 0, buttonWidth, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        }
        this.doneButton.field_146128_h = this.field_146294_l / 2 + 10;
        this.doneButton.field_146129_i = this.field_146295_m - this.doneButton.field_146121_g - 4;
        if (this.switchButton == null) {
            this.switchButton = new GuiButtonExt(3, 0, 0, buttonWidth, 20, hasSwitch ? this.switchEntry.getTranslatedName() : "");
            this.switchButton.field_146125_m = hasSwitch;
        }
        this.switchButton.field_146128_h = this.doneButton.field_146128_h;
        this.switchButton.field_146129_i = this.doneButton.field_146129_i;
        if (hasSwitch) {
            this.doneButton.field_146128_h += buttonWidth + 3;
        }
        if (this.detailInfo == null) {
            this.detailInfo = new GuiCheckBox(1, 0, 5, I18n.func_135052_a((String)"cavern.config.detail", (Object[])new Object[0]), true);
        }
        this.detailInfo.setIsChecked(CaveConfigGui.detailInfo);
        this.detailInfo.field_146128_h = this.field_146294_l / 2 + 95;
        if (this.instantFilter == null) {
            this.instantFilter = new GuiCheckBox(2, 0, this.detailInfo.field_146129_i + this.detailInfo.field_146121_g + 2, I18n.func_135052_a((String)"cavern.config.instant", (Object[])new Object[0]), true);
        }
        this.instantFilter.setIsChecked(CaveConfigGui.instantFilter);
        this.instantFilter.field_146128_h = this.detailInfo.field_146128_h;
        this.field_146292_n.clear();
        this.field_146292_n.add(this.doneButton);
        this.field_146292_n.add(this.switchButton);
        this.field_146292_n.add(this.detailInfo);
        this.field_146292_n.add(this.instantFilter);
        if (this.filterTextField == null) {
            this.filterTextField = new GuiTextField(0, this.field_146289_q, 0, 0, 150, 16);
            this.filterTextField.func_146203_f(100);
        }
        this.filterTextField.field_146209_f = this.field_146294_l / 2 - this.filterTextField.field_146218_h - 5;
        this.filterTextField.field_146210_g = this.field_146295_m - this.filterTextField.field_146219_i - 6;
        this.selectedHoverChecker = new HoverChecker(0, 20, 0, 100, 800);
        this.detailHoverChecker = new HoverChecker((GuiButton)this.detailInfo, 800);
        this.instantHoverChecker = new HoverChecker((GuiButton)this.instantFilter, 800);
        if (this.switchEntry != null && this.field_146297_k.field_71462_r == this) {
            this.switchEntry.getGuiScreen().func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        }
    }

    protected void setResult() {
        if (this.selectorCallback != null) {
            this.selectorCallback.onSelected((List<BlockMeta>)ImmutableList.copyOf(this.blockList.selected));
        }
        if (this.arrayEntry != null) {
            if (this.switchEntry == null || this.field_146297_k.field_71462_r == this) {
                if (this.blockList.selected.isEmpty()) {
                    this.arrayEntry.setListFromChildScreen((Object[])new String[0]);
                } else {
                    this.arrayEntry.setListFromChildScreen(this.blockList.selected.stream().map(BlockMeta::getName).collect(Collectors.toList()).toArray());
                }
            } else if (!this.blockList.selected.isEmpty()) {
                Object[] values = this.arrayEntry.getCurrentValues();
                Object[] newValues = this.blockList.selected.stream().map(BlockMeta::getName).collect(Collectors.toList()).toArray();
                if (values == null || values.length <= 0) {
                    this.arrayEntry.setListFromChildScreen(newValues);
                } else {
                    this.arrayEntry.setListFromChildScreen(ArrayUtils.addAll((Object[])values, (Object[])newValues));
                }
            }
        }
        if (this.blockList.selected.isEmpty()) {
            if (this.nameField != null) {
                this.nameField.func_146180_a("");
            }
            if (this.metaField != null) {
                this.metaField.func_146180_a("");
            }
        } else {
            Iterator<BlockMeta> iterator = this.blockList.selected.iterator();
            if (iterator.hasNext()) {
                BlockMeta blockMeta = iterator.next();
                if (this.nameField != null) {
                    this.nameField.func_146180_a(blockMeta.getBlockName());
                }
                if (this.metaField != null) {
                    this.metaField.func_146180_a(blockMeta.getMetaString());
                }
            }
        }
        if (this.nameField != null) {
            this.nameField.func_146195_b(true);
            this.nameField.func_146202_e();
        } else if (this.metaField != null) {
            this.metaField.func_146195_b(true);
            this.metaField.func_146202_e();
        }
    }

    public void func_73878_a(boolean result, int id) {
        super.func_73878_a(result, id);
        if (id == 3) {
            this.setResult();
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 0: {
                    this.setResult();
                    if (this.switchEntry != null) {
                        this.switchEntry.getGuiScreen().func_73878_a(true, 3);
                    }
                    this.field_146297_k.func_147108_a(this.parent);
                    this.blockList.selected.clear();
                    this.blockList.scrollToTop();
                    break;
                }
                case 1: {
                    CaveConfigGui.detailInfo = this.detailInfo.isChecked();
                    break;
                }
                case 2: {
                    CaveConfigGui.instantFilter = this.instantFilter.isChecked();
                    break;
                }
                case 3: {
                    if (this.switchEntry == null) break;
                    this.field_146297_k.func_147108_a(this.switchEntry.getGuiScreen());
                    break;
                }
                default: {
                    this.blockList.func_148147_a(button);
                }
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.filterTextField.func_146178_a();
    }

    public void func_73863_a(int mouseX, int mouseY, float ticks) {
        this.blockList.func_148128_a(mouseX, mouseY, ticks);
        boolean single = this.nameField != null || this.metaField != null;
        String name = null;
        name = single ? I18n.func_135052_a((String)"cavern.config.select.block", (Object[])new Object[0]) : I18n.func_135052_a((String)"cavern.config.select.block.multiple", (Object[])new Object[0]);
        if (!Strings.isNullOrEmpty((String)name)) {
            this.func_73732_a(this.field_146289_q, name, this.field_146294_l / 2, 15, 0xFFFFFF);
        }
        super.func_73863_a(mouseX, mouseY, ticks);
        this.filterTextField.func_146194_f();
        if (this.detailHoverChecker.checkHover(mouseX, mouseY)) {
            this.func_146283_a(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)"cavern.config.detail.hover", (Object[])new Object[0]), 300), mouseX, mouseY);
        } else if (this.instantHoverChecker.checkHover(mouseX, mouseY)) {
            this.func_146283_a(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)"cavern.config.instant.hover", (Object[])new Object[0]), 300), mouseX, mouseY);
        }
        if (!single && !this.blockList.selected.isEmpty()) {
            if (mouseX <= 100 && mouseY <= 20) {
                this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"cavern.config.select.block.selected", (Object[])new Object[]{this.blockList.selected.size()}), 5, 5, 0xEFEFEF);
            }
            if (this.selectedHoverChecker.checkHover(mouseX, mouseY)) {
                ArrayList texts = Lists.newArrayList();
                for (BlockMeta blockMeta : this.blockList.selected) {
                    name = this.blockList.getBlockName(blockMeta);
                    if (Strings.isNullOrEmpty((String)name)) continue;
                    texts.add(name);
                }
                this.func_146283_a(texts, mouseX, mouseY);
            }
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.blockList.func_178039_p();
    }

    protected void func_73864_a(int x, int y, int code) throws IOException {
        super.func_73864_a(x, y, code);
        this.filterTextField.func_146192_a(x, y, code);
    }

    protected void func_73869_a(char c, int code) throws IOException {
        if (this.filterTextField.func_146206_l()) {
            boolean changed;
            if (code == 1) {
                this.filterTextField.func_146195_b(false);
            }
            String prev = this.filterTextField.func_146179_b();
            this.filterTextField.func_146201_a(c, code);
            String text = this.filterTextField.func_146179_b();
            boolean bl = changed = text != prev;
            if (Strings.isNullOrEmpty((String)text) && changed) {
                this.blockList.setFilter(null);
            } else if (this.instantFilter.isChecked() && changed || code == 28) {
                this.blockList.setFilter(text);
            }
        } else if (code == 1) {
            this.field_146297_k.func_147108_a(this.parent);
        } else if (code == 14) {
            this.blockList.selected.clear();
        } else if (code == 15) {
            if (++this.blockList.nameType > 2) {
                this.blockList.nameType = 0;
            }
        } else if (code == 200) {
            this.blockList.scrollUp();
        } else if (code == 208) {
            this.blockList.scrollDown();
        } else if (code == 203 || code == 205) {
            this.switchButton.func_146113_a(this.field_146297_k.func_147118_V());
            this.func_146284_a(this.switchButton);
        } else if (code == 199) {
            this.blockList.scrollToTop();
        } else if (code == 207) {
            this.blockList.scrollToEnd();
        } else if (code == 57) {
            this.blockList.scrollToSelected();
        } else if (code == 201) {
            this.blockList.scrollToPrev();
        } else if (code == 209) {
            this.blockList.scrollToNext();
        } else if (code == 33 || code == this.field_146297_k.field_71474_y.field_74310_D.func_151463_i()) {
            this.filterTextField.func_146195_b(true);
        } else if (GuiSelectBlock.func_146271_m() && code == 30) {
            this.blockList.contents.forEach(entry -> this.blockList.selected.add((BlockMeta)entry));
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected class BlockList
    extends GuiListSlot {
        protected final NonNullList<BlockMeta> entries;
        protected final NonNullList<BlockMeta> contents;
        protected final Set<BlockMeta> selected;
        protected final Map<String, List<BlockMeta>> filterCache;
        protected int nameType;
        protected boolean clickFlag;

        protected BlockList() {
            super(GuiSelectBlock.this.field_146297_k, 0, 0, 0, 0, 18);
            this.entries = NonNullList.func_191196_a();
            this.contents = NonNullList.func_191196_a();
            this.selected = Sets.newTreeSet();
            this.filterCache = Maps.newHashMap();
            HashSet select = Sets.newHashSet();
            if (GuiSelectBlock.this.nameField != null) {
                String name = GuiSelectBlock.this.nameField.func_146179_b();
                String meta = Integer.toString(-1);
                if (GuiSelectBlock.this.metaField != null) {
                    meta = GuiSelectBlock.this.metaField.func_146179_b();
                }
                if (!Strings.isNullOrEmpty((String)name) && !Strings.isNullOrEmpty((String)meta)) {
                    select.add(new BlockMeta(name, meta));
                }
            }
            if (GuiSelectBlock.this.arrayEntry != null) {
                Arrays.stream(GuiSelectBlock.this.arrayEntry.getCurrentValues()).map(Object::toString).filter(value -> !Strings.isNullOrEmpty((String)value)).forEach(value -> {
                    BlockMeta blockMeta;
                    if (!(value = value.trim()).contains(":")) {
                        value = "minecraft:" + value;
                    }
                    if (value.indexOf(58) != value.lastIndexOf(58)) {
                        int i = value.lastIndexOf(58);
                        blockMeta = new BlockMeta(value.substring(0, i), value.substring(i + 1));
                    } else {
                        blockMeta = new BlockMeta((String)value, 0);
                    }
                    if (blockMeta.isNotAir()) {
                        select.add(blockMeta);
                    }
                });
            }
            for (BlockMeta blockMeta : SelectListHelper.BLOCKS) {
                if (GuiSelectBlock.this.selectorCallback != null && !GuiSelectBlock.this.selectorCallback.isValidEntry(blockMeta)) continue;
                this.entries.add((Object)blockMeta);
                this.contents.add((Object)blockMeta);
                if (!select.contains(blockMeta)) continue;
                this.selected.add(blockMeta);
            }
            if (!this.selected.isEmpty()) {
                this.scrollToTop();
                this.scrollToSelected();
            }
        }

        @Override
        public PanoramaPaths getPanoramaPaths() {
            return null;
        }

        @Override
        public void scrollToSelected() {
            if (!this.selected.isEmpty()) {
                int amount = 0;
                for (BlockMeta blockMeta : this.selected) {
                    amount = this.contents.indexOf((Object)blockMeta) * this.func_148146_j();
                    if (this.func_148148_g() == amount) continue;
                    break;
                }
                this.scrollToTop();
                this.func_148145_f(amount);
            }
        }

        protected int func_148127_b() {
            return this.contents.size();
        }

        @Nullable
        public String getBlockName(@Nullable BlockMeta blockMeta, ItemStack stack) {
            if (blockMeta == null) {
                return null;
            }
            if (stack.func_190926_b()) {
                stack = new ItemStack(blockMeta.getBlock(), 1, blockMeta.getMeta());
            }
            String name = null;
            if (this.nameType == 1) {
                name = blockMeta.getName();
            } else if (stack.func_77973_b() != Items.field_190931_a) {
                switch (this.nameType) {
                    case 2: {
                        name = stack.func_77977_a();
                        name = name.substring(name.indexOf(".") + 1);
                        break;
                    }
                    default: {
                        name = stack.func_82833_r();
                        break;
                    }
                }
            } else {
                switch (this.nameType) {
                    case 2: {
                        name = blockMeta.getBlock().func_149739_a();
                        name = name.substring(name.indexOf(".") + 1);
                        break;
                    }
                    default: {
                        name = blockMeta.getBlock().func_149732_F();
                    }
                }
            }
            return name;
        }

        @Nullable
        public String getBlockName(@Nullable BlockMeta blockMeta) {
            return this.getBlockName(blockMeta, ItemStack.field_190927_a);
        }

        protected void func_148123_a() {
            GuiSelectBlock.this.func_146276_q_();
        }

        protected void func_192637_a(int slot, int par2, int par3, int par4, int mouseX, int mouseY, float partialTicks) {
            BlockMeta blockMeta = (BlockMeta)this.contents.get(slot);
            String name = this.getBlockName(blockMeta);
            if (!Strings.isNullOrEmpty((String)name)) {
                GuiSelectBlock.this.func_73732_a(GuiSelectBlock.this.field_146289_q, name, this.field_148155_a / 2, par3 + 1, 0xFFFFFF);
            }
            if (GuiSelectBlock.this.detailInfo.isChecked()) {
                this.drawItemStack(GuiSelectBlock.this.field_146296_j, blockMeta, this.field_148155_a / 2 - 100, par3 - 1);
            }
        }

        protected void func_148144_a(int slot, boolean flag, int mouseX, int mouseY) {
            BlockMeta blockMeta = (BlockMeta)this.contents.get(slot);
            this.clickFlag = !this.clickFlag;
            if (this.clickFlag && !this.selected.remove(blockMeta)) {
                if (GuiSelectBlock.this.nameField != null || GuiSelectBlock.this.metaField != null) {
                    this.selected.clear();
                }
                this.selected.add(blockMeta);
            }
        }

        protected boolean func_148131_a(int slot) {
            return this.selected.contains(this.contents.get(slot));
        }

        protected void setFilter(String filter) {
            Object result;
            if (Strings.isNullOrEmpty((String)filter)) {
                result = this.entries;
            } else if (filter.equals("selected")) {
                result = Lists.newArrayList(this.selected);
            } else {
                if (!this.filterCache.containsKey(filter)) {
                    this.filterCache.put(filter, this.entries.parallelStream().filter(e -> this.filterMatch((BlockMeta)e, filter)).collect(Collectors.toList()));
                }
                result = this.filterCache.get(filter);
            }
            if (!this.contents.equals(result)) {
                this.contents.clear();
                this.contents.addAll(result);
            }
        }

        protected boolean filterMatch(BlockMeta blockMeta, String filter) {
            return CaveFilters.blockFilter(blockMeta, filter);
        }
    }
}

