/*
 * Decompiled with CFR 0.152.
 */
package cavern.client.gui;

import cavern.client.config.CaveConfigGui;
import cavern.client.gui.GuiListSlot;
import cavern.client.gui.ISelectorCallback;
import cavern.config.Config;
import cavern.util.CaveFilters;
import cavern.util.CaveUtils;
import cavern.util.PanoramaPaths;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiSelectBiome
extends GuiScreen {
    protected final GuiScreen parent;
    protected ISelectorCallback<Biome> selectorCallback;
    protected GuiTextField biomeField;
    protected BiomeList biomeList;
    protected GuiButton doneButton;
    protected GuiCheckBox detailInfo;
    protected GuiCheckBox instantFilter;
    protected GuiTextField filterTextField;
    protected HoverChecker selectedHoverChecker;
    protected HoverChecker detailHoverChecker;
    protected HoverChecker instantHoverChecker;

    public GuiSelectBiome(GuiScreen parent) {
        this.parent = parent;
    }

    public GuiSelectBiome(GuiScreen parent, @Nullable ISelectorCallback<Biome> callback) {
        this(parent);
        this.selectorCallback = callback;
    }

    public GuiSelectBiome(GuiScreen parent, @Nullable GuiTextField biomeField) {
        this(parent);
        this.biomeField = biomeField;
    }

    public void func_73866_w_() {
        if (this.biomeList == null) {
            this.biomeList = new BiomeList();
        }
        this.biomeList.func_148122_a(this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - 28);
        if (this.doneButton == null) {
            this.doneButton = new GuiButtonExt(0, 0, 0, 145, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        }
        this.doneButton.field_146128_h = this.field_146294_l / 2 + 10;
        this.doneButton.field_146129_i = this.field_146295_m - this.doneButton.field_146121_g - 4;
        if (this.detailInfo == null) {
            this.detailInfo = new GuiCheckBox(1, 0, 5, I18n.func_135052_a((String)"cavern.config.detail", (Object[])new Object[0]), true);
        }
        this.detailInfo.setIsChecked(CaveConfigGui.detailInfo);
        this.detailInfo.field_146128_h = this.field_146294_l / 2 + 95;
        if (this.instantFilter == null) {
            this.instantFilter = new GuiCheckBox(2, 0, this.detailInfo.field_146129_i + this.detailInfo.field_146121_g + 2, I18n.func_135052_a((String)"cavern.config.instant", (Object[])new Object[0]), true);
        }
        this.instantFilter.setIsChecked(CaveConfigGui.instantFilter);
        this.instantFilter.field_146128_h = this.detailInfo.field_146128_h;
        this.field_146292_n.clear();
        this.field_146292_n.add(this.doneButton);
        this.field_146292_n.add(this.detailInfo);
        this.field_146292_n.add(this.instantFilter);
        if (this.filterTextField == null) {
            this.filterTextField = new GuiTextField(0, this.field_146289_q, 0, 0, 150, 16);
            this.filterTextField.func_146203_f(100);
        }
        this.filterTextField.field_146209_f = this.field_146294_l / 2 - this.filterTextField.field_146218_h - 5;
        this.filterTextField.field_146210_g = this.field_146295_m - this.filterTextField.field_146219_i - 6;
        this.selectedHoverChecker = new HoverChecker(0, 20, 0, 100, 800);
        this.detailHoverChecker = new HoverChecker((GuiButton)this.detailInfo, 800);
        this.instantHoverChecker = new HoverChecker((GuiButton)this.instantFilter, 800);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 0: {
                    if (this.selectorCallback != null) {
                        this.selectorCallback.onSelected((List<Biome>)ImmutableList.copyOf(this.biomeList.selected));
                    }
                    if (this.biomeList.selected.isEmpty()) {
                        if (this.biomeField != null) {
                            this.biomeField.func_146180_a("");
                        }
                    } else {
                        TreeSet biomes = Sets.newTreeSet();
                        for (Biome biome : this.biomeList.selected) {
                            biomes.add(biome.getRegistryName().toString());
                        }
                        if (!biomes.isEmpty() && this.biomeField != null) {
                            this.biomeField.func_146180_a(Joiner.on((String)", ").join((Iterable)biomes));
                        }
                    }
                    if (this.biomeField != null) {
                        this.biomeField.func_146195_b(true);
                        this.biomeField.func_146202_e();
                    }
                    this.field_146297_k.func_147108_a(this.parent);
                    this.biomeList.selected.clear();
                    this.biomeList.scrollToTop();
                    break;
                }
                case 1: {
                    CaveConfigGui.detailInfo = this.detailInfo.isChecked();
                    break;
                }
                case 2: {
                    CaveConfigGui.instantFilter = this.instantFilter.isChecked();
                    break;
                }
                default: {
                    this.biomeList.func_148147_a(button);
                }
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.filterTextField.func_146178_a();
    }

    public void func_73863_a(int mouseX, int mouseY, float ticks) {
        this.biomeList.func_148128_a(mouseX, mouseY, ticks);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"cavern.config.select.biome", (Object[])new Object[0]), this.field_146294_l / 2, 15, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, ticks);
        this.filterTextField.func_146194_f();
        if (this.detailHoverChecker.checkHover(mouseX, mouseY)) {
            this.func_146283_a(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)"cavern.config.detail.hover", (Object[])new Object[0]), 300), mouseX, mouseY);
        } else if (this.instantHoverChecker.checkHover(mouseX, mouseY)) {
            this.func_146283_a(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)"cavern.config.instant.hover", (Object[])new Object[0]), 300), mouseX, mouseY);
        } else if (this.biomeList.func_148141_e(mouseY) && GuiSelectBiome.func_146271_m()) {
            Biome biome = (Biome)this.biomeList.contents.get(this.biomeList.func_148124_c(mouseX, mouseY));
            ArrayList info = Lists.newArrayList();
            info.add(biome.func_185359_l() + TextFormatting.DARK_GRAY + "   " + biome.getRegistryName().toString());
            IBlockState state = biome.field_76752_A;
            Block block = state.func_177230_c();
            int meta = block.func_176201_c(state);
            ItemStack stack = new ItemStack(block, 1, meta);
            boolean hasItem = stack.func_77973_b() != Items.field_190931_a;
            String text = hasItem ? stack.func_82833_r() : block.getRegistryName() + ":" + meta;
            info.add(TextFormatting.GRAY + I18n.func_135052_a((String)"cavern.config.select.biome.info.topBlock", (Object[])new Object[0]) + ": " + text);
            state = biome.field_76753_B;
            block = state.func_177230_c();
            meta = block.func_176201_c(state);
            stack = new ItemStack(block, 1, meta);
            hasItem = stack.func_77973_b() != Items.field_190931_a;
            text = hasItem ? stack.func_82833_r() : block.getRegistryName() + ":" + meta;
            info.add(TextFormatting.GRAY + I18n.func_135052_a((String)"cavern.config.select.biome.info.fillerBlock", (Object[])new Object[0]) + ": " + text);
            info.add(TextFormatting.GRAY + I18n.func_135052_a((String)"cavern.config.select.biome.info.temperature", (Object[])new Object[0]) + ": " + biome.func_185353_n());
            info.add(TextFormatting.GRAY + I18n.func_135052_a((String)"cavern.config.select.biome.info.rainfall", (Object[])new Object[0]) + ": " + biome.func_76727_i());
            if (BiomeDictionary.hasAnyType((Biome)biome)) {
                TreeSet types = Sets.newTreeSet();
                for (BiomeDictionary.Type type : BiomeDictionary.getTypes((Biome)biome)) {
                    types.add(type.getName());
                }
                info.add(TextFormatting.GRAY + I18n.func_135052_a((String)"cavern.config.select.biome.info.type", (Object[])new Object[0]) + ": " + Joiner.on((String)", ").skipNulls().join((Iterable)types));
            }
            this.func_146283_a(info, mouseX, mouseY);
        }
        if (!this.biomeList.selected.isEmpty()) {
            if (mouseX <= 100 && mouseY <= 20) {
                this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"cavern.config.select.biome.selected", (Object[])new Object[]{this.biomeList.selected.size()}), 5, 5, 0xEFEFEF);
            }
            if (this.selectedHoverChecker.checkHover(mouseX, mouseY)) {
                this.func_146283_a(this.biomeList.selected.stream().map(Biome::func_185359_l).collect(Collectors.toList()), mouseX, mouseY);
            }
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.biomeList.func_178039_p();
    }

    protected void func_73864_a(int x, int y, int code) throws IOException {
        super.func_73864_a(x, y, code);
        this.filterTextField.func_146192_a(x, y, code);
    }

    protected void func_73869_a(char c, int code) throws IOException {
        if (this.filterTextField.func_146206_l()) {
            boolean changed;
            if (code == 1) {
                this.filterTextField.func_146195_b(false);
            }
            String prev = this.filterTextField.func_146179_b();
            this.filterTextField.func_146201_a(c, code);
            String text = this.filterTextField.func_146179_b();
            boolean bl = changed = text != prev;
            if (Strings.isNullOrEmpty((String)text) && changed) {
                this.biomeList.setFilter(null);
            } else if (this.instantFilter.isChecked() && changed || code == 28) {
                this.biomeList.setFilter(text);
            }
        } else if (code == 1) {
            this.field_146297_k.func_147108_a(this.parent);
        } else if (code == 14) {
            this.biomeList.selected.clear();
        } else if (code == 200) {
            this.biomeList.scrollUp();
        } else if (code == 208) {
            this.biomeList.scrollDown();
        } else if (code == 199) {
            this.biomeList.scrollToTop();
        } else if (code == 207) {
            this.biomeList.scrollToEnd();
        } else if (code == 57) {
            this.biomeList.scrollToSelected();
        } else if (code == 201) {
            this.biomeList.scrollToPrev();
        } else if (code == 209) {
            this.biomeList.scrollToNext();
        } else if (code == 33 || code == this.field_146297_k.field_71474_y.field_74310_D.func_151463_i()) {
            this.filterTextField.func_146195_b(true);
        } else if (GuiSelectBiome.func_146271_m() && code == 30) {
            this.biomeList.contents.forEach(entry -> this.biomeList.selected.add((Biome)entry));
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected class BiomeList
    extends GuiListSlot
    implements Comparator<Biome> {
        protected final NonNullList<Biome> biomes;
        protected final NonNullList<Biome> contents;
        protected final Set<Biome> selected;
        protected final Map<String, List<Biome>> filterCache;
        protected boolean clickFlag;

        protected BiomeList() {
            super(GuiSelectBiome.this.field_146297_k, 0, 0, 0, 0, 18);
            this.biomes = NonNullList.func_191196_a();
            this.contents = NonNullList.func_191196_a();
            this.selected = Sets.newTreeSet((Comparator)this);
            this.filterCache = Maps.newHashMap();
            for (Biome biome : ForgeRegistries.BIOMES.getValuesCollection()) {
                if (GuiSelectBiome.this.selectorCallback != null && !GuiSelectBiome.this.selectorCallback.isValidEntry(biome)) continue;
                this.biomes.add((Object)biome);
                this.contents.add((Object)biome);
            }
            this.setSelectedBiomes();
            if (!this.selected.isEmpty()) {
                this.scrollToTop();
                this.scrollToSelected();
            }
        }

        protected void setSelectedBiomes() {
            if (GuiSelectBiome.this.biomeField == null) {
                return;
            }
            String text = GuiSelectBiome.this.biomeField.func_146179_b();
            if (Strings.isNullOrEmpty((String)text)) {
                return;
            }
            if (text.contains(",")) {
                for (String str : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)text)) {
                    Biome biome = Config.getBiomeFromString(str);
                    if (biome == null) continue;
                    this.selected.add(biome);
                }
            } else {
                Biome biome = Config.getBiomeFromString(text);
                if (biome != null) {
                    this.selected.add(biome);
                }
            }
        }

        @Override
        public PanoramaPaths getPanoramaPaths() {
            return null;
        }

        @Override
        public void scrollToSelected() {
            if (!this.selected.isEmpty()) {
                int amount = 0;
                for (Biome biome : this.selected) {
                    amount = this.contents.indexOf((Object)biome) * this.func_148146_j();
                    if (this.func_148148_g() == amount) continue;
                    break;
                }
                this.scrollToTop();
                this.func_148145_f(amount);
            }
        }

        protected int func_148127_b() {
            return this.contents.size();
        }

        protected void func_148123_a() {
            GuiSelectBiome.this.func_146276_q_();
        }

        protected void func_192637_a(int slot, int par2, int par3, int par4, int mouseX, int mouseY, float partialTicks) {
            Biome biome = (Biome)this.contents.get(slot);
            boolean isTabDown = Keyboard.isKeyDown((int)15);
            if (isTabDown) {
                GuiSelectBiome.this.func_73732_a(GuiSelectBiome.this.field_146289_q, biome.getRegistryName().toString(), this.field_148155_a / 2, par3 + 1, 0xE0E0E0);
            } else {
                GuiSelectBiome.this.func_73732_a(GuiSelectBiome.this.field_146289_q, biome.func_185359_l(), this.field_148155_a / 2, par3 + 1, 0xFFFFFF);
            }
            if (GuiSelectBiome.this.detailInfo.isChecked() && isTabDown) {
                GuiSelectBiome.this.func_73731_b(GuiSelectBiome.this.field_146289_q, Integer.toString(Biome.func_185362_a((Biome)biome)), this.field_148155_a / 2 - 100, par3 + 1, 0xFFFFFF);
                this.drawItemStack(GuiSelectBiome.this.field_146296_j, biome.field_76752_A, this.field_148155_a / 2 + 70, par3 - 1);
                this.drawItemStack(GuiSelectBiome.this.field_146296_j, biome.field_76753_B, this.field_148155_a / 2 + 90, par3 - 1);
            }
        }

        protected void func_148144_a(int slot, boolean flag, int mouseX, int mouseY) {
            Biome biome = (Biome)this.contents.get(slot);
            this.clickFlag = !this.clickFlag;
            if (this.clickFlag && !this.selected.add(biome)) {
                this.selected.remove(biome);
            }
        }

        protected boolean func_148131_a(int slot) {
            return this.selected.contains(this.contents.get(slot));
        }

        @Override
        public int compare(Biome o1, Biome o2) {
            int i = CaveUtils.compareWithNull(o1, o2);
            if (i == 0 && o1 != null && o2 != null) {
                i = Integer.compare(this.biomes.indexOf((Object)o1), this.biomes.indexOf((Object)o2));
            }
            return i;
        }

        protected void setFilter(String filter) {
            Object result;
            if (Strings.isNullOrEmpty((String)filter)) {
                result = this.biomes;
            } else if (filter.equals("selected")) {
                result = Lists.newArrayList(this.selected);
            } else {
                if (!this.filterCache.containsKey(filter)) {
                    this.filterCache.put(filter, this.biomes.parallelStream().filter(e -> this.filterMatch((Biome)e, filter)).collect(Collectors.toList()));
                }
                result = this.filterCache.get(filter);
            }
            if (!this.contents.equals(result)) {
                this.contents.clear();
                this.contents.addAll(result);
            }
        }

        protected boolean filterMatch(Biome biome, String filter) {
            return CaveFilters.biomeFilter(biome, filter);
        }
    }
}

