/*
 * Decompiled with CFR 0.152.
 */
package cavern.client.gui;

import cavern.client.CaveKeyBindings;
import cavern.client.config.CaveConfigGui;
import cavern.client.gui.GuiListSlot;
import cavern.data.Miner;
import cavern.data.MinerRank;
import cavern.util.BlockMeta;
import cavern.util.PanoramaPaths;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiMiningRecords
extends GuiScreen {
    protected RecordList recordList;
    protected GuiButton doneButton;
    protected GuiCheckBox detailInfo;
    protected HoverChecker detailHoverChecker;
    protected HoverChecker selectedHoverChecker;

    public void func_73866_w_() {
        if (this.recordList == null) {
            this.recordList = new RecordList();
        }
        this.recordList.func_148122_a(this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - 28);
        if (this.doneButton == null) {
            this.doneButton = new GuiButtonExt(0, 0, 0, 145, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        }
        this.doneButton.field_146128_h = this.field_146294_l / 2 + 10;
        this.doneButton.field_146129_i = this.field_146295_m - this.doneButton.field_146121_g - 4;
        if (this.detailInfo == null) {
            this.detailInfo = new GuiCheckBox(1, 0, 12, I18n.func_135052_a((String)"cavern.config.detail", (Object[])new Object[0]), true);
        }
        this.detailInfo.setIsChecked(CaveConfigGui.detailInfo);
        this.detailInfo.field_146128_h = this.field_146294_l / 2 + 95;
        this.field_146292_n.clear();
        this.field_146292_n.add(this.doneButton);
        this.field_146292_n.add(this.detailInfo);
        this.detailHoverChecker = new HoverChecker((GuiButton)this.detailInfo, 800);
        this.selectedHoverChecker = new HoverChecker(0, 20, 0, 100, 800);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 0: {
                    this.field_146297_k.func_147108_a(null);
                    break;
                }
                case 1: {
                    CaveConfigGui.detailInfo = this.detailInfo.isChecked();
                }
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float ticks) {
        this.recordList.func_148128_a(mouseX, mouseY, ticks);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"cavern.miningrecords.gui.title", (Object[])new Object[0]), this.field_146294_l / 2, 15, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, String.format("%s: %s (%d)", I18n.func_135052_a((String)"cavern.miningrecords.gui.score", (Object[])new Object[0]), this.recordList.getScoreRank(), this.recordList.score), this.field_146294_l / 2 - 155, this.field_146295_m - 18, 0xEEEEEE);
        super.func_73863_a(mouseX, mouseY, ticks);
        if (this.detailHoverChecker.checkHover(mouseX, mouseY)) {
            this.func_146283_a(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)"cavern.config.detail.hover", (Object[])new Object[0]), 300), mouseX, mouseY);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.recordList.func_178039_p();
    }

    protected void func_73869_a(char c, int code) throws IOException {
        if (code == 1 || code == CaveKeyBindings.KEY_MINING_RECORDS.func_151463_i()) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        } else if (code == 15) {
            if (++this.recordList.nameType > 2) {
                this.recordList.nameType = 0;
            }
        } else if (code == 200) {
            this.recordList.scrollUp();
        } else if (code == 208) {
            this.recordList.scrollDown();
        } else if (code == 199) {
            this.recordList.scrollToTop();
        } else if (code == 207) {
            this.recordList.scrollToEnd();
        } else if (code == 201) {
            this.recordList.scrollToPrev();
        } else if (code == 209) {
            this.recordList.scrollToNext();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected class MiningRecord
    implements Comparable<MiningRecord> {
        protected BlockMeta blockMeta;
        protected int count;

        protected MiningRecord(BlockMeta blockMeta, int count) {
            this.blockMeta = blockMeta;
            this.count = count;
        }

        public boolean equals(Object obj) {
            return this.blockMeta.equals(obj);
        }

        public int hashCode() {
            return this.blockMeta.hashCode();
        }

        @Override
        public int compareTo(MiningRecord record) {
            int i = Integer.compare(record.count, this.count);
            if (i == 0) {
                i = this.blockMeta.compareTo(record.blockMeta);
            }
            return i;
        }
    }

    protected class RecordList
    extends GuiListSlot {
        protected final NonNullList<MiningRecord> entries;
        protected int nameType;
        protected int totalCount;
        protected int score;

        protected RecordList() {
            super(GuiMiningRecords.this.field_146297_k, 0, 0, 0, 0, 18);
            this.entries = NonNullList.func_191196_a();
            for (Map.Entry<BlockMeta, Integer> entry : Miner.get((EntityPlayer)GuiMiningRecords.this.field_146297_k.field_71439_g).getMiningRecords().entrySet()) {
                BlockMeta blockMeta = entry.getKey();
                int count = entry.getValue();
                this.entries.add((Object)new MiningRecord(blockMeta, count));
                this.totalCount += count;
                int amount = Miner.getPointAmount(blockMeta.getBlock(), blockMeta.getMeta());
                if (count > 1) {
                    amount += (count - 1) * Math.max(amount / 2, 1);
                }
                this.score += amount;
            }
            this.entries.sort(null);
        }

        @Override
        public PanoramaPaths getPanoramaPaths() {
            return null;
        }

        @Override
        public void scrollToSelected() {
        }

        protected int func_148127_b() {
            return this.entries.size();
        }

        @Nullable
        public String getBlockName(@Nullable BlockMeta blockMeta, ItemStack stack) {
            if (blockMeta == null) {
                return null;
            }
            if (stack.func_190926_b()) {
                stack = new ItemStack(blockMeta.getBlock(), 1, blockMeta.getMeta());
            }
            String name = null;
            if (this.nameType == 1) {
                name = blockMeta.getName();
            } else if (stack.func_77973_b() != Items.field_190931_a) {
                switch (this.nameType) {
                    case 2: {
                        name = stack.func_77977_a();
                        name = name.substring(name.indexOf(".") + 1);
                        break;
                    }
                    default: {
                        name = stack.func_82833_r();
                        break;
                    }
                }
            } else {
                switch (this.nameType) {
                    case 2: {
                        name = blockMeta.getBlock().func_149739_a();
                        name = name.substring(name.indexOf(".") + 1);
                        break;
                    }
                    default: {
                        name = blockMeta.getBlock().func_149732_F();
                    }
                }
            }
            return name;
        }

        @Nullable
        public String getBlockName(@Nullable BlockMeta blockMeta) {
            return this.getBlockName(blockMeta, ItemStack.field_190927_a);
        }

        protected void func_148123_a() {
            GuiMiningRecords.this.func_146276_q_();
        }

        protected void func_192637_a(int slot, int par2, int par3, int par4, int mouseX, int mouseY, float partialTicks) {
            MiningRecord record = (MiningRecord)this.entries.get(slot);
            String name = this.getBlockName(record.blockMeta);
            if (!Strings.isNullOrEmpty((String)name)) {
                GuiMiningRecords.this.func_73732_a(GuiMiningRecords.this.field_146289_q, name, this.field_148155_a / 2, par3 + 1, 0xFFFFFF);
            }
            this.drawItemStack(GuiMiningRecords.this.field_146296_j, record.blockMeta, this.field_148155_a / 2 - 100, par3 - 1, GuiMiningRecords.this.field_146289_q, Integer.toString(record.count));
            if (GuiMiningRecords.this.detailInfo.isChecked()) {
                MinerRank rank;
                switch (slot) {
                    case 0: {
                        rank = MinerRank.DIAMOND_MINER;
                        break;
                    }
                    case 1: {
                        rank = MinerRank.GOLD_MINER;
                        break;
                    }
                    case 2: {
                        rank = MinerRank.IRON_MINER;
                        break;
                    }
                    default: {
                        rank = record.count > 1 ? MinerRank.STONE_MINER : MinerRank.BEGINNER;
                    }
                }
                double d = (double)record.count / (double)this.totalCount * 100.0;
                this.drawItemStack(GuiMiningRecords.this.field_146296_j, rank.getItemStack(), this.field_148155_a / 2 + 90, par3 - 1, GuiMiningRecords.this.field_146289_q, String.format("%.2f", d) + "%");
            }
        }

        protected void func_148144_a(int slot, boolean flag, int mouseX, int mouseY) {
        }

        protected boolean func_148131_a(int slot) {
            return false;
        }

        protected String getScoreRank() {
            if (this.score >= 100000) {
                return "S+";
            }
            if (this.score >= 50000) {
                return "S";
            }
            if (this.score >= 10000) {
                return "A";
            }
            if (this.score >= 5000) {
                return "B";
            }
            if (this.score >= 3000) {
                return "C";
            }
            if (this.score >= 1000) {
                return "D";
            }
            return "E";
        }
    }
}

