/*
 * Decompiled with CFR 0.152.
 */
package cavern.client.gui;

import cavern.client.CaveRenderingRegistry;
import cavern.client.config.CaveConfigGui;
import cavern.client.gui.GuiListSlot;
import cavern.client.gui.GuiSelectBlock;
import cavern.client.gui.GuiSelectOreDict;
import cavern.client.gui.ISelectorCallback;
import cavern.client.gui.SelectSwitchEntry;
import cavern.util.BlockMeta;
import cavern.util.CaveFilters;
import cavern.util.CaveUtils;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiMiningPointsEditor
extends GuiScreen {
    protected final GuiScreen parent;
    protected final GuiConfigEntries.ArrayEntry arrayEntry;
    protected PointList pointList;
    protected GuiButton doneButton;
    protected GuiButton editButton;
    protected GuiButton cancelButton;
    protected GuiButton addButton;
    protected GuiButton removeButton;
    protected GuiButton clearButton;
    protected GuiCheckBox detailInfo;
    protected GuiCheckBox instantFilter;
    protected GuiTextField filterTextField;
    protected HoverChecker detailHoverChecker;
    protected HoverChecker instantHoverChecker;
    protected boolean editMode;
    protected GuiTextField pointField;
    protected HoverChecker pointHoverChecker;
    private int maxLabelWidth;
    private final List<String> editLabelList = Lists.newArrayList();
    private final List<GuiTextField> editFieldList = Lists.newArrayList();

    public GuiMiningPointsEditor(GuiScreen parent, GuiConfigEntries.ArrayEntry entry) {
        this.parent = parent;
        this.arrayEntry = entry;
    }

    public void func_73866_w_() {
        if (this.pointList == null) {
            this.pointList = new PointList();
        }
        this.pointList.func_148122_a(this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - (this.editMode ? 52 : 28));
        if (this.doneButton == null) {
            this.doneButton = new GuiButtonExt(0, 0, 0, 65, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        }
        this.doneButton.field_146128_h = this.field_146294_l / 2 + 135;
        this.doneButton.field_146129_i = this.field_146295_m - this.doneButton.field_146121_g - 4;
        if (this.editButton == null) {
            this.editButton = new GuiButtonExt(1, 0, 0, this.doneButton.field_146120_f, this.doneButton.field_146121_g, I18n.func_135052_a((String)"gui.edit", (Object[])new Object[0]));
            this.editButton.field_146124_l = false;
        }
        this.editButton.field_146128_h = this.doneButton.field_146128_h - this.doneButton.field_146120_f - 3;
        this.editButton.field_146129_i = this.doneButton.field_146129_i;
        this.editButton.field_146124_l = this.pointList.selected != null;
        boolean bl = this.editButton.field_146125_m = !this.editMode;
        if (this.cancelButton == null) {
            this.cancelButton = new GuiButtonExt(2, 0, 0, this.editButton.field_146120_f, this.editButton.field_146121_g, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]));
        }
        this.cancelButton.field_146128_h = this.editButton.field_146128_h;
        this.cancelButton.field_146129_i = this.editButton.field_146129_i;
        this.cancelButton.field_146125_m = this.editMode;
        if (this.removeButton == null) {
            this.removeButton = new GuiButtonExt(4, 0, 0, this.doneButton.field_146120_f, this.doneButton.field_146121_g, I18n.func_135052_a((String)"gui.remove", (Object[])new Object[0]));
        }
        this.removeButton.field_146128_h = this.editButton.field_146128_h - this.editButton.field_146120_f - 3;
        this.removeButton.field_146129_i = this.doneButton.field_146129_i;
        boolean bl2 = this.removeButton.field_146125_m = !this.editMode;
        if (this.addButton == null) {
            this.addButton = new GuiButtonExt(3, 0, 0, this.doneButton.field_146120_f, this.doneButton.field_146121_g, I18n.func_135052_a((String)"gui.add", (Object[])new Object[0]));
        }
        this.addButton.field_146128_h = this.removeButton.field_146128_h - this.removeButton.field_146120_f - 3;
        this.addButton.field_146129_i = this.doneButton.field_146129_i;
        boolean bl3 = this.addButton.field_146125_m = !this.editMode;
        if (this.clearButton == null) {
            this.clearButton = new GuiButtonExt(5, 0, 0, this.removeButton.field_146120_f, this.removeButton.field_146121_g, I18n.func_135052_a((String)"gui.clear", (Object[])new Object[0]));
        }
        this.clearButton.field_146128_h = this.removeButton.field_146128_h;
        this.clearButton.field_146129_i = this.removeButton.field_146129_i;
        this.clearButton.field_146125_m = false;
        if (this.detailInfo == null) {
            this.detailInfo = new GuiCheckBox(6, 0, 5, I18n.func_135052_a((String)"cavern.config.detail", (Object[])new Object[0]), true);
        }
        this.detailInfo.setIsChecked(CaveConfigGui.detailInfo);
        this.detailInfo.field_146128_h = this.field_146294_l / 2 + 95;
        if (this.instantFilter == null) {
            this.instantFilter = new GuiCheckBox(7, 0, this.detailInfo.field_146129_i + this.detailInfo.field_146121_g + 2, I18n.func_135052_a((String)"cavern.config.instant", (Object[])new Object[0]), true);
        }
        this.instantFilter.setIsChecked(CaveConfigGui.instantFilter);
        this.instantFilter.field_146128_h = this.detailInfo.field_146128_h;
        this.field_146292_n.clear();
        this.field_146292_n.add(this.doneButton);
        if (this.editMode) {
            this.field_146292_n.add(this.cancelButton);
        } else {
            this.field_146292_n.add(this.editButton);
            this.field_146292_n.add(this.addButton);
            this.field_146292_n.add(this.removeButton);
            this.field_146292_n.add(this.clearButton);
        }
        this.field_146292_n.add(this.detailInfo);
        this.field_146292_n.add(this.instantFilter);
        if (this.filterTextField == null) {
            this.filterTextField = new GuiTextField(0, this.field_146289_q, 0, 0, 122, 16);
            this.filterTextField.func_146203_f(500);
        }
        this.filterTextField.field_146209_f = this.field_146294_l / 2 - 200;
        this.filterTextField.field_146210_g = this.field_146295_m - this.filterTextField.field_146219_i - 6;
        this.detailHoverChecker = new HoverChecker((GuiButton)this.detailInfo, 800);
        this.instantHoverChecker = new HoverChecker((GuiButton)this.instantFilter, 800);
        this.editLabelList.clear();
        this.editLabelList.add(I18n.func_135052_a((String)"cavern.config.points.point", (Object[])new Object[0]));
        for (String key : this.editLabelList) {
            this.maxLabelWidth = Math.max(this.maxLabelWidth, this.field_146289_q.func_78256_a(key));
        }
        if (this.pointField == null) {
            this.pointField = new GuiTextField(5, this.field_146289_q, 0, 0, 0, 15);
            this.pointField.func_146203_f(5);
        }
        int i = this.maxLabelWidth + 8 + this.field_146294_l / 2;
        this.pointField.field_146209_f = this.field_146294_l / 2 - i / 2 + this.maxLabelWidth + 10;
        this.pointField.field_146210_g = this.pointList.field_148154_c + 7;
        int fieldWidth = this.field_146294_l / 2 + i / 2 - 45 - this.pointField.field_146209_f + 40;
        this.pointField.field_146218_h = fieldWidth / 4 + fieldWidth / 2 - 1;
        this.editFieldList.clear();
        if (this.editMode) {
            this.editFieldList.add(this.pointField);
        }
        this.pointHoverChecker = new HoverChecker(this.pointField.field_146210_g - 1, this.pointField.field_146210_g + this.pointField.field_146219_i, this.pointField.field_146209_f - this.maxLabelWidth - 12, this.pointField.field_146209_f - 10, 800);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 0: {
                    if (this.editMode) {
                        if (!Strings.isNullOrEmpty((String)this.pointField.func_146179_b())) {
                            for (PointEntry entry2 : this.pointList.selected) {
                                entry2.setPoint(NumberUtils.toInt((String)this.pointField.func_146179_b(), (int)entry2.getPoint()));
                            }
                        }
                        this.func_146284_a(this.cancelButton);
                        this.pointList.scrollToTop();
                        this.pointList.scrollToSelected();
                        break;
                    }
                    this.arrayEntry.setListFromChildScreen(this.pointList.points.stream().map(PointEntry::toString).collect(Collectors.toList()).toArray());
                    this.func_146284_a(this.cancelButton);
                    this.pointList.selected.clear();
                    this.pointList.scrollToTop();
                    break;
                }
                case 1: {
                    if (this.editMode) {
                        this.func_146284_a(this.cancelButton);
                        break;
                    }
                    if (this.pointList.selected.isEmpty()) break;
                    this.editMode = true;
                    this.func_73866_w_();
                    this.pointList.scrollToTop();
                    this.pointList.scrollToSelected();
                    if (this.pointList.selected.size() > 1) {
                        this.pointField.func_146180_a("");
                        break;
                    }
                    for (PointEntry entry3 : this.pointList.selected) {
                        this.pointField.func_146180_a(Integer.toString(entry3.getPoint()));
                    }
                    break;
                }
                case 2: {
                    if (this.editMode) {
                        this.editMode = false;
                        this.func_73866_w_();
                        break;
                    }
                    this.field_146297_k.func_147108_a(this.parent);
                    break;
                }
                case 3: {
                    if (GuiMiningPointsEditor.func_146272_n()) {
                        this.field_146297_k.func_147108_a((GuiScreen)this.getSelectBlockGuiScreen());
                        break;
                    }
                    this.field_146297_k.func_147108_a((GuiScreen)this.getSelectOreDictGuiScreen());
                    break;
                }
                case 4: {
                    for (PointEntry entry4 : this.pointList.selected) {
                        if (!this.pointList.points.remove((Object)entry4)) continue;
                        this.pointList.contents.remove((Object)entry4);
                    }
                    this.pointList.selected.clear();
                    break;
                }
                case 5: {
                    this.pointList.points.forEach(entry -> this.pointList.selected.add((PointEntry)entry));
                    this.func_146284_a(this.removeButton);
                    break;
                }
                case 6: {
                    CaveConfigGui.detailInfo = this.detailInfo.isChecked();
                    break;
                }
                case 7: {
                    CaveConfigGui.instantFilter = this.instantFilter.isChecked();
                    break;
                }
                default: {
                    this.pointList.func_148147_a(button);
                }
            }
        }
    }

    public GuiSelectBlock getSelectBlockGuiScreen() {
        GuiSelectBlock selectBlock = this.createSelectBlockGuiScreen();
        GuiSelectOreDict selectOreDict = this.createSelectOreDictGuiScreen();
        selectBlock.setSwitchEntry(new SelectSwitchEntry(selectOreDict, "oreDict"));
        selectOreDict.setSwitchEntry(new SelectSwitchEntry(selectBlock, "block"));
        return selectBlock;
    }

    protected GuiSelectBlock createSelectBlockGuiScreen() {
        final Set invisibleBlocks = this.pointList.points.stream().filter(PointEntry::isBlockMeta).map(PointEntry::getBlockMeta).collect(Collectors.toSet());
        return new GuiSelectBlock((GuiScreen)this, new ISelectorCallback<BlockMeta>(){

            @Override
            public boolean isValidEntry(BlockMeta entry) {
                return entry != null && !invisibleBlocks.contains(entry);
            }

            @Override
            public void onSelected(List<BlockMeta> selected) {
                if (GuiMiningPointsEditor.this.editMode) {
                    return;
                }
                GuiMiningPointsEditor.this.pointList.selected.clear();
                for (BlockMeta blockMeta : selected) {
                    PointEntry entry = new PointEntry(blockMeta, 1);
                    GuiMiningPointsEditor.this.pointList.points.add((Object)entry);
                    GuiMiningPointsEditor.this.pointList.contents.add((Object)entry);
                    GuiMiningPointsEditor.this.pointList.selected.add(entry);
                }
                GuiMiningPointsEditor.this.pointList.scrollToTop();
                GuiMiningPointsEditor.this.pointList.scrollToSelected();
            }
        });
    }

    public GuiSelectOreDict getSelectOreDictGuiScreen() {
        GuiSelectOreDict selectOreDict = this.createSelectOreDictGuiScreen();
        GuiSelectBlock selectBlock = this.createSelectBlockGuiScreen();
        selectOreDict.setSwitchEntry(new SelectSwitchEntry(selectBlock, "block"));
        selectBlock.setSwitchEntry(new SelectSwitchEntry(selectOreDict, "oreDict"));
        return selectOreDict;
    }

    protected GuiSelectOreDict createSelectOreDictGuiScreen() {
        final Set invisibleDicts = this.pointList.points.stream().filter(PointEntry::isOreDict).map(PointEntry::getOreDict).collect(Collectors.toSet());
        return new GuiSelectOreDict((GuiScreen)this, new ISelectorCallback<GuiSelectOreDict.OreDictEntry>(){

            @Override
            public boolean isValidEntry(GuiSelectOreDict.OreDictEntry entry) {
                return !entry.getItemStack().func_190926_b() && entry.getItemStack().func_77973_b() instanceof ItemBlock && !invisibleDicts.contains(entry);
            }

            @Override
            public void onSelected(List<GuiSelectOreDict.OreDictEntry> selected) {
                if (GuiMiningPointsEditor.this.editMode) {
                    return;
                }
                GuiMiningPointsEditor.this.pointList.selected.clear();
                for (GuiSelectOreDict.OreDictEntry oreDict : selected) {
                    PointEntry entry = new PointEntry(oreDict, 1);
                    GuiMiningPointsEditor.this.pointList.points.add((Object)entry);
                    GuiMiningPointsEditor.this.pointList.contents.add((Object)entry);
                    GuiMiningPointsEditor.this.pointList.selected.add(entry);
                }
                GuiMiningPointsEditor.this.pointList.scrollToTop();
                GuiMiningPointsEditor.this.pointList.scrollToSelected();
            }
        });
    }

    public void func_73876_c() {
        if (this.editMode) {
            for (GuiTextField textField : this.editFieldList) {
                if (!textField.func_146176_q()) continue;
                textField.func_146178_a();
            }
        } else {
            this.removeButton.field_146124_l = this.editButton.field_146124_l = !this.pointList.selected.isEmpty();
            this.filterTextField.func_146178_a();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float ticks) {
        this.pointList.func_148128_a(mouseX, mouseY, ticks);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"cavern.config.points", (Object[])new Object[0]), this.field_146294_l / 2, 15, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, ticks);
        if (this.editMode) {
            int size = this.editFieldList.size();
            for (int i = 0; i < size; ++i) {
                GuiTextField textField = this.editFieldList.get(i);
                if (!textField.func_146176_q()) continue;
                textField.func_146194_f();
                this.func_73731_b(this.field_146289_q, this.editLabelList.get(i), textField.field_146209_f - this.maxLabelWidth - 10, textField.field_146210_g + 3, 0xBBBBBB);
            }
            if (this.pointHoverChecker.checkHover(mouseX, mouseY)) {
                ArrayList hover = Lists.newArrayList();
                String key = "cavern.config.points.point";
                hover.add(TextFormatting.GRAY + I18n.func_135052_a((String)key, (Object[])new Object[0]));
                hover.addAll(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)(key + ".tooltip"), (Object[])new Object[0]), 300));
                this.func_146283_a(hover, mouseX, mouseY);
            }
        } else {
            this.filterTextField.func_146194_f();
        }
        if (this.detailHoverChecker.checkHover(mouseX, mouseY)) {
            this.func_146283_a(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)"cavern.config.detail.hover", (Object[])new Object[0]), 300), mouseX, mouseY);
        } else if (this.instantHoverChecker.checkHover(mouseX, mouseY)) {
            this.func_146283_a(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)"cavern.config.instant.hover", (Object[])new Object[0]), 300), mouseX, mouseY);
        } else if (this.pointList.func_148141_e(mouseY) && GuiMiningPointsEditor.func_146271_m()) {
            PointEntry entry = (PointEntry)this.pointList.contents.get(this.pointList.func_148124_c(mouseX, mouseY));
            ArrayList info = Lists.newArrayList();
            String prefix = TextFormatting.GRAY.toString();
            if (entry.isOreDict()) {
                info.add(prefix + I18n.func_135052_a((String)"cavern.config.points.oreDict", (Object[])new Object[0]) + ": " + entry.getOreDict().getName());
            } else {
                info.add(prefix + I18n.func_135052_a((String)"cavern.config.points.block", (Object[])new Object[0]) + ": " + entry.getBlockMeta().getBlockName() + ":" + entry.getBlockMeta().getMetaString());
            }
            info.add(prefix + I18n.func_135052_a((String)"cavern.config.points.point", (Object[])new Object[0]) + ": " + entry.getPoint());
            this.func_146283_a(info, mouseX, mouseY);
        }
        if (this.pointList.selected.size() > 1 && mouseX <= 100 && mouseY <= 20) {
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"cavern.config.select.entry.selected", (Object[])new Object[]{this.pointList.selected.size()}), 5, 5, 0xEFEFEF);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.pointList.func_178039_p();
        if (this.editMode && this.pointField.func_146206_l()) {
            int i = Mouse.getDWheel();
            if (i < 0) {
                this.pointField.func_146180_a(Integer.toString(Math.max(NumberUtils.toInt((String)this.pointField.func_146179_b()) - 1, 1)));
            } else if (i > 0) {
                this.pointField.func_146180_a(Integer.toString(NumberUtils.toInt((String)this.pointField.func_146179_b()) + 1));
            }
        }
    }

    protected void func_73864_a(int x, int y, int code) throws IOException {
        super.func_73864_a(x, y, code);
        if (code == 1) {
            this.func_146284_a(this.editButton);
        } else if (this.editMode) {
            this.pointField.func_146192_a(x, y, code);
        } else {
            this.filterTextField.func_146192_a(x, y, code);
        }
    }

    public void func_146282_l() throws IOException {
        super.func_146282_l();
        if (Keyboard.getEventKey() == 42 || Keyboard.getEventKey() == 54) {
            this.clearButton.field_146125_m = !this.editMode && Keyboard.getEventKeyState();
        }
    }

    protected void func_73869_a(char c, int code) throws IOException {
        if (this.editMode) {
            for (GuiTextField textField : this.editFieldList) {
                if (code == 1) {
                    textField.func_146195_b(false);
                    continue;
                }
                if (!textField.func_146176_q() || !textField.func_146206_l() || !CharUtils.isAsciiControl((char)c) && !CharUtils.isAsciiNumeric((char)c)) continue;
                textField.func_146201_a(c, code);
            }
        } else if (this.filterTextField.func_146206_l()) {
            boolean changed;
            if (code == 1) {
                this.filterTextField.func_146195_b(false);
            }
            String prev = this.filterTextField.func_146179_b();
            this.filterTextField.func_146201_a(c, code);
            String text = this.filterTextField.func_146179_b();
            boolean bl = changed = text != prev;
            if (Strings.isNullOrEmpty((String)text) && changed) {
                this.pointList.setFilter(null);
            } else if (this.instantFilter.isChecked() && changed || code == 28) {
                this.pointList.setFilter(text);
            }
        } else if (code == 1) {
            this.func_146284_a(this.doneButton);
        } else if (code == 14) {
            this.pointList.selected.clear();
        } else if (code == 15) {
            if (++this.pointList.nameType > 2) {
                this.pointList.nameType = 0;
            }
        } else if (code == 199) {
            this.pointList.scrollToTop();
        } else if (code == 207) {
            this.pointList.scrollToEnd();
        } else if (code == 57) {
            this.pointList.scrollToSelected();
        } else if (code == 201) {
            this.pointList.scrollToPrev();
        } else if (code == 209) {
            this.pointList.scrollToNext();
        } else if (code == 33 || code == this.field_146297_k.field_71474_y.field_74310_D.func_151463_i()) {
            this.filterTextField.func_146195_b(true);
        } else if (GuiMiningPointsEditor.func_146271_m() && code == 30) {
            this.pointList.contents.forEach(entry -> this.pointList.selected.add((PointEntry)entry));
        } else if (code == 211 && !this.pointList.selected.isEmpty()) {
            this.func_146284_a(this.removeButton);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        this.pointList.currentPanoramaPaths = null;
    }

    public static class PointEntry
    implements Comparable<PointEntry> {
        private BlockMeta blockMeta;
        private GuiSelectOreDict.OreDictEntry oreDict;
        private int point;

        public PointEntry(BlockMeta block, int point) {
            this.blockMeta = block;
            this.point = point;
        }

        public PointEntry(GuiSelectOreDict.OreDictEntry oreDict, int point) {
            this.oreDict = oreDict;
            this.point = point;
        }

        public BlockMeta getBlockMeta() {
            return this.blockMeta;
        }

        public void setBlockMeta(BlockMeta block) {
            this.blockMeta = block;
        }

        public GuiSelectOreDict.OreDictEntry getOreDict() {
            return this.oreDict;
        }

        public void setOreDict(GuiSelectOreDict.OreDictEntry entry) {
            this.oreDict = entry;
        }

        public boolean isBlockMeta() {
            return this.blockMeta != null;
        }

        public boolean isOreDict() {
            return this.oreDict != null;
        }

        public String getName() {
            return this.isOreDict() ? this.oreDict.toString() : this.blockMeta.getName(true);
        }

        public int getPoint() {
            return this.point;
        }

        public void setPoint(int value) {
            this.point = value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PointEntry)) {
                return false;
            }
            PointEntry entry = (PointEntry)obj;
            if (this.isOreDict() && entry.isOreDict()) {
                return this.oreDict.equals(entry.oreDict);
            }
            if (this.isBlockMeta() && entry.isBlockMeta()) {
                return Objects.equal((Object)this.blockMeta, (Object)entry.blockMeta);
            }
            return false;
        }

        public int hashCode() {
            return this.isOreDict() ? this.oreDict.hashCode() : this.blockMeta.hashCode();
        }

        public String toString() {
            return this.getName() + "," + this.point;
        }

        @Override
        public int compareTo(PointEntry entry) {
            int i = CaveUtils.compareWithNull(this, entry);
            if (i == 0 && entry != null && (i = Boolean.compare(this.isOreDict(), entry.isOreDict())) == 0) {
                i = this.isOreDict() && entry.isOreDict() ? this.oreDict.compareTo(entry.oreDict) : this.blockMeta.compareTo(entry.blockMeta);
            }
            return i;
        }
    }

    protected class PointList
    extends GuiListSlot
    implements Comparator<PointEntry> {
        protected final NonNullList<PointEntry> points;
        protected final NonNullList<PointEntry> contents;
        protected final Set<PointEntry> selected;
        protected final Map<String, List<PointEntry>> filterCache;
        protected int nameType;
        protected boolean clickFlag;

        protected PointList() {
            super(GuiMiningPointsEditor.this.field_146297_k, 0, 0, 0, 0, 22);
            this.points = NonNullList.func_191196_a();
            this.contents = NonNullList.func_191196_a();
            this.selected = Sets.newTreeSet((Comparator)this);
            this.filterCache = Maps.newHashMap();
            for (Object obj : GuiMiningPointsEditor.this.arrayEntry.getCurrentValues()) {
                BlockMeta blockMeta;
                String value = String.valueOf(obj);
                if (Strings.isNullOrEmpty((String)value) || !value.contains(",")) continue;
                value = value.trim();
                int i = value.indexOf(44);
                String str = value.substring(0, i).trim();
                int point = NumberUtils.toInt((String)value.substring(i + 1));
                if (OreDictionary.doesOreNameExist((String)str)) {
                    PointEntry entry = new PointEntry(new GuiSelectOreDict.OreDictEntry(str), point);
                    this.points.add((Object)entry);
                    this.contents.add((Object)entry);
                    continue;
                }
                if (!str.contains(":")) {
                    str = "minecraft:" + str;
                }
                if (str.indexOf(58) != str.lastIndexOf(58)) {
                    i = str.lastIndexOf(58);
                    blockMeta = new BlockMeta(str.substring(0, i), str.substring(i + 1));
                } else {
                    blockMeta = new BlockMeta(str, 0);
                }
                if (!blockMeta.isNotAir()) continue;
                PointEntry entry = new PointEntry(blockMeta, point);
                this.points.add((Object)entry);
                this.contents.add((Object)entry);
            }
        }

        @Override
        public void scrollToSelected() {
            if (!this.selected.isEmpty()) {
                int amount = 0;
                for (PointEntry entry : this.selected) {
                    amount = this.contents.indexOf((Object)entry) * this.func_148146_j();
                    if (this.func_148148_g() == amount) continue;
                    break;
                }
                this.scrollToTop();
                this.func_148145_f(amount);
            }
        }

        protected int func_148127_b() {
            return this.contents.size();
        }

        protected void func_148123_a() {
            GuiMiningPointsEditor.this.func_146276_q_();
        }

        protected void func_192637_a(int index, int par2, int par3, int par4, int mouseX, int mouseY, float partialTicks) {
            PointEntry entry = (PointEntry)this.contents.get(index);
            String text = null;
            ItemStack stack = null;
            if (entry.isOreDict()) {
                stack = entry.getOreDict().getItemStack();
                text = this.nameType == 0 && !stack.func_190926_b() ? stack.func_82833_r() : entry.getOreDict().getName();
            } else {
                boolean hasItem;
                BlockMeta blockMeta = entry.getBlockMeta();
                Block block = blockMeta.getBlock();
                int meta = blockMeta.getMeta();
                stack = new ItemStack(CaveRenderingRegistry.getRenderBlock(block), 1, meta);
                boolean bl = hasItem = stack.func_77973_b() != Items.field_190931_a;
                if (this.nameType == 1) {
                    text = blockMeta.getName();
                } else if (hasItem) {
                    switch (this.nameType) {
                        case 2: {
                            text = stack.func_77977_a();
                            text = text.substring(text.indexOf(".") + 1);
                            break;
                        }
                        default: {
                            text = stack.func_82833_r();
                            break;
                        }
                    }
                } else {
                    switch (this.nameType) {
                        case 2: {
                            text = block.func_149739_a();
                            text = text.substring(text.indexOf(".") + 1);
                            break;
                        }
                        default: {
                            text = block.func_149732_F();
                        }
                    }
                }
            }
            if (!Strings.isNullOrEmpty((String)text)) {
                GuiMiningPointsEditor.this.func_73732_a(GuiMiningPointsEditor.this.field_146289_q, text, this.field_148155_a / 2, par3 + 3, 0xFFFFFF);
            }
            if (GuiMiningPointsEditor.this.detailInfo.isChecked()) {
                this.drawItemStack(GuiMiningPointsEditor.this.field_146296_j, stack, this.field_148155_a / 2 - 100, par3 + 1, GuiMiningPointsEditor.this.field_146289_q, Integer.toString(entry.getPoint()));
            }
        }

        protected void func_148144_a(int index, boolean flag, int mouseX, int mouseY) {
            if (GuiMiningPointsEditor.this.editMode) {
                return;
            }
            PointEntry entry = (PointEntry)this.contents.get(index);
            this.clickFlag = !this.clickFlag;
            if (this.clickFlag && !this.selected.remove(entry)) {
                if (!GuiScreen.func_146271_m()) {
                    this.selected.clear();
                }
                this.selected.add(entry);
            }
        }

        protected boolean func_148131_a(int index) {
            return this.selected.contains(this.contents.get(index));
        }

        protected void setFilter(String filter) {
            Object result;
            if (Strings.isNullOrEmpty((String)filter)) {
                result = this.points;
            } else if (filter.equals("selected")) {
                result = Lists.newArrayList(this.selected);
            } else {
                if (!this.filterCache.containsKey(filter)) {
                    this.filterCache.put(filter, this.points.parallelStream().filter(e -> this.filterMatch((PointEntry)e, filter)).collect(Collectors.toList()));
                }
                result = this.filterCache.get(filter);
            }
            if (!this.contents.equals(result)) {
                this.contents.clear();
                this.contents.addAll(result);
            }
        }

        protected boolean filterMatch(PointEntry entry, String filter) {
            if (entry.isOreDict()) {
                return StringUtils.containsIgnoreCase((CharSequence)entry.getOreDict().getName(), (CharSequence)filter);
            }
            return CaveFilters.blockFilter(entry.getBlockMeta(), filter);
        }

        @Override
        public int compare(PointEntry o1, PointEntry o2) {
            int i = CaveUtils.compareWithNull(o1, o2);
            if (i == 0 && o1 != null && o2 != null) {
                i = Integer.compare(this.points.indexOf((Object)o1), this.points.indexOf((Object)o2));
            }
            return i;
        }
    }
}

