/*
 * Decompiled with CFR 0.152.
 */
package cavern.client.gui;

import cavern.client.CaveRenderingRegistry;
import cavern.util.BlockMeta;
import cavern.util.CaveUtils;
import cavern.util.PanoramaPaths;
import com.google.common.base.Strings;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ObjectUtils;
import org.lwjgl.util.glu.Project;

@SideOnly(value=Side.CLIENT)
public abstract class GuiListSlot
extends GuiSlot {
    public static final NonNullList<PanoramaPaths> PANORAMA_PATHS = NonNullList.func_191196_a();
    private static final Random RANDOM = new Random();
    private static int panoramaTimer;
    protected final Minecraft field_148161_k;
    private final DynamicTexture viewportTexture;
    private final ResourceLocation panoramaBackground;
    private float panoramaTicks;
    public PanoramaPaths currentPanoramaPaths;

    public GuiListSlot(Minecraft mc, int width, int height, int top, int bottom, int slotHeight) {
        super(mc, width, height, top, bottom, slotHeight);
        this.field_148161_k = mc;
        this.viewportTexture = new DynamicTexture(256, 256);
        this.panoramaBackground = mc.func_110434_K().func_110578_a("background", this.viewportTexture);
    }

    @Nullable
    public PanoramaPaths getPanoramaPaths() {
        if (PANORAMA_PATHS.isEmpty()) {
            this.currentPanoramaPaths = null;
        } else if (this.currentPanoramaPaths == null) {
            this.currentPanoramaPaths = (PanoramaPaths)PANORAMA_PATHS.get(RANDOM.nextInt(PANORAMA_PATHS.size()));
        }
        return this.currentPanoramaPaths;
    }

    private void drawPanorama(float ticks) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        Project.gluPerspective((float)120.0f, (float)1.0f, (float)0.05f, (float)10.0f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179129_p();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int b0 = 8;
        for (int k = 0; k < b0 * b0; ++k) {
            PanoramaPaths paths;
            GlStateManager.func_179094_E();
            float f1 = ((float)(k % b0) / (float)b0 - 0.5f) / 64.0f;
            float f2 = ((float)(k / b0) / (float)b0 - 0.5f) / 64.0f;
            float f3 = 0.0f;
            GlStateManager.func_179109_b((float)f1, (float)f2, (float)f3);
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)(((float)panoramaTimer + ticks) / 400.0f)) * 25.0f + 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-((float)panoramaTimer + ticks) * 0.1f), (float)0.0f, (float)1.0f, (float)0.0f);
            for (int l = 0; l < 6 && (paths = this.getPanoramaPaths()) != null; ++l) {
                GlStateManager.func_179094_E();
                switch (l) {
                    case 1: {
                        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case 2: {
                        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case 3: {
                        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case 4: {
                        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case 5: {
                        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    }
                }
                this.field_148161_k.func_110434_K().func_110577_a(paths.getPath(l));
                buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                int i = 255 / (k + 1);
                buffer.func_181662_b(-1.0, -1.0, 1.0).func_187315_a(0.0, 0.0).func_181669_b(255, 255, 255, i).func_181675_d();
                buffer.func_181662_b(1.0, -1.0, 1.0).func_187315_a(1.0, 0.0).func_181669_b(255, 255, 255, i).func_181675_d();
                buffer.func_181662_b(1.0, 1.0, 1.0).func_187315_a(1.0, 1.0).func_181669_b(255, 255, 255, i).func_181675_d();
                buffer.func_181662_b(-1.0, 1.0, 1.0).func_187315_a(0.0, 1.0).func_181669_b(255, 255, 255, i).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        }
        buffer.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179089_o();
        GlStateManager.func_179126_j();
    }

    private void rotateAndBlurSkybox(float ticks) {
        this.field_148161_k.func_110434_K().func_110577_a(this.panoramaBackground);
        GlStateManager.func_187421_b((int)3553, (int)10241, (int)9729);
        GlStateManager.func_187421_b((int)3553, (int)10240, (int)9729);
        GlStateManager.func_187443_a((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)256, (int)256);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        GlStateManager.func_179118_c();
        int b0 = 3;
        for (int i = 0; i < b0; ++i) {
            float f = 1.0f / (float)(i + 1);
            int j = this.field_148155_a;
            int k = this.field_148158_l;
            float f1 = (float)(i - b0 / 2) / 256.0f;
            buffer.func_181662_b((double)j, (double)k, 0.0).func_187315_a((double)(0.0f + f1), 1.0).func_181666_a(1.0f, 1.0f, 1.0f, f).func_181675_d();
            buffer.func_181662_b((double)j, 0.0, 0.0).func_187315_a((double)(1.0f + f1), 1.0).func_181666_a(1.0f, 1.0f, 1.0f, f).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a((double)(1.0f + f1), 0.0).func_181666_a(1.0f, 1.0f, 1.0f, f).func_181675_d();
            buffer.func_181662_b(0.0, (double)k, 0.0).func_187315_a((double)(0.0f + f1), 0.0).func_181666_a(1.0f, 1.0f, 1.0f, f).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179141_d();
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    private void renderSkybox(float ticks) {
        this.field_148161_k.func_147110_a().func_147609_e();
        GlStateManager.func_179083_b((int)0, (int)0, (int)256, (int)256);
        this.drawPanorama(ticks);
        this.rotateAndBlurSkybox(ticks);
        this.rotateAndBlurSkybox(ticks);
        this.rotateAndBlurSkybox(ticks);
        this.rotateAndBlurSkybox(ticks);
        this.rotateAndBlurSkybox(ticks);
        this.rotateAndBlurSkybox(ticks);
        this.rotateAndBlurSkybox(ticks);
        this.field_148161_k.func_147110_a().func_147610_a(true);
        GlStateManager.func_179083_b((int)0, (int)0, (int)this.field_148161_k.field_71443_c, (int)this.field_148161_k.field_71440_d);
        float f1 = this.field_148155_a > this.field_148158_l ? 120.0f / (float)this.field_148155_a : 120.0f / (float)this.field_148158_l;
        float f2 = (float)this.field_148158_l * f1 / 256.0f;
        float f3 = (float)this.field_148155_a * f1 / 256.0f;
        int k = this.field_148155_a;
        int l = this.field_148158_l;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b(0.0, (double)l, 0.0).func_187315_a((double)(0.5f - f2), (double)(0.5f + f3)).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)k, (double)l, 0.0).func_187315_a((double)(0.5f - f2), (double)(0.5f - f3)).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)k, 0.0, 0.0).func_187315_a((double)(0.5f + f2), (double)(0.5f - f3)).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a((double)(0.5f + f2), (double)(0.5f + f3)).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
    }

    public void func_148128_a(int mouseX, int mouseY, float partialTicks) {
        this.panoramaTicks = partialTicks;
        super.func_148128_a(mouseX, mouseY, partialTicks);
    }

    protected void drawContainerBackground(Tessellator tessellator) {
        if (this.field_148161_k.field_71441_e != null) {
            Gui.func_73734_a((int)this.field_148152_e, (int)this.field_148153_b, (int)this.field_148151_d, (int)this.field_148154_c, (int)0x101010);
        } else if (this.getPanoramaPaths() != null) {
            ++panoramaTimer;
            GlStateManager.func_179118_c();
            this.renderSkybox(this.panoramaTicks);
            GlStateManager.func_179141_d();
        } else {
            super.drawContainerBackground(tessellator);
        }
    }

    public void scrollUp() {
        int i = this.func_148148_g() % this.func_148146_j();
        if (i == 0) {
            this.func_148145_f(-this.func_148146_j());
        } else {
            this.func_148145_f(-i);
        }
    }

    public void scrollDown() {
        this.func_148145_f(this.func_148146_j() - this.func_148148_g() % this.func_148146_j());
    }

    public void scrollToTop() {
        this.func_148145_f(-this.func_148148_g());
    }

    public void scrollToEnd() {
        this.func_148145_f(this.func_148146_j() * this.func_148127_b());
    }

    public abstract void scrollToSelected();

    public void scrollToPrev() {
        this.func_148145_f(-(this.func_148148_g() % this.func_148146_j() + (this.field_148154_c - this.field_148153_b) / this.func_148146_j() * this.func_148146_j()));
    }

    public void scrollToNext() {
        this.func_148145_f(this.func_148148_g() % this.func_148146_j() + (this.field_148154_c - this.field_148153_b) / this.func_148146_j() * this.func_148146_j());
    }

    public void drawItemStack(RenderItem renderer, ItemStack stack, int x, int y) {
        this.drawItemStack(renderer, stack, x, y, null, null);
    }

    public void drawItemStack(RenderItem renderer, ItemStack stack, int x, int y, FontRenderer fontRenderer, @Nullable String overlay) {
        if (stack.func_190926_b()) {
            return;
        }
        if (stack.func_77960_j() == Short.MAX_VALUE) {
            NBTTagCompound nbt = stack.func_77978_p();
            stack = new ItemStack(stack.func_77973_b(), stack.func_190916_E());
            stack.func_77982_d(nbt);
        }
        GlStateManager.func_179091_B();
        RenderHelper.func_74520_c();
        renderer.func_175042_a(stack, x, y);
        if (!Strings.isNullOrEmpty((String)overlay)) {
            renderer.func_180453_a((FontRenderer)ObjectUtils.defaultIfNull((Object)stack.func_77973_b().getFontRenderer(stack), (Object)fontRenderer), stack, x, y, overlay);
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
    }

    public void drawItemStack(RenderItem renderer, @Nullable IBlockState state, int x, int y) {
        this.drawItemStack(renderer, state, x, y, null, null);
    }

    public void drawItemStack(RenderItem renderer, @Nullable IBlockState state, int x, int y, FontRenderer fontRenderer, @Nullable String overlay) {
        if (state == null) {
            return;
        }
        Item item = Item.func_150898_a((Block)CaveRenderingRegistry.getRenderBlock(state.func_177230_c()));
        if (item == Items.field_190931_a) {
            return;
        }
        int meta = state.func_177230_c().func_176201_c(state);
        this.drawItemStack(renderer, new ItemStack(item, 1, meta), x, y, fontRenderer, overlay);
    }

    public void drawItemStack(RenderItem renderer, @Nullable BlockMeta blockMeta, int x, int y) {
        this.drawItemStack(renderer, blockMeta, x, y, null, null);
    }

    public void drawItemStack(RenderItem renderer, @Nullable BlockMeta blockMeta, int x, int y, FontRenderer fontRenderer, @Nullable String overlay) {
        if (blockMeta == null) {
            return;
        }
        Item item = Item.func_150898_a((Block)CaveRenderingRegistry.getRenderBlock(blockMeta.getBlock()));
        if (item == Items.field_190931_a) {
            return;
        }
        this.drawItemStack(renderer, new ItemStack(item, 1, blockMeta.getMeta()), x, y, fontRenderer, overlay);
    }

    static {
        for (int i = 0; i <= 2; ++i) {
            ResourceLocation[] paths = new ResourceLocation[6];
            for (int j = 0; j < paths.length; ++j) {
                paths[j] = CaveUtils.getKey(String.format("textures/gui/panorama/%d/%d.png", i, j));
            }
            PANORAMA_PATHS.add((Object)new PanoramaPaths(paths[0], paths[1], paths[2], paths[3], paths[4], paths[5]));
        }
    }
}

