/*
 * Decompiled with CFR 0.152.
 */
package cavern.client.gui;

import cavern.client.gui.GuiListSlot;
import cavern.util.PanoramaPaths;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiDownloadTerrain;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.glu.Project;

@SideOnly(value=Side.CLIENT)
public class GuiDownloadCaveTerrain
extends GuiDownloadTerrain {
    private static int panoramaTimer;
    private final DynamicTexture viewportTexture;
    private final ResourceLocation panoramaBackground;
    private final long prevTime;
    public PanoramaPaths currentPanoramaPaths;

    public GuiDownloadCaveTerrain() {
        this.field_146297_k = FMLClientHandler.instance().getClient();
        this.viewportTexture = new DynamicTexture(256, 256);
        this.panoramaBackground = this.field_146297_k.func_110434_K().func_110578_a("background", this.viewportTexture);
        this.prevTime = Minecraft.func_71386_F();
    }

    @Nullable
    public PanoramaPaths getPanoramaPaths() {
        if (GuiListSlot.PANORAMA_PATHS.isEmpty()) {
            this.currentPanoramaPaths = null;
        } else if (this.currentPanoramaPaths == null) {
            this.currentPanoramaPaths = (PanoramaPaths)GuiListSlot.PANORAMA_PATHS.get(0);
        }
        return this.currentPanoramaPaths;
    }

    private void drawPanorama(float ticks) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        Project.gluPerspective((float)120.0f, (float)1.0f, (float)0.05f, (float)10.0f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179129_p();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int b0 = 8;
        for (int k = 0; k < b0 * b0; ++k) {
            PanoramaPaths paths;
            GlStateManager.func_179094_E();
            float f1 = ((float)(k % b0) / (float)b0 - 0.5f) / 64.0f;
            float f2 = ((float)(k / b0) / (float)b0 - 0.5f) / 64.0f;
            float f3 = 0.0f;
            GlStateManager.func_179109_b((float)f1, (float)f2, (float)f3);
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)(((float)panoramaTimer + ticks) / 400.0f)) * 15.0f + 10.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-((float)panoramaTimer + ticks) * 0.08f), (float)0.0f, (float)1.0f, (float)0.0f);
            for (int l = 0; l < 6 && (paths = this.getPanoramaPaths()) != null; ++l) {
                GlStateManager.func_179094_E();
                switch (l) {
                    case 1: {
                        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case 2: {
                        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case 3: {
                        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case 4: {
                        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case 5: {
                        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    }
                }
                this.field_146297_k.func_110434_K().func_110577_a(paths.getPath(l));
                buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                int i = 255 / (k + 1);
                buffer.func_181662_b(-1.0, -1.0, 1.0).func_187315_a(0.0, 0.0).func_181669_b(255, 255, 255, i).func_181675_d();
                buffer.func_181662_b(1.0, -1.0, 1.0).func_187315_a(1.0, 0.0).func_181669_b(255, 255, 255, i).func_181675_d();
                buffer.func_181662_b(1.0, 1.0, 1.0).func_187315_a(1.0, 1.0).func_181669_b(255, 255, 255, i).func_181675_d();
                buffer.func_181662_b(-1.0, 1.0, 1.0).func_187315_a(0.0, 1.0).func_181669_b(255, 255, 255, i).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        }
        buffer.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179089_o();
        GlStateManager.func_179126_j();
    }

    private void rotateAndBlurSkybox(float ticks) {
        this.field_146297_k.func_110434_K().func_110577_a(this.panoramaBackground);
        GlStateManager.func_187421_b((int)3553, (int)10241, (int)9729);
        GlStateManager.func_187421_b((int)3553, (int)10240, (int)9729);
        GlStateManager.func_187443_a((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)256, (int)256);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        GlStateManager.func_179118_c();
        int b0 = 3;
        for (int i = 0; i < b0; ++i) {
            float f = 1.0f / (float)(i + 1);
            int j = this.field_146294_l;
            int k = this.field_146295_m;
            float f1 = (float)(i - b0 / 2) / 256.0f;
            buffer.func_181662_b((double)j, (double)k, 0.0).func_187315_a((double)(0.0f + f1), 1.0).func_181666_a(1.0f, 1.0f, 1.0f, f).func_181675_d();
            buffer.func_181662_b((double)j, 0.0, 0.0).func_187315_a((double)(1.0f + f1), 1.0).func_181666_a(1.0f, 1.0f, 1.0f, f).func_181675_d();
            buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a((double)(1.0f + f1), 0.0).func_181666_a(1.0f, 1.0f, 1.0f, f).func_181675_d();
            buffer.func_181662_b(0.0, (double)k, 0.0).func_187315_a((double)(0.0f + f1), 0.0).func_181666_a(1.0f, 1.0f, 1.0f, f).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179141_d();
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    private void renderSkybox(float ticks) {
        this.field_146297_k.func_147110_a().func_147609_e();
        GlStateManager.func_179083_b((int)0, (int)0, (int)256, (int)256);
        this.drawPanorama(ticks);
        this.rotateAndBlurSkybox(ticks);
        this.rotateAndBlurSkybox(ticks);
        this.rotateAndBlurSkybox(ticks);
        this.rotateAndBlurSkybox(ticks);
        this.rotateAndBlurSkybox(ticks);
        this.rotateAndBlurSkybox(ticks);
        this.rotateAndBlurSkybox(ticks);
        this.field_146297_k.func_147110_a().func_147610_a(true);
        GlStateManager.func_179083_b((int)0, (int)0, (int)this.field_146297_k.field_71443_c, (int)this.field_146297_k.field_71440_d);
        float f1 = this.field_146294_l > this.field_146295_m ? 120.0f / (float)this.field_146294_l : 120.0f / (float)this.field_146295_m;
        float f2 = (float)this.field_146295_m * f1 / 256.0f;
        float f3 = (float)this.field_146294_l * f1 / 256.0f;
        int k = this.field_146294_l;
        int l = this.field_146295_m;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b(0.0, (double)l, 0.0).func_187315_a((double)(0.5f - f2), (double)(0.5f + f3)).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)k, (double)l, 0.0).func_187315_a((double)(0.5f - f2), (double)(0.5f - f3)).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b((double)k, 0.0, 0.0).func_187315_a((double)(0.5f + f2), (double)(0.5f - f3)).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a((double)(0.5f + f2), (double)(0.5f + f3)).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        long time = Minecraft.func_71386_F() - this.prevTime;
        if (this.getPanoramaPaths() != null) {
            if (time > 200L) {
                ++panoramaTimer;
            }
            GlStateManager.func_179118_c();
            this.renderSkybox(partialTicks);
            GlStateManager.func_179141_d();
        } else {
            this.func_146278_c(0);
        }
        if (time > 500L) {
            this.func_73732_a(this.field_146289_q, this.getInfoText(), this.field_146294_l / 2, this.field_146295_m / 2 + 40, 0xFFFFFF);
        }
        if (time > 2000L) {
            this.func_73732_a(this.field_146289_q, this.getSubText(), this.field_146294_l / 2, this.field_146295_m / 2 + 65, 0xCCCCCC);
        }
    }

    public String getInfoText() {
        return I18n.func_135052_a((String)"multiplayer.downloadingTerrain", (Object[])new Object[0]);
    }

    public String getSubText() {
        return I18n.func_135052_a((String)"cavern.terrain.wait", (Object[])new Object[0]);
    }
}

