/*
 * Decompiled with CFR 0.152.
 */
package cavern.client.gui;

import cavern.client.config.CaveConfigGui;
import cavern.client.gui.GuiListSlot;
import cavern.client.gui.GuiSelectBiome;
import cavern.client.gui.GuiSelectBlock;
import cavern.client.gui.ISelectorCallback;
import cavern.config.CavernConfig;
import cavern.config.Config;
import cavern.config.manager.CaveBiome;
import cavern.config.manager.CaveBiomeManager;
import cavern.util.BlockMeta;
import cavern.util.CaveFilters;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiBiomesEditor
extends GuiScreen {
    protected final GuiScreen parent;
    protected final CaveBiomeManager manager;
    protected BiomeList biomeList;
    protected GuiButton doneButton;
    protected GuiButton editButton;
    protected GuiButton cancelButton;
    protected GuiButton addButton;
    protected GuiButton removeButton;
    protected GuiButton clearButton;
    protected GuiCheckBox detailInfo;
    protected GuiCheckBox instantFilter;
    protected GuiTextField filterTextField;
    protected boolean editMode;
    protected GuiTextField weightField;
    protected GuiTextField terrainBlockField;
    protected GuiTextField terrainBlockMetaField;
    protected GuiTextField topBlockField;
    protected GuiTextField topBlockMetaField;
    protected HoverChecker detailHoverChecker;
    protected HoverChecker instantHoverChecker;
    protected HoverChecker weightHoverChecker;
    protected HoverChecker terrainBlockHoverChecker;
    protected HoverChecker topBlockHoverChecker;
    protected int maxLabelWidth;
    protected final List<String> editLabelList = Lists.newArrayList();
    protected final List<GuiTextField> editFieldList = Lists.newArrayList();

    public GuiBiomesEditor(GuiScreen parent, CaveBiomeManager manager) {
        this.parent = parent;
        this.manager = manager;
    }

    public void func_73866_w_() {
        if (this.biomeList == null) {
            this.biomeList = new BiomeList();
            this.refreshBiomes(this.manager.getCaveBiomes().values());
        }
        this.biomeList.func_148122_a(this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - (this.editMode ? 95 : 28));
        if (this.doneButton == null) {
            this.doneButton = new GuiButtonExt(0, 0, 0, 65, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        }
        this.doneButton.field_146128_h = this.field_146294_l / 2 + 135;
        this.doneButton.field_146129_i = this.field_146295_m - this.doneButton.field_146121_g - 4;
        if (this.editButton == null) {
            this.editButton = new GuiButtonExt(1, 0, 0, this.doneButton.field_146120_f, this.doneButton.field_146121_g, I18n.func_135052_a((String)"gui.edit", (Object[])new Object[0]));
            this.editButton.field_146124_l = false;
        }
        this.editButton.field_146128_h = this.doneButton.field_146128_h - this.doneButton.field_146120_f - 3;
        this.editButton.field_146129_i = this.doneButton.field_146129_i;
        this.editButton.field_146124_l = this.biomeList.selected != null;
        boolean bl = this.editButton.field_146125_m = !this.editMode;
        if (this.cancelButton == null) {
            this.cancelButton = new GuiButtonExt(2, 0, 0, this.editButton.field_146120_f, this.editButton.field_146121_g, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]));
        }
        this.cancelButton.field_146128_h = this.editButton.field_146128_h;
        this.cancelButton.field_146129_i = this.editButton.field_146129_i;
        this.cancelButton.field_146125_m = this.editMode;
        if (this.removeButton == null) {
            this.removeButton = new GuiButtonExt(4, 0, 0, this.doneButton.field_146120_f, this.doneButton.field_146121_g, I18n.func_135052_a((String)"gui.remove", (Object[])new Object[0]));
        }
        this.removeButton.field_146128_h = this.editButton.field_146128_h - this.editButton.field_146120_f - 3;
        this.removeButton.field_146129_i = this.doneButton.field_146129_i;
        boolean bl2 = this.removeButton.field_146125_m = !this.editMode;
        if (this.addButton == null) {
            this.addButton = new GuiButtonExt(3, 0, 0, this.doneButton.field_146120_f, this.doneButton.field_146121_g, I18n.func_135052_a((String)"gui.add", (Object[])new Object[0]));
        }
        this.addButton.field_146128_h = this.removeButton.field_146128_h - this.removeButton.field_146120_f - 3;
        this.addButton.field_146129_i = this.doneButton.field_146129_i;
        boolean bl3 = this.addButton.field_146125_m = !this.editMode;
        if (this.clearButton == null) {
            this.clearButton = new GuiButtonExt(5, 0, 0, this.removeButton.field_146120_f, this.removeButton.field_146121_g, I18n.func_135052_a((String)"gui.clear", (Object[])new Object[0]));
        }
        this.clearButton.field_146128_h = this.removeButton.field_146128_h;
        this.clearButton.field_146129_i = this.removeButton.field_146129_i;
        this.clearButton.field_146125_m = false;
        if (this.detailInfo == null) {
            this.detailInfo = new GuiCheckBox(6, 0, 5, I18n.func_135052_a((String)"cavern.config.detail", (Object[])new Object[0]), true);
        }
        this.detailInfo.setIsChecked(CaveConfigGui.detailInfo);
        this.detailInfo.field_146128_h = this.field_146294_l / 2 + 95;
        if (this.instantFilter == null) {
            this.instantFilter = new GuiCheckBox(7, 0, this.detailInfo.field_146129_i + this.detailInfo.field_146121_g + 2, I18n.func_135052_a((String)"cavern.config.instant", (Object[])new Object[0]), true);
        }
        this.instantFilter.setIsChecked(CaveConfigGui.instantFilter);
        this.instantFilter.field_146128_h = this.detailInfo.field_146128_h;
        this.field_146292_n.clear();
        this.field_146292_n.add(this.doneButton);
        if (this.editMode) {
            this.field_146292_n.add(this.cancelButton);
        } else {
            this.field_146292_n.add(this.editButton);
            this.field_146292_n.add(this.addButton);
            this.field_146292_n.add(this.removeButton);
            this.field_146292_n.add(this.clearButton);
        }
        this.field_146292_n.add(this.detailInfo);
        this.field_146292_n.add(this.instantFilter);
        if (this.filterTextField == null) {
            this.filterTextField = new GuiTextField(0, this.field_146289_q, 0, 0, 122, 16);
            this.filterTextField.func_146203_f(500);
        }
        this.filterTextField.field_146209_f = this.field_146294_l / 2 - 200;
        this.filterTextField.field_146210_g = this.field_146295_m - this.filterTextField.field_146219_i - 6;
        this.detailHoverChecker = new HoverChecker((GuiButton)this.detailInfo, 800);
        this.instantHoverChecker = new HoverChecker((GuiButton)this.instantFilter, 800);
        this.editLabelList.clear();
        this.editLabelList.add(I18n.func_135052_a((String)"cavern.config.biomes.weight", (Object[])new Object[0]));
        this.editLabelList.add(I18n.func_135052_a((String)"cavern.config.biomes.terrainBlock", (Object[])new Object[0]));
        this.editLabelList.add("");
        this.editLabelList.add(I18n.func_135052_a((String)"cavern.config.biomes.topBlock", (Object[])new Object[0]));
        this.editLabelList.add("");
        for (String key : this.editLabelList) {
            this.maxLabelWidth = Math.max(this.maxLabelWidth, this.field_146289_q.func_78256_a(key));
        }
        if (this.weightField == null) {
            this.weightField = new GuiTextField(1, this.field_146289_q, 0, 0, 0, 15);
            this.weightField.func_146203_f(3);
        }
        int i = this.maxLabelWidth + 8 + this.field_146294_l / 2;
        this.weightField.field_146209_f = this.field_146294_l / 2 - i / 2 + this.maxLabelWidth + 10;
        this.weightField.field_146210_g = this.biomeList.field_148154_c + 7;
        this.weightField.field_146218_h = this.field_146294_l / 2 + i / 2 - 45 - this.weightField.field_146209_f + 40;
        if (this.terrainBlockField == null) {
            this.terrainBlockField = new GuiTextField(2, this.field_146289_q, 0, 0, 0, this.weightField.field_146219_i);
            this.terrainBlockField.func_146203_f(100);
        }
        this.terrainBlockField.field_146209_f = this.weightField.field_146209_f;
        this.terrainBlockField.field_146210_g = this.weightField.field_146210_g + this.weightField.field_146219_i + 5;
        this.terrainBlockField.field_146218_h = this.weightField.field_146218_h / 4 + this.weightField.field_146218_h / 2 - 1;
        if (this.terrainBlockMetaField == null) {
            this.terrainBlockMetaField = new GuiTextField(3, this.field_146289_q, 0, 0, 0, this.terrainBlockField.field_146219_i);
            this.terrainBlockMetaField.func_146203_f(100);
        }
        this.terrainBlockMetaField.field_146209_f = this.terrainBlockField.field_146209_f + this.terrainBlockField.field_146218_h + 3;
        this.terrainBlockMetaField.field_146210_g = this.terrainBlockField.field_146210_g;
        this.terrainBlockMetaField.field_146218_h = this.weightField.field_146218_h / 4 - 1;
        if (this.topBlockField == null) {
            this.topBlockField = new GuiTextField(4, this.field_146289_q, 0, 0, 0, this.terrainBlockField.field_146219_i);
            this.topBlockField.func_146203_f(100);
        }
        this.topBlockField.field_146209_f = this.terrainBlockField.field_146209_f;
        this.topBlockField.field_146210_g = this.terrainBlockMetaField.field_146210_g + this.terrainBlockMetaField.field_146219_i + 5;
        this.topBlockField.field_146218_h = this.terrainBlockField.field_146218_h;
        if (this.topBlockMetaField == null) {
            this.topBlockMetaField = new GuiTextField(5, this.field_146289_q, 0, 0, 0, this.topBlockField.field_146219_i);
            this.topBlockMetaField.func_146203_f(100);
        }
        this.topBlockMetaField.field_146209_f = this.terrainBlockMetaField.field_146209_f;
        this.topBlockMetaField.field_146210_g = this.topBlockField.field_146210_g;
        this.topBlockMetaField.field_146218_h = this.terrainBlockMetaField.field_146218_h;
        this.editFieldList.clear();
        if (this.editMode) {
            this.editFieldList.add(this.weightField);
            this.editFieldList.add(this.terrainBlockField);
            this.editFieldList.add(this.terrainBlockMetaField);
            this.editFieldList.add(this.topBlockField);
            this.editFieldList.add(this.topBlockMetaField);
        }
        this.weightHoverChecker = new HoverChecker(this.weightField.field_146210_g - 1, this.weightField.field_146210_g + this.weightField.field_146219_i, this.weightField.field_146209_f - this.maxLabelWidth - 12, this.weightField.field_146209_f - 10, 800);
        this.terrainBlockHoverChecker = new HoverChecker(this.terrainBlockField.field_146210_g - 1, this.terrainBlockField.field_146210_g + this.terrainBlockField.field_146219_i, this.terrainBlockField.field_146209_f - this.maxLabelWidth - 12, this.terrainBlockField.field_146209_f - 10, 800);
        this.topBlockHoverChecker = new HoverChecker(this.topBlockField.field_146210_g - 1, this.topBlockField.field_146210_g + this.topBlockField.field_146219_i, this.topBlockField.field_146209_f - this.maxLabelWidth - 12, this.topBlockField.field_146209_f - 10, 800);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 0: {
                    if (this.editMode) {
                        for (CaveBiome caveBiome : this.biomeList.selected) {
                            int meta;
                            Block block;
                            if (!Strings.isNullOrEmpty((String)this.weightField.func_146179_b())) {
                                caveBiome.setWeight(NumberUtils.toInt((String)this.weightField.func_146179_b(), (int)caveBiome.getWeight()));
                            }
                            if (!Strings.isNullOrEmpty((String)this.terrainBlockField.func_146179_b()) && (block = Block.func_149684_b((String)this.terrainBlockField.func_146179_b())) != null && block != Blocks.field_150350_a) {
                                meta = BlockMeta.getMetaFromString(block, this.terrainBlockMetaField.func_146179_b());
                                if (meta < 0) {
                                    meta = 0;
                                }
                                caveBiome.setTerrainBlock(new BlockMeta(block, meta));
                            }
                            if (Strings.isNullOrEmpty((String)this.topBlockField.func_146179_b()) || (block = Block.func_149684_b((String)this.topBlockField.func_146179_b())) == null || block == Blocks.field_150350_a) continue;
                            meta = BlockMeta.getMetaFromString(block, this.topBlockMetaField.func_146179_b());
                            if (meta < 0) {
                                meta = 0;
                            }
                            caveBiome.setTopBlock(new BlockMeta(block, meta));
                        }
                        this.func_146284_a(this.cancelButton);
                        this.biomeList.scrollToTop();
                        this.biomeList.scrollToSelected();
                        break;
                    }
                    this.manager.getCaveBiomes().clear();
                    try {
                        FileUtils.forceDelete((File)new File(this.manager.config.toString()));
                        this.manager.config.load();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Collections.sort(this.biomeList.biomes);
                    CavernConfig.generateBiomesConfig(this.manager, this.biomeList.biomes);
                    Config.saveConfig(this.manager.config);
                    this.func_146284_a(this.cancelButton);
                    this.biomeList.selected.clear();
                    this.biomeList.scrollToTop();
                    break;
                }
                case 1: {
                    if (this.editMode) {
                        this.func_146284_a(this.cancelButton);
                        break;
                    }
                    if (this.biomeList.selected.isEmpty()) break;
                    this.editMode = true;
                    this.func_73866_w_();
                    this.biomeList.scrollToTop();
                    this.biomeList.scrollToSelected();
                    if (this.biomeList.selected.size() > 1) {
                        this.weightField.func_146180_a("");
                        this.terrainBlockField.func_146180_a("");
                        this.terrainBlockMetaField.func_146180_a("");
                        this.topBlockField.func_146180_a("");
                        this.topBlockMetaField.func_146180_a("");
                        break;
                    }
                    for (CaveBiome biome : this.biomeList.selected) {
                        if (biome == null) continue;
                        this.weightField.func_146180_a(Integer.toString(biome.getWeight()));
                        this.terrainBlockField.func_146180_a(biome.getTerrainBlock().getBlockName());
                        this.terrainBlockMetaField.func_146180_a(biome.getTerrainBlock().getMetaString());
                        this.topBlockField.func_146180_a(biome.getTopBlock().getBlockName());
                        this.topBlockMetaField.func_146180_a(biome.getTopBlock().getMetaString());
                    }
                    break;
                }
                case 2: {
                    if (this.editMode) {
                        this.editMode = false;
                        this.func_73866_w_();
                        break;
                    }
                    this.field_146297_k.func_147108_a(this.parent);
                    break;
                }
                case 3: {
                    final Set invisibleBiomes = this.biomeList.biomes.stream().map(CaveBiome::getBiome).collect(Collectors.toSet());
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiSelectBiome((GuiScreen)this, new ISelectorCallback<Biome>(){

                        @Override
                        public boolean isValidEntry(Biome entry) {
                            return entry != null && !invisibleBiomes.contains(entry);
                        }

                        @Override
                        public void onSelected(List<Biome> selected) {
                            if (GuiBiomesEditor.this.editMode) {
                                return;
                            }
                            GuiBiomesEditor.this.biomeList.selected.clear();
                            for (Biome biome : selected) {
                                CaveBiome caveBiome = new CaveBiome(biome, 10);
                                GuiBiomesEditor.this.biomeList.biomes.add((Object)caveBiome);
                                GuiBiomesEditor.this.biomeList.contents.add((Object)caveBiome);
                                GuiBiomesEditor.this.biomeList.selected.add(caveBiome);
                            }
                            GuiBiomesEditor.this.biomeList.scrollToTop();
                            GuiBiomesEditor.this.biomeList.scrollToSelected();
                        }
                    }));
                    break;
                }
                case 4: {
                    for (CaveBiome biome : this.biomeList.selected) {
                        this.biomeList.biomes.remove((Object)biome);
                        this.biomeList.contents.remove((Object)biome);
                    }
                    this.biomeList.selected.clear();
                    break;
                }
                case 5: {
                    this.biomeList.biomes.forEach(entry -> this.biomeList.selected.add((CaveBiome)entry));
                    this.func_146284_a(this.removeButton);
                    break;
                }
                case 6: {
                    CaveConfigGui.detailInfo = this.detailInfo.isChecked();
                    break;
                }
                case 7: {
                    CaveConfigGui.instantFilter = this.instantFilter.isChecked();
                    break;
                }
                default: {
                    this.biomeList.func_148147_a(button);
                }
            }
        }
    }

    public void func_73876_c() {
        if (this.editMode) {
            for (GuiTextField textField : this.editFieldList) {
                textField.func_146178_a();
            }
        } else {
            this.removeButton.field_146124_l = this.editButton.field_146124_l = !this.biomeList.selected.isEmpty();
            this.filterTextField.func_146178_a();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float ticks) {
        this.biomeList.func_148128_a(mouseX, mouseY, ticks);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"cavern.config.biomes", (Object[])new Object[0]), this.field_146294_l / 2, 15, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, ticks);
        if (this.editMode) {
            int size = this.editFieldList.size();
            for (int i = 0; i < size; ++i) {
                GuiTextField textField = this.editFieldList.get(i);
                textField.func_146194_f();
                this.func_73731_b(this.field_146289_q, this.editLabelList.get(i), textField.field_146209_f - this.maxLabelWidth - 10, textField.field_146210_g + 3, 0xBBBBBB);
            }
            if (this.weightHoverChecker.checkHover(mouseX, mouseY)) {
                ArrayList hover = Lists.newArrayList();
                String key = "cavern.config.biomes.weight";
                hover.add(TextFormatting.GRAY + I18n.func_135052_a((String)key, (Object[])new Object[0]));
                hover.addAll(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)(key + ".tooltip"), (Object[])new Object[0]), 300));
                this.func_146283_a(hover, mouseX, mouseY);
            } else if (this.terrainBlockHoverChecker.checkHover(mouseX, mouseY)) {
                ArrayList hover = Lists.newArrayList();
                String key = "cavern.config.biomes.terrainBlock";
                hover.add(TextFormatting.GRAY + I18n.func_135052_a((String)key, (Object[])new Object[0]));
                hover.addAll(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)(key + ".tooltip"), (Object[])new Object[0]), 300));
                this.func_146283_a(hover, mouseX, mouseY);
            } else if (this.topBlockHoverChecker.checkHover(mouseX, mouseY)) {
                ArrayList hover = Lists.newArrayList();
                String key = "cavern.config.biomes.topBlock";
                hover.add(TextFormatting.GRAY + I18n.func_135052_a((String)key, (Object[])new Object[0]));
                hover.addAll(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)(key + ".tooltip"), (Object[])new Object[0]), 300));
                this.func_146283_a(hover, mouseX, mouseY);
            }
        } else {
            this.filterTextField.func_146194_f();
        }
        if (this.detailHoverChecker.checkHover(mouseX, mouseY)) {
            this.func_146283_a(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)"cavern.config.detail.hover", (Object[])new Object[0]), 300), mouseX, mouseY);
        } else if (this.instantHoverChecker.checkHover(mouseX, mouseY)) {
            this.func_146283_a(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)"cavern.config.instant.hover", (Object[])new Object[0]), 300), mouseX, mouseY);
        } else if (this.biomeList.func_148141_e(mouseY) && GuiBiomesEditor.func_146271_m()) {
            CaveBiome caveBiome = (CaveBiome)this.biomeList.contents.get(this.biomeList.func_148124_c(mouseX, mouseY));
            ArrayList info = Lists.newArrayList();
            String prefix = TextFormatting.GRAY.toString();
            info.add(prefix + I18n.func_135052_a((String)"cavern.config.biomes.weight", (Object[])new Object[0]) + ": " + caveBiome.getWeight());
            info.add(prefix + I18n.func_135052_a((String)"cavern.config.biomes.terrainBlock", (Object[])new Object[0]) + ": " + caveBiome.getTerrainBlock().getName());
            info.add(prefix + I18n.func_135052_a((String)"cavern.config.biomes.topBlock", (Object[])new Object[0]) + ": " + caveBiome.getTopBlock().getName());
            this.func_146283_a(info, mouseX, mouseY);
        }
        if (this.biomeList.selected.size() > 1 && mouseX <= 100 && mouseY <= 20) {
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"cavern.config.select.entry.selected", (Object[])new Object[]{this.biomeList.selected.size()}), 5, 5, 0xEFEFEF);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.biomeList.func_178039_p();
        if (this.editMode && this.weightField.func_146206_l()) {
            int i = Mouse.getDWheel();
            if (i < 0) {
                this.weightField.func_146180_a(Integer.toString(Math.max(NumberUtils.toInt((String)this.weightField.func_146179_b()) - 1, 1)));
            } else if (i > 0) {
                this.weightField.func_146180_a(Integer.toString(Math.min(NumberUtils.toInt((String)this.weightField.func_146179_b()) + 1, 100)));
            }
        }
    }

    protected void func_73864_a(int x, int y, int code) throws IOException {
        super.func_73864_a(x, y, code);
        if (code == 1) {
            this.func_146284_a(this.editButton);
        } else if (this.editMode) {
            for (GuiTextField textField : this.editFieldList) {
                textField.func_146192_a(x, y, code);
            }
            if (!GuiBiomesEditor.func_146272_n()) {
                if (this.terrainBlockField.func_146206_l()) {
                    this.terrainBlockField.func_146195_b(false);
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiSelectBlock((GuiScreen)this, this.terrainBlockField, this.terrainBlockMetaField));
                } else if (this.topBlockField.func_146206_l()) {
                    this.topBlockField.func_146195_b(false);
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiSelectBlock((GuiScreen)this, this.topBlockField, this.topBlockMetaField));
                }
            }
        } else {
            this.filterTextField.func_146192_a(x, y, code);
        }
    }

    public void func_146282_l() throws IOException {
        super.func_146282_l();
        if (Keyboard.getEventKey() == 42 || Keyboard.getEventKey() == 54) {
            this.clearButton.field_146125_m = !this.editMode && Keyboard.getEventKeyState();
        }
    }

    protected void func_73869_a(char c, int code) throws IOException {
        if (this.editMode) {
            for (GuiTextField textField : this.editFieldList) {
                if (code == 1) {
                    textField.func_146195_b(false);
                    continue;
                }
                if (!textField.func_146206_l() || textField != this.terrainBlockField && textField != this.terrainBlockMetaField && textField != this.topBlockField && textField != this.topBlockMetaField && !CharUtils.isAsciiControl((char)c) && !CharUtils.isAsciiNumeric((char)c)) continue;
                textField.func_146201_a(c, code);
            }
        } else if (this.filterTextField.func_146206_l()) {
            boolean changed;
            if (code == 1) {
                this.filterTextField.func_146195_b(false);
            }
            String prev = this.filterTextField.func_146179_b();
            this.filterTextField.func_146201_a(c, code);
            String text = this.filterTextField.func_146179_b();
            boolean bl = changed = text != prev;
            if (Strings.isNullOrEmpty((String)text) && changed) {
                this.biomeList.setFilter(null);
            } else if (this.instantFilter.isChecked() && changed || code == 28) {
                this.biomeList.setFilter(text);
            }
        } else if (code == 1) {
            this.func_146284_a(this.doneButton);
        } else if (code == 14) {
            this.biomeList.selected.clear();
        } else if (code == 15) {
            if (++this.biomeList.nameType > 1) {
                this.biomeList.nameType = 0;
            }
        } else if (code == 200) {
            this.biomeList.scrollUp();
        } else if (code == 208) {
            this.biomeList.scrollDown();
        } else if (code == 199) {
            this.biomeList.scrollToTop();
        } else if (code == 207) {
            this.biomeList.scrollToEnd();
        } else if (code == 57) {
            this.biomeList.scrollToSelected();
        } else if (code == 201) {
            this.biomeList.scrollToPrev();
        } else if (code == 209) {
            this.biomeList.scrollToNext();
        } else if (code == 33 || code == this.field_146297_k.field_71474_y.field_74310_D.func_151463_i()) {
            this.filterTextField.func_146195_b(true);
        } else if (GuiBiomesEditor.func_146271_m() && code == 30) {
            this.biomeList.contents.forEach(entry -> this.biomeList.selected.add((CaveBiome)entry));
        } else if (code == 211 && !this.biomeList.selected.isEmpty()) {
            this.func_146284_a(this.removeButton);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        this.biomeList.currentPanoramaPaths = null;
    }

    public void refreshBiomes(Collection<CaveBiome> biomes) {
        this.biomeList.biomes.clear();
        this.biomeList.contents.clear();
        biomes.stream().sorted().forEach(biome -> {
            this.biomeList.biomes.add(biome);
            this.biomeList.contents.add(biome);
        });
    }

    protected class BiomeList
    extends GuiListSlot {
        protected final NonNullList<CaveBiome> biomes;
        protected final NonNullList<CaveBiome> contents;
        protected final Set<CaveBiome> selected;
        protected final Map<String, List<CaveBiome>> filterCache;
        protected int nameType;
        protected boolean clickFlag;

        protected BiomeList() {
            super(GuiBiomesEditor.this.field_146297_k, 0, 0, 0, 0, 22);
            this.biomes = NonNullList.func_191196_a();
            this.contents = NonNullList.func_191196_a();
            this.selected = Sets.newTreeSet();
            this.filterCache = Maps.newHashMap();
        }

        @Override
        public void scrollToSelected() {
            if (!this.selected.isEmpty()) {
                int amount = 0;
                for (CaveBiome biome : this.selected) {
                    amount = this.contents.indexOf((Object)biome) * this.func_148146_j();
                    if (this.func_148148_g() == amount) continue;
                    break;
                }
                this.scrollToTop();
                this.func_148145_f(amount);
            }
        }

        protected int func_148127_b() {
            return this.contents.size();
        }

        protected void func_148123_a() {
            GuiBiomesEditor.this.func_146276_q_();
        }

        protected void func_192637_a(int slot, int par2, int par3, int par4, int mouseX, int mouseY, float partialTicks) {
            String text;
            CaveBiome caveBiome = (CaveBiome)this.contents.get(slot);
            Biome biome = caveBiome.getBiome();
            switch (this.nameType) {
                case 1: {
                    text = biome.getRegistryName().toString();
                    break;
                }
                default: {
                    text = biome.func_185359_l();
                }
            }
            if (!Strings.isNullOrEmpty((String)text)) {
                GuiBiomesEditor.this.func_73732_a(GuiBiomesEditor.this.field_146289_q, text, this.field_148155_a / 2, par3 + 3, 0xFFFFFF);
            }
            if (GuiBiomesEditor.this.detailInfo.isChecked() || Keyboard.isKeyDown((int)15)) {
                this.drawItemStack(GuiBiomesEditor.this.field_146296_j, caveBiome.getTerrainBlock(), this.field_148155_a / 2 - 100, par3 + 1, GuiBiomesEditor.this.field_146289_q, Integer.toString(Biome.func_185362_a((Biome)biome)));
                this.drawItemStack(GuiBiomesEditor.this.field_146296_j, caveBiome.getTopBlock(), this.field_148155_a / 2 + 90, par3 + 1, GuiBiomesEditor.this.field_146289_q, Integer.toString(caveBiome.getWeight()));
            }
        }

        protected void func_148144_a(int slot, boolean flag, int mouseX, int mouseY) {
            if (GuiBiomesEditor.this.editMode) {
                return;
            }
            CaveBiome biome = (CaveBiome)this.contents.get(slot);
            this.clickFlag = !this.clickFlag;
            if (this.clickFlag && !this.selected.remove(biome)) {
                if (!GuiScreen.func_146271_m()) {
                    this.selected.clear();
                }
                this.selected.add(biome);
            }
        }

        protected boolean func_148131_a(int slot) {
            return this.selected.contains(this.contents.get(slot));
        }

        protected void setFilter(String filter) {
            Object result;
            if (Strings.isNullOrEmpty((String)filter)) {
                result = this.biomes;
            } else if (filter.equals("selected")) {
                result = Lists.newArrayList(this.selected);
            } else {
                if (!this.filterCache.containsKey(filter)) {
                    this.filterCache.put(filter, this.biomes.parallelStream().filter(e -> this.filterMatch((CaveBiome)e, filter)).collect(Collectors.toList()));
                }
                result = this.filterCache.get(filter);
            }
            if (!this.contents.equals(result)) {
                this.contents.clear();
                this.contents.addAll(result);
            }
        }

        protected boolean filterMatch(CaveBiome entry, String filter) {
            return CaveFilters.biomeFilter(entry.getBiome(), filter) || entry.getWeight() == NumberUtils.toInt((String)filter, (int)-1) || CaveFilters.blockFilter(entry.getTerrainBlock(), filter) || CaveFilters.blockFilter(entry.getTopBlock(), filter);
        }
    }
}

