/*
 * Decompiled with CFR 0.152.
 */
package cavern.client.config;

import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.math.NumberUtils;

@SideOnly(value=Side.CLIENT)
public class CycleIntegerEntry
extends GuiConfigEntries.ButtonEntry {
    protected final int beforeValue;
    protected final int defaultValue;
    protected int currentValue;

    public CycleIntegerEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
        super(owningScreen, owningEntryList, configElement);
        this.beforeValue = NumberUtils.toInt((String)configElement.get().toString());
        this.defaultValue = NumberUtils.toInt((String)configElement.getDefault().toString());
        this.currentValue = this.beforeValue;
        this.btnValue.field_146124_l = this.enabled();
        this.updateValueButtonText();
    }

    public void updateValueButtonText() {
        this.btnValue.field_146126_j = I18n.func_135052_a((String)(this.configElement.getLanguageKey() + "." + this.currentValue), (Object[])new Object[0]);
        if (this.btnValue.field_146126_j.equalsIgnoreCase(I18n.func_135052_a((String)"gui.disabled", (Object[])new Object[0]))) {
            this.btnValue.field_146126_j = TextFormatting.DARK_RED + this.btnValue.field_146126_j;
        }
    }

    public void valueButtonPressed(int slotIndex) {
        if (this.enabled()) {
            if (++this.currentValue > NumberUtils.toInt((String)this.configElement.getMaxValue().toString())) {
                this.currentValue = 0;
            }
            this.updateValueButtonText();
        }
    }

    public boolean isDefault() {
        return this.currentValue == this.defaultValue;
    }

    public void setToDefault() {
        if (this.enabled()) {
            this.currentValue = this.defaultValue;
            this.updateValueButtonText();
        }
    }

    public boolean isChanged() {
        return this.currentValue != this.beforeValue;
    }

    public void undoChanges() {
        if (this.enabled()) {
            this.currentValue = this.beforeValue;
            this.updateValueButtonText();
        }
    }

    public boolean saveConfigElement() {
        if (this.enabled() && this.isChanged()) {
            this.configElement.set((Object)this.currentValue);
            return this.configElement.requiresMcRestart();
        }
        return false;
    }

    public Integer getCurrentValue() {
        return this.currentValue;
    }

    public Integer[] getCurrentValues() {
        return new Integer[]{this.getCurrentValue()};
    }
}

