/*
 * Decompiled with CFR 0.152.
 */
package cavern.client;

import cavern.handler.CaveEventHooks;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientExplosion {
    private final Random random = CaveEventHooks.RANDOM;
    private final Minecraft mc;
    private final double x;
    private final double y;
    private final double z;
    private final float size;
    private final List<BlockPos> affectedBlockPositions;

    public ClientExplosion(Minecraft mc, double x, double y, double z, float size, List<BlockPos> positions) {
        this.mc = mc;
        this.x = x;
        this.y = y;
        this.z = z;
        this.size = size;
        this.affectedBlockPositions = positions;
    }

    public void doExplosion() {
        this.spawnParticle(this.size >= 2.0f ? EnumParticleTypes.EXPLOSION_HUGE : EnumParticleTypes.EXPLOSION_LARGE, this.x, this.y, this.z, 1.0, 0.0, 0.0);
        if (this.affectedBlockPositions != null) {
            for (BlockPos pos : this.affectedBlockPositions) {
                double ex = (float)pos.func_177958_n() + this.random.nextFloat();
                double ey = (float)pos.func_177956_o() + this.random.nextFloat();
                double ez = (float)pos.func_177952_p() + this.random.nextFloat();
                double rx = ex - this.x;
                double ry = ey - this.y;
                double rz = ez - this.z;
                double rd = MathHelper.func_76133_a((double)(rx * rx + ry * ry + rz * rz));
                rx /= rd;
                ry /= rd;
                rz /= rd;
                double d7 = 0.5 / (rd / (double)this.size + 0.1);
                this.spawnParticle(EnumParticleTypes.EXPLOSION_NORMAL, (ex + this.x) / 2.0, (ey + this.y) / 2.0, (ez + this.z) / 2.0, rx *= (d7 *= (double)(this.random.nextFloat() * this.random.nextFloat() + 0.3f)), ry *= d7, rz *= d7);
                this.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, ex, ey, ez, rx, ry, rz);
            }
        }
    }

    protected void spawnParticle(EnumParticleTypes type, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        this.mc.field_71452_i.func_178927_a(type.func_179348_c(), x, y, z, xSpeed, ySpeed, zSpeed, new int[0]);
    }
}

