/*
 * Decompiled with CFR 0.152.
 */
package cavern.capability;

import cavern.api.data.IMiner;
import cavern.api.data.IMiningData;
import cavern.capability.CapabilityCavePortalList;
import cavern.capability.CapabilityMagicBook;
import cavern.capability.CapabilityMagicStorage;
import cavern.capability.CapabilityMiner;
import cavern.capability.CapabilityMiningAssistUnit;
import cavern.capability.CapabilityMiningData;
import cavern.capability.CapabilityOreCompass;
import cavern.capability.CapabilityPlayerData;
import cavern.capability.CapabilityPortalCache;
import cavern.data.PlayerData;
import cavern.data.PortalCache;
import cavern.inventory.InventoryMagicStorage;
import cavern.item.ItemMagicBook;
import cavern.item.OreCompass;
import cavern.magic.MagicBook;
import cavern.miningassist.MiningAssistUnit;
import cavern.util.CaveUtils;
import cavern.world.CavePortalList;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class CaveCapabilities {
    @CapabilityInject(value=PortalCache.class)
    public static final Capability<PortalCache> PORTAL_CACHE = null;
    @CapabilityInject(value=PlayerData.class)
    public static final Capability<PlayerData> PLAYER_DATA = null;
    @CapabilityInject(value=IMiner.class)
    public static final Capability<IMiner> MINER = null;
    @CapabilityInject(value=IMiningData.class)
    public static final Capability<IMiningData> MINING_DATA = null;
    @CapabilityInject(value=MiningAssistUnit.class)
    public static final Capability<MiningAssistUnit> MINING_ASSIST = null;
    @CapabilityInject(value=OreCompass.class)
    public static final Capability<OreCompass> ORE_COMPASS = null;
    @CapabilityInject(value=MagicBook.class)
    public static final Capability<MagicBook> MAGIC_BOOK = null;
    @CapabilityInject(value=InventoryMagicStorage.class)
    public static final Capability<InventoryMagicStorage> MAGIC_STORAGE = null;
    @CapabilityInject(value=CavePortalList.class)
    public static final Capability<CavePortalList> CAVE_PORTAL_LIST = null;

    public static void registerCapabilities() {
        CapabilityPortalCache.register();
        CapabilityPlayerData.register();
        CapabilityMiner.register();
        CapabilityMiningData.register();
        CapabilityMiningAssistUnit.register();
        CapabilityOreCompass.register();
        CapabilityMagicBook.register();
        CapabilityMagicStorage.register();
        CapabilityCavePortalList.register();
        MinecraftForge.EVENT_BUS.register((Object)new CaveCapabilities());
    }

    public static <T> boolean hasCapability(@Nullable ICapabilityProvider entry, @Nullable Capability<T> capability) {
        return entry != null && capability != null && entry.hasCapability(capability, null);
    }

    @Nullable
    public static <T> T getCapability(@Nullable ICapabilityProvider entry, @Nullable Capability<T> capability) {
        return (T)(CaveCapabilities.hasCapability(entry, capability) ? entry.getCapability(capability, null) : null);
    }

    @SubscribeEvent
    public void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        event.addCapability(CaveUtils.getKey("portal_cache"), (ICapabilityProvider)new CapabilityPortalCache());
        if (event.getObject() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getObject();
            event.addCapability(CaveUtils.getKey("player_data"), (ICapabilityProvider)new CapabilityPlayerData());
            event.addCapability(CaveUtils.getKey("miner_stats"), (ICapabilityProvider)new CapabilityMiner(player));
            event.addCapability(CaveUtils.getKey("mining_data"), (ICapabilityProvider)new CapabilityMiningData(player));
            event.addCapability(CaveUtils.getKey("mining_assist"), (ICapabilityProvider)new CapabilityMiningAssistUnit(player));
            event.addCapability(CaveUtils.getKey("magic_book"), (ICapabilityProvider)new CapabilityMagicBook());
        }
    }

    @SubscribeEvent
    public void onAttachItemStackCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemMagicBook && ItemMagicBook.EnumType.byItemStack(stack) == ItemMagicBook.EnumType.STORAGE) {
            event.addCapability(stack.func_77973_b().getRegistryName(), (ICapabilityProvider)new CapabilityMagicStorage());
        }
    }

    @SubscribeEvent
    public void onAttachWorldCapabilities(AttachCapabilitiesEvent<World> event) {
        event.addCapability(CaveUtils.getKey("cave_portal_list"), (ICapabilityProvider)new CapabilityCavePortalList());
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer original = event.getOriginal();
        PortalCache originalPortalCache = CaveCapabilities.getCapability((ICapabilityProvider)original, PORTAL_CACHE);
        PortalCache portalCache = CaveCapabilities.getCapability((ICapabilityProvider)player, PORTAL_CACHE);
        if (originalPortalCache != null && portalCache != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            originalPortalCache.writeToNBT(nbt);
            portalCache.readFromNBT(nbt);
        }
        PlayerData originalPlayerData = CaveCapabilities.getCapability((ICapabilityProvider)original, PLAYER_DATA);
        PlayerData playerData = CaveCapabilities.getCapability((ICapabilityProvider)player, PLAYER_DATA);
        if (originalPlayerData != null && playerData != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            originalPlayerData.writeToNBT(nbt);
            playerData.readFromNBT(nbt);
        }
        IMiner originalMiner = CaveCapabilities.getCapability((ICapabilityProvider)original, MINER);
        IMiner miner = CaveCapabilities.getCapability((ICapabilityProvider)player, MINER);
        if (originalMiner != null && miner != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            originalMiner.writeToNBT(nbt);
            miner.readFromNBT(nbt);
        }
    }
}

