/*
 * Decompiled with CFR 0.152.
 */
package cavern.capability;

import cavern.api.data.IMiner;
import cavern.capability.CaveCapabilities;
import cavern.data.Miner;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class CapabilityMiner
implements ICapabilitySerializable<NBTTagCompound> {
    private final IMiner miner;

    public CapabilityMiner(EntityPlayer player) {
        this.miner = new Miner(player);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return CaveCapabilities.MINER != null && capability == CaveCapabilities.MINER;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (CaveCapabilities.MINER != null && capability == CaveCapabilities.MINER) {
            return (T)CaveCapabilities.MINER.cast((Object)this.miner);
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        if (CaveCapabilities.MINER != null) {
            return (NBTTagCompound)CaveCapabilities.MINER.getStorage().writeNBT(CaveCapabilities.MINER, (Object)this.miner, null);
        }
        return new NBTTagCompound();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (CaveCapabilities.MINER != null) {
            CaveCapabilities.MINER.getStorage().readNBT(CaveCapabilities.MINER, (Object)this.miner, null, (NBTBase)nbt);
        }
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IMiner.class, (Capability.IStorage)new Capability.IStorage<IMiner>(){

            public NBTBase writeNBT(Capability<IMiner> capability, IMiner instance, EnumFacing side) {
                NBTTagCompound nbt = new NBTTagCompound();
                instance.writeToNBT(nbt);
                return nbt;
            }

            public void readNBT(Capability<IMiner> capability, IMiner instance, EnumFacing side, NBTBase nbt) {
                instance.readFromNBT((NBTTagCompound)nbt);
            }
        }, Miner::new);
    }
}

