/*
 * Decompiled with CFR 0.152.
 */
package cavern.block;

import cavern.handler.CaveEventHooks;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class FissureHelper {
    private static final Random RANDOM = CaveEventHooks.RANDOM;

    public static void fireAreaEffect(World world, BlockPos pos, @Nullable EntityLivingBase entity) {
        EntityAreaEffectCloud areaEffectCloud = new EntityAreaEffectCloud(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        areaEffectCloud.func_184481_a(entity);
        areaEffectCloud.func_184483_a(2.5f);
        areaEffectCloud.func_184495_b(-0.5f);
        areaEffectCloud.func_184485_d(10);
        areaEffectCloud.func_184486_b(600);
        areaEffectCloud.func_184496_a(new PotionEffect(FissureHelper.getRandomPotion(RANDOM.nextDouble() < 0.35), 600, RANDOM.nextInt(2)));
        world.func_72838_d((Entity)areaEffectCloud);
    }

    public static void fireExplosion(World world, BlockPos pos) {
        double posX = (double)pos.func_177958_n() + 0.5;
        double posY = (double)pos.func_177956_o() + 0.5;
        double posZ = (double)pos.func_177952_p() + 0.5;
        float strength = 1.45f;
        if (RANDOM.nextDouble() < 0.15) {
            strength = 3.0f;
        }
        world.func_72885_a(null, posX, posY, posZ, strength, false, true);
    }

    public static void fireIntensiveEffect(EntityLivingBase entity, int fortune) {
        for (int i = 0; i < Math.min(fortune, 5); ++i) {
            entity.func_70690_d(new PotionEffect(FissureHelper.getRandomPotion(false), 1200, RANDOM.nextInt(2)));
        }
    }

    private static Potion getRandomPotion(boolean badEffect) {
        if (badEffect) {
            if (RANDOM.nextDouble() < 0.15) {
                return MobEffects.field_76437_t;
            }
            if (RANDOM.nextDouble() < 0.3) {
                return MobEffects.field_76436_u;
            }
            if (RANDOM.nextDouble() < 0.3) {
                return MobEffects.field_76421_d;
            }
            return MobEffects.field_76438_s;
        }
        if (RANDOM.nextDouble() < 0.15) {
            return MobEffects.field_76439_r;
        }
        if (RANDOM.nextDouble() < 0.3) {
            return MobEffects.field_76428_l;
        }
        if (RANDOM.nextDouble() < 0.3) {
            return MobEffects.field_76444_x;
        }
        return MobEffects.field_76429_m;
    }
}

