/*
 * Decompiled with CFR 0.152.
 */
package cavern.block;

import cavern.block.BlockPortalCavern;
import cavern.client.gui.GuiRegeneration;
import cavern.data.PlayerData;
import cavern.item.CaveItems;
import cavern.item.ItemMirageBook;
import cavern.network.CaveNetworkRegistry;
import cavern.network.client.MirageSelectMessage;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPortalMirageWorlds
extends BlockPortalCavern {
    public BlockPortalMirageWorlds() {
        this.func_149663_c("portal.mirageWorlds");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void openRegeneration(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side) {
        GuiRegeneration regeneration = new GuiRegeneration();
        DimensionType type = this.getDimension(player.func_184586_b(hand));
        if (type != null) {
            regeneration.dimensions.add(type);
        }
        FMLClientHandler.instance().showGuiScreen((Object)regeneration);
    }

    @Override
    public boolean isTriggerItem(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemMirageBook;
    }

    @Override
    public DimensionType getDimension() {
        return null;
    }

    @Nullable
    public DimensionType getDimension(ItemStack stack) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemMirageBook)) {
            return null;
        }
        return ItemMirageBook.EnumType.byItemStack(stack).getDimension();
    }

    @Override
    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (world.field_72995_K || entity.field_70128_L || entity.func_184218_aH() || entity.func_184207_aI() || !(entity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)entity;
        if (player.field_71088_bW <= 0) {
            DimensionType type;
            player.field_71088_bW = player.func_82147_ab();
            HashSet types = Sets.newHashSet();
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                type = this.getDimension(stack);
                if (type == null) continue;
                types.add(type);
            }
            for (ItemStack stack : player.func_184214_aD()) {
                type = this.getDimension(stack);
                if (type == null) continue;
                types.add(type);
            }
            if (types.isEmpty()) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("cavern.message.portal.mirage", new Object[0]), true);
                return;
            }
            MirageSelectMessage message = new MirageSelectMessage();
            Iterator<Object> iterator = types.iterator();
            while (iterator.hasNext()) {
                type = (DimensionType)iterator.next();
                if (player.field_71075_bZ.field_75098_d) {
                    message.dimensions.add(type);
                    continue;
                }
                long teleportTime = PlayerData.get((EntityPlayer)player).getLastTeleportTime(type);
                if (teleportTime > 0L && teleportTime + 6000L >= world.func_82737_E()) continue;
                message.dimensions.add(type);
            }
            if (message.dimensions.isEmpty()) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("cavern.message.portal.wait", new Object[0]), true);
                return;
            }
            if (message.dimensions.size() == 1 && (iterator = message.dimensions.iterator()).hasNext()) {
                type = (DimensionType)iterator.next();
                CaveItems.MIRAGE_BOOK.transferTo(type, (EntityPlayer)player);
                return;
            }
            CaveNetworkRegistry.sendTo(() -> message, (EntityPlayer)player);
        } else {
            player.field_71088_bW = player.func_82147_ab();
        }
    }
}

