/*
 * Decompiled with CFR 0.152.
 */
package cavern.block;

import cavern.core.Cavern;
import cavern.util.CaveLog;
import cavern.util.CaveUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import org.apache.logging.log4j.Level;

public class BlockCavenicBush
extends BlockBush {
    protected static final AxisAlignedBB MUSHROOM_AABB = new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, (double)0.4f, (double)0.7f);
    private static final Map<ResourceLocation, ResourceLocation> TRANSFORM_MAP = new HashMap<ResourceLocation, ResourceLocation>();

    public static void registerTransformation(ResourceLocation from, ResourceLocation to) {
        TRANSFORM_MAP.put(from, to);
    }

    public BlockCavenicBush() {
        this.func_149663_c("cavenicShroom");
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(Cavern.TAB_CAVERN);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return MUSHROOM_AABB;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (rand.nextInt(25) == 0) {
            int count = 5;
            for (BlockPos blockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-4, -1, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
                if (!(world.func_180495_p(blockpos).func_177230_c() instanceof BlockCavenicBush) || --count > 0) continue;
                return;
            }
            BlockPos blockpos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
            for (int k = 0; k < 4; ++k) {
                if (world.func_175623_d(blockpos) && this.func_180671_f(world, blockpos, this.func_176223_P())) {
                    pos = blockpos;
                }
                blockpos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
            }
            if (world.func_175623_d(blockpos) && this.func_180671_f(world, blockpos, this.func_176223_P())) {
                world.func_180501_a(blockpos, this.func_176223_P(), 2);
            }
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        super.func_180634_a(world, pos, state, entity);
        if (!world.field_72995_K && entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            living.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 40));
            if (world.field_73012_v.nextFloat() < 0.005f && !entity.field_70128_L) {
                ResourceLocation key = TRANSFORM_MAP.get(EntityList.func_191301_a((Entity)entity));
                if (key == null) {
                    return;
                }
                Entity newEntity = EntityList.func_188429_b((ResourceLocation)key, (World)world);
                if (newEntity == null) {
                    return;
                }
                newEntity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                if (newEntity instanceof EntityMob) {
                    ((EntityMob)newEntity).func_180482_a(world.func_175649_E(new BlockPos(entity)), null);
                }
                try {
                    UUID uuid = newEntity.func_110124_au();
                    newEntity.func_70020_e(entity.func_189511_e(newEntity.func_189511_e(new NBTTagCompound())));
                    newEntity.func_184221_a(uuid);
                }
                catch (Exception e) {
                    CaveLog.log(Level.WARN, e, "Couldn't transform entity NBT data: {%s}", key.toString());
                }
                world.func_72838_d(newEntity);
                entity.func_70106_y();
                entity.func_184185_a(SoundEvents.field_187942_hp, 1.0f + world.field_73012_v.nextFloat(), world.field_73012_v.nextFloat() * 0.7f + 0.3f);
            }
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && this.func_180671_f(world, pos, this.func_176223_P());
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_185913_b();
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            IBlockState blockstate = world.func_180495_p(pos.func_177977_b());
            if (blockstate.func_177230_c() == Blocks.field_150391_bh) {
                return true;
            }
            if (blockstate.func_177230_c() == Blocks.field_150346_d && blockstate.func_177229_b((IProperty)BlockDirt.field_176386_a) == BlockDirt.DirtType.PODZOL) {
                return true;
            }
            if (blockstate.func_177230_c() == Blocks.field_150348_b) {
                return true;
            }
            return world.func_175699_k(pos) < 13 && blockstate.func_177230_c().canSustainPlant(blockstate, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        }
        return false;
    }

    static {
        BlockCavenicBush.registerTransformation(new ResourceLocation("minecraft", "zombie"), CaveUtils.getKey("cavenic_zombie"));
        BlockCavenicBush.registerTransformation(new ResourceLocation("minecraft", "skeleton"), CaveUtils.getKey("cavenic_skeleton"));
        BlockCavenicBush.registerTransformation(new ResourceLocation("minecraft", "spider"), CaveUtils.getKey("cavenic_spider"));
        BlockCavenicBush.registerTransformation(new ResourceLocation("minecraft", "creeper"), CaveUtils.getKey("cavenic_creeper"));
        BlockCavenicBush.registerTransformation(new ResourceLocation("minecraft", "witch"), CaveUtils.getKey("cavenic_witch"));
        BlockCavenicBush.registerTransformation(new ResourceLocation("minecraft", "polar_bear"), CaveUtils.getKey("cavenic_bear"));
        BlockCavenicBush.registerTransformation(new ResourceLocation("tofucraft", "tofunian"), CaveUtils.getKey("caveman"));
    }
}

