/*
 * Decompiled with CFR 0.152.
 */
package cavern.api.item;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public interface IIceEquipment {
    public static ItemStack getChargedItem(Item item, int amount) {
        ItemStack stack = new ItemStack(item);
        if (item instanceof IIceEquipment) {
            return ((IIceEquipment)item).setCharge(stack, amount);
        }
        return stack;
    }

    default public int getCharge(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("IceCharge", 99)) {
            return 0;
        }
        return nbt.func_74762_e("IceCharge");
    }

    default public ItemStack setCharge(ItemStack stack, int amount) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74768_a("IceCharge", amount);
        stack.func_77982_d(nbt);
        return stack;
    }

    default public ItemStack addCharge(ItemStack stack, int amount) {
        return this.setCharge(stack, Math.max(this.getCharge(stack) + amount, 0));
    }

    default public boolean isHiddenTooltip() {
        return false;
    }
}

