/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.ranks;

import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.util.ServerUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbutilities.ranks.Rank;
import com.feed_the_beast.ftbutilities.ranks.Ranks;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class PlayerRank
extends Rank {
    public final UUID uuid;
    public final GameProfile profile;
    private final Map<String, String> stringCache;
    private final Map<String, ConfigValue> valueCache;

    PlayerRank(Ranks r, UUID id, String name) {
        super(r, StringUtils.fromUUID((UUID)id));
        this.displayName = new TextComponentString(name.isEmpty() ? this.getId() : name);
        this.displayName.func_150256_b().func_150238_a(TextFormatting.YELLOW);
        this.uuid = id;
        this.comment = name;
        this.profile = new GameProfile(id, name.isEmpty() ? null : name);
        this.stringCache = new HashMap<String, String>();
        this.valueCache = new HashMap<String, ConfigValue>();
    }

    @Override
    public int getPower() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isPlayer() {
        return true;
    }

    @Override
    public boolean add() {
        return this.ranks.playerRanks.put(this.uuid, this) != this;
    }

    @Override
    public boolean remove() {
        if (!this.permissions.isEmpty() || !this.getParents().isEmpty()) {
            this.permissions.clear();
            this.clearParents();
            return true;
        }
        return false;
    }

    @Override
    public boolean isDefaultPlayerRank() {
        return false;
    }

    @Override
    public boolean isDefaultOPRank() {
        return false;
    }

    @Override
    public Set<Rank> getActualParents() {
        Rank r;
        ArrayList<Rank> list = new ArrayList<Rank>();
        for (String s : this.getLocalPermission("parent").split(",")) {
            Rank r2 = this.ranks.getRank(s.trim());
            if (r2 == null || r2.isPlayer()) continue;
            list.add(r2);
        }
        if (ServerUtils.isOP((MinecraftServer)this.ranks.universe.server, (GameProfile)this.profile) && (r = this.ranks.getDefaultOPRank()) != null) {
            list.add(r);
        }
        if ((r = this.ranks.getDefaultPlayerRank()) != null) {
            list.add(r);
        }
        list.sort(null);
        return new LinkedHashSet<Rank>(list);
    }

    @Override
    public String getPermission(String originalNode, String node, boolean recursive) {
        String s = this.stringCache.get(node);
        if (s != null) {
            return s;
        }
        s = super.getPermission(originalNode, node, recursive);
        this.stringCache.put(node, s);
        return s;
    }

    @Override
    public ConfigValue getPermissionValue(String originalNode, String node, boolean recursive) {
        ConfigValue v = this.valueCache.get(node);
        if (v == null) {
            v = super.getPermissionValue(originalNode, node, recursive);
            this.valueCache.put(node, v);
        }
        return v;
    }

    @Override
    public void clearCache() {
        super.clearCache();
        this.stringCache.clear();
        this.valueCache.clear();
    }
}

