/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements;

import com.brandon3055.brandonscore.client.gui.modulargui_old.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui_old.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui_old.lib.EnumAlignment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;

public class MGuiLabel
extends MGuiElementBase {
    public String displayString = "";
    public EnumAlignment alignment = EnumAlignment.CENTER;
    public boolean dropShadow = true;
    public int textColour = 0xFFFFFF;
    private int rotation = 0;
    public boolean wrap = false;
    public boolean trim = false;

    public MGuiLabel(IModularGui modularGui) {
        super(modularGui);
    }

    public MGuiLabel(IModularGui gui, int xPos, int yPos, int xSize, int ySize, String displayString) {
        super(gui, xPos, yPos, xSize, ySize);
        this.displayString = displayString;
    }

    @Override
    public void renderBackgroundLayer(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        super.renderBackgroundLayer(mc, mouseX, mouseY, partialTicks);
        FontRenderer fontrenderer = mc.field_71466_p;
        int colour = this.getTextColour();
        int fh = mc.field_71466_p.field_78288_b;
        String text = this.getDisplayString();
        if (this.rotation == 0) {
            int buffer = 5;
            if (this.trim && fontrenderer.func_78256_a(text) > this.xSize - 4) {
                text = fontrenderer.func_78269_a(text, this.xSize - 8) + "...";
            }
            if (this.alignment == EnumAlignment.CENTER) {
                if (this.wrap) {
                    float wrapCount = fontrenderer.func_78271_c(text, this.xSize - buffer * 2).size();
                    this.drawCenteredSplitString(fontrenderer, text, this.xPos + this.xSize / 2, (float)(this.yPos - fh / 2) + (float)this.ySize / 2.0f - (float)fh * (wrapCount - 1.0f) / 2.0f, this.xSize - buffer * 2, colour, this.getDropShadow());
                } else {
                    this.drawCenteredString(fontrenderer, text, this.xPos + this.xSize / 2, this.yPos + (this.ySize - 8) / 2, colour, this.getDropShadow());
                }
            } else if (this.alignment == EnumAlignment.LEFT) {
                if (this.wrap) {
                    float wrapCount = fontrenderer.func_78271_c(text, this.xSize - buffer * 2).size();
                    this.drawSplitString(fontrenderer, text, this.xPos + buffer, (float)(this.yPos - fh / 2) + (float)this.ySize / 2.0f - (float)fh * (wrapCount - 1.0f) / 2.0f, this.xSize - buffer * 2, colour, this.getDropShadow());
                } else {
                    this.drawString(fontrenderer, text, this.xPos + buffer, this.yPos + (this.ySize - 8) / 2, colour, this.getDropShadow());
                }
            } else {
                this.drawString(fontrenderer, text, this.xPos + this.xSize - buffer - fontrenderer.func_78256_a(text), this.yPos + (this.ySize - 8) / 2, colour, this.getDropShadow());
            }
        } else {
            if (this.trim && fontrenderer.func_78256_a(text) > this.ySize - 4) {
                text = fontrenderer.func_78269_a(text, this.ySize - 8) + "...";
            }
            boolean rotateBottomToTop = this.rotation == -1;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.xPos + this.xSize / 2), (float)(this.yPos + this.ySize / 2 - fh / 2), (float)0.0f);
            GlStateManager.func_179114_b((float)(rotateBottomToTop ? -90.0f : 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)(-(this.xPos + this.xSize / 2)), (float)(-(this.yPos + this.ySize / 2 - fh / 2)), (float)0.0f);
            int translation = fh / 2;
            GlStateManager.func_179109_b((float)(rotateBottomToTop ? (float)(-translation) : (float)translation), (float)(-translation), (float)0.0f);
            if (this.alignment == EnumAlignment.CENTER) {
                this.drawCenteredString(mc.field_71466_p, text, this.xPos + this.xSize / 2, this.yPos + this.ySize / 2 - fh / 2, colour, this.getDropShadow());
            } else {
                int buffer = 1 + (this.xSize - fh) / 2;
                if (this.alignment == EnumAlignment.LEFT) {
                    this.drawString(mc.field_71466_p, text, this.xPos + this.xSize / 2 - this.ySize / 2 + buffer, this.yPos + this.ySize / 2 - fh / 2, colour, this.getDropShadow());
                } else {
                    this.drawString(mc.field_71466_p, text, this.xPos + this.xSize / 2 + this.ySize / 2 - fontrenderer.func_78256_a(text) - buffer, this.yPos + this.ySize / 2 - fh / 2, colour, this.getDropShadow());
                }
            }
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public MGuiLabel setDisplayString(String displayString) {
        this.displayString = displayString;
        return this;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public MGuiLabel setAlignment(EnumAlignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public MGuiLabel setTextColour(int textColour) {
        this.textColour = textColour;
        return this;
    }

    public int getTextColour() {
        return this.textColour;
    }

    public MGuiLabel setShadow(boolean dropShadow) {
        this.dropShadow = dropShadow;
        return this;
    }

    public boolean getDropShadow() {
        return this.dropShadow;
    }

    public MGuiLabel setRotation(int rotation) {
        if (rotation > 1) {
            rotation = 1;
        } else if (rotation < -1) {
            rotation = -1;
        }
        this.rotation = rotation;
        return this;
    }

    public MGuiLabel setWrap(boolean wrap) {
        this.wrap = wrap;
        return this;
    }

    public MGuiLabel setTrim(boolean trim) {
        this.trim = trim;
        return this;
    }
}

