/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui;

import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.BCFontRenderer;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IGuiEventDispatcher;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IGuiEventListener;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;

public class GuiElementManager {
    protected LinkedList<MGuiElementBase> elements = new LinkedList();
    protected LinkedList<MGuiElementBase> actionList = new LinkedList();
    private boolean requiresReSort = false;
    private boolean initialized = false;
    private IModularGui parentGui;
    private Minecraft mc;
    private int width;
    private int height;
    private List<MGuiElementBase> toRemove = new ArrayList<MGuiElementBase>();
    private Supplier<List<MGuiElementBase>> jeiExclusions = null;
    private static Comparator<MGuiElementBase> renderSorter = (o1, o2) -> o1.displayZLevel < o2.displayZLevel ? -1 : (o1.displayZLevel > o2.displayZLevel ? 1 : 0);
    private static Comparator<MGuiElementBase> actionSorter = (o1, o2) -> o1.displayZLevel < o2.displayZLevel ? 1 : (o1.displayZLevel > o2.displayZLevel ? -1 : 0);

    public GuiElementManager(IModularGui parentGui) {
        this.parentGui = parentGui;
    }

    public void onGuiInit(Minecraft mc, int width, int height) {
        this.setWorldAndResolution(mc, width, height);
        if (!this.initialized) {
            this.parentGui.addElements(this);
            this.initialized = true;
        }
    }

    public void reinitialize(Minecraft mc, int width, int height) {
        this.elements.clear();
        this.actionList.clear();
        this.toRemove.clear();
        this.initialized = false;
        this.onGuiInit(mc, width, height);
    }

    public void reloadElements() {
        for (MGuiElementBase element : this.elements) {
            element.reloadElement();
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public MGuiElementBase add(MGuiElementBase element, int displayZLevel) {
        if (displayZLevel >= 950) {
            LogHelperBC.error("ModularGui Display Level Out Of Bounds! Can not be greater than 950 " + displayZLevel);
        }
        element.applyGeneralElementData(this.parentGui, this.mc, this.width, this.height, BCFontRenderer.convert(this.mc.field_71466_p));
        element.displayZLevel = displayZLevel;
        this.elements.add(element);
        if (!element.isElementInitialized()) {
            element.addChildElements();
        }
        this.requiresReSort = true;
        if (element instanceof IGuiEventDispatcher && ((IGuiEventDispatcher)((Object)element)).getListener() == null && this.parentGui instanceof IGuiEventListener) {
            ((IGuiEventDispatcher)((Object)element)).setListener((IGuiEventListener)((Object)this.parentGui));
        }
        element.reloadElement();
        return element;
    }

    public MGuiElementBase add(MGuiElementBase element) {
        return this.add(element, 0);
    }

    public void remove(MGuiElementBase element) {
        if (this.elements.contains(element)) {
            this.toRemove.add(element);
            this.requiresReSort = true;
        }
    }

    public void removeByID(String id) {
        for (MGuiElementBase element : this.elements) {
            if (element.id == null || !element.id.equals(id)) continue;
            this.toRemove.add(element);
            this.requiresReSort = true;
            return;
        }
    }

    public void removeByGroup(String group) {
        for (MGuiElementBase element : this.elements) {
            if (!element.isInGroup(group)) continue;
            this.toRemove.add(element);
            this.requiresReSort = true;
        }
    }

    public void setIDEnabled(String id, boolean enabled) {
        for (MGuiElementBase element : this.elements) {
            if (element.id == null || !element.id.equals(id)) continue;
            element.setEnabled(enabled);
            return;
        }
    }

    public void setGroupEnabled(String group, boolean enabled) {
        for (MGuiElementBase element : this.elements) {
            if (!element.isInGroup(group)) continue;
            element.setEnabled(enabled);
        }
    }

    public List<MGuiElementBase> getElements() {
        return this.elements;
    }

    public void clear() {
        this.elements.clear();
        this.requiresReSort = true;
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        int clickedDisplay = -100;
        for (MGuiElementBase element : this.actionList) {
            if (element.isEnabled() && clickedDisplay > -100 && element.displayZLevel < clickedDisplay) {
                return true;
            }
            if (element.isEnabled() && element.isMouseOver(mouseX, mouseY)) {
                clickedDisplay = element.displayZLevel;
            }
            if (!element.isEnabled() || !element.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(int mouseX, int mouseY, int state) {
        for (MGuiElementBase element : this.actionList) {
            if (!element.isEnabled() || !element.mouseReleased(mouseX, mouseY, state)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        for (MGuiElementBase element : this.actionList) {
            if (!element.isEnabled() || !element.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick)) continue;
            return true;
        }
        return false;
    }

    public boolean keyTyped(char typedChar, int keyCode) throws IOException {
        for (MGuiElementBase element : this.actionList) {
            if (!element.isEnabled() || !element.keyTyped(typedChar, keyCode)) continue;
            return true;
        }
        return false;
    }

    public boolean handleMouseInput() throws IOException {
        for (MGuiElementBase element : this.actionList) {
            if (!element.isEnabled() || !element.handleMouseInput()) continue;
            return true;
        }
        return false;
    }

    public List<MGuiElementBase> getElementsAtPosition(int posX, int posY) {
        LinkedList<MGuiElementBase> list = new LinkedList<MGuiElementBase>();
        for (MGuiElementBase element : this.elements) {
            element.getElementsAtPosition(posX, posY, list);
        }
        return list;
    }

    public <C extends MGuiElementBase> List<C> getElementsAtPosition(int posX, int posY, Class<C> clazz) {
        List<MGuiElementBase> list = this.getElementsAtPosition(posX, posY);
        LinkedList matches = new LinkedList();
        DataUtils.forEachMatch(list, element -> clazz.isAssignableFrom(element.getClass()), element -> matches.add(clazz.cast(element)));
        return matches;
    }

    public void renderElements(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (MGuiElementBase element : this.elements) {
            if (!element.isEnabled()) continue;
            this.parentGui.setZLevel(element.displayZLevel);
            element.preDraw(mc, mouseX, mouseY, partialTicks);
            element.renderElement(mc, mouseX, mouseY, partialTicks);
            element.postDraw(mc, mouseX, mouseY, partialTicks);
        }
    }

    public boolean renderOverlayLayer(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        int renderDisplay = -100;
        for (MGuiElementBase element : this.actionList) {
            if (element.isEnabled() && renderDisplay > -100 && element.displayZLevel < renderDisplay) {
                return true;
            }
            if (element.isEnabled() && element.isMouseOver(mouseX, mouseY)) {
                renderDisplay = element.displayZLevel;
            }
            if (!element.isEnabled() || !element.renderOverlayLayer(mc, mouseX, mouseY, partialTicks)) continue;
            return true;
        }
        return false;
    }

    public boolean isAreaUnderElement(int posX, int posY, int xSize, int ySize, int zLevel) {
        for (MGuiElementBase element : this.elements) {
            if (!element.isEnabled() || element.displayZLevel < zLevel || !element.getRect().intersects(posX, posY, xSize, ySize)) continue;
            return true;
        }
        return false;
    }

    public boolean isPointUnderElement(int posX, int posY, int zLevel) {
        for (MGuiElementBase element : this.elements) {
            if (!element.isEnabled() || element.displayZLevel < zLevel || !element.getRect().contains(posX, posY)) continue;
            return true;
        }
        return false;
    }

    public void onUpdate() {
        MGuiElementBase element;
        if (!this.toRemove.isEmpty()) {
            this.elements.removeAll(this.toRemove);
            this.toRemove.clear();
        }
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext() && !(element = (MGuiElementBase)iterator.next()).onUpdate()) {
        }
        if (this.requiresReSort) {
            this.sort();
        }
    }

    public void setWorldAndResolution(Minecraft mc, int width, int height) {
        this.mc = mc;
        this.width = width;
        this.height = height;
        for (MGuiElementBase element : this.elements) {
            element.applyGeneralElementData(this.parentGui, mc, width, height, BCFontRenderer.convert(mc.field_71466_p));
        }
        this.reloadElements();
    }

    private void sort() {
        Collections.sort(this.elements, renderSorter);
        this.actionList.clear();
        this.actionList.addAll(this.elements);
        Collections.sort(this.actionList, actionSorter);
    }

    public IModularGui getParentGui() {
        return this.parentGui;
    }

    public void setJeiExclusions(Supplier<List<MGuiElementBase>> exclusions) {
        this.jeiExclusions = exclusions;
    }

    public List<Rectangle> getJeiExclusions() {
        if (this.jeiExclusions == null) {
            return Collections.emptyList();
        }
        return this.jeiExclusions.get().stream().map(elementBase -> new Rectangle(elementBase.getRect())).collect(Collectors.toList());
    }
}

