/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.utilities.virtualdir;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.millenaire.common.utilities.MillLog;

public class VirtualDir {
    private final List<File> sourceDirs;
    private Map<String, File> recursiveChildrenCache = null;
    private List<File> recursiveChildrenListCache = null;

    public VirtualDir(File sourceDir) {
        this.sourceDirs = new ArrayList<File>();
        this.sourceDirs.add(sourceDir);
    }

    public VirtualDir(List<File> sourceDirs) throws Exception {
        if (sourceDirs == null || sourceDirs.isEmpty()) {
            throw new Exception("A virtual directory cannot be created with no source directories.");
        }
        this.sourceDirs = new ArrayList<File>(sourceDirs);
    }

    public boolean exists() {
        for (File sourceDir : this.sourceDirs) {
            if (!sourceDir.exists()) continue;
            return true;
        }
        return false;
    }

    public List<File> getAllChildFiles(String childName) {
        ArrayList<File> childFiles = new ArrayList<File>();
        for (File sourceDir : this.sourceDirs) {
            File possibleChild = new File(sourceDir, childName);
            if (!possibleChild.exists()) continue;
            childFiles.add(possibleChild);
        }
        return childFiles;
    }

    public VirtualDir getChildDirectory(String childDirectory) {
        ArrayList<File> childSourceDir = new ArrayList<File>();
        for (File sourceDir : this.sourceDirs) {
            childSourceDir.add(new File(sourceDir, childDirectory));
        }
        try {
            return new VirtualDir(childSourceDir);
        }
        catch (Exception e) {
            MillLog.printException(e);
            return null;
        }
    }

    public File getChildFile(String childName) {
        File childFile = null;
        for (File sourceDir : this.sourceDirs) {
            File possibleChild = new File(sourceDir, childName);
            if (!possibleChild.exists()) continue;
            childFile = possibleChild;
        }
        return childFile;
    }

    public File getChildFileRecursive(String childName) {
        if (this.recursiveChildrenCache == null) {
            this.rebuildRecursiveCache();
        }
        return this.recursiveChildrenCache.get(childName.toLowerCase());
    }

    public String getName() {
        return this.sourceDirs.get(0).getName();
    }

    public List<File> listFiles() {
        return this.listFiles(null);
    }

    public List<File> listFiles(FilenameFilter filter) {
        HashMap<String, Object> children = new HashMap<String, Object>();
        for (File sourceDir : this.sourceDirs) {
            if (!sourceDir.exists()) continue;
            for (File file : sourceDir.listFiles()) {
                if (file.isDirectory() || filter != null && !filter.accept(sourceDir, file.getName())) continue;
                children.put(file.getName().toLowerCase(), file);
            }
        }
        ArrayList<File> childrenList = new ArrayList<File>();
        ArrayList names = new ArrayList(children.keySet());
        Collections.sort(names);
        for (String name : names) {
            childrenList.add((File)children.get(name));
        }
        return childrenList;
    }

    public List<File> listFilesRecursive() {
        return this.listFilesRecursive(null);
    }

    public List<File> listFilesRecursive(FilenameFilter filter) {
        if (this.recursiveChildrenCache == null) {
            this.rebuildRecursiveCache();
        }
        ArrayList<File> results = new ArrayList<File>();
        for (File file : this.recursiveChildrenListCache) {
            if (filter != null && !filter.accept(file.getParentFile(), file.getName())) continue;
            results.add(file);
        }
        return results;
    }

    public List<VirtualDir> listSubDirs() {
        return this.listSubDirs(null);
    }

    public List<VirtualDir> listSubDirs(FilenameFilter filter) {
        HashMap<String, Object> children = new HashMap<String, Object>();
        for (File sourceDir : this.sourceDirs) {
            if (!sourceDir.exists()) continue;
            for (File file : sourceDir.listFiles()) {
                if (!file.isDirectory() || filter != null && !filter.accept(sourceDir, file.getName())) continue;
                children.put(file.getName().toLowerCase(), file);
            }
        }
        ArrayList<VirtualDir> childrenList = new ArrayList<VirtualDir>();
        ArrayList names = new ArrayList(children.keySet());
        Collections.sort(names);
        for (String name : names) {
            childrenList.add(this.getChildDirectory(name));
        }
        return childrenList;
    }

    public void mkdirs() {
        for (File source : this.sourceDirs) {
            if (source.exists()) continue;
            source.mkdirs();
        }
    }

    private void rebuildRecursiveCache() {
        this.recursiveChildrenCache = new HashMap<String, File>();
        for (File sourceDir : this.sourceDirs) {
            if (!sourceDir.exists()) continue;
            this.rebuildRecursiveCache_handleDirectory(sourceDir, this.recursiveChildrenCache);
        }
        this.recursiveChildrenListCache = new ArrayList<File>();
        ArrayList<String> names = new ArrayList<String>(this.recursiveChildrenCache.keySet());
        Collections.sort(names);
        for (String name : names) {
            this.recursiveChildrenListCache.add(this.recursiveChildrenCache.get(name));
        }
    }

    private void rebuildRecursiveCache_handleDirectory(File directory, Map<String, File> filesFound) {
        for (File file : directory.listFiles()) {
            if (!file.isFile()) continue;
            filesFound.put(file.getName().toLowerCase(), file);
        }
        for (File file : directory.listFiles()) {
            if (!file.isDirectory()) continue;
            this.rebuildRecursiveCache_handleDirectory(file, filesFound);
        }
    }
}

