/*
 * Decompiled with CFR 0.152.
 */
package org.millenaire.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.millenaire.common.block.BlockDecorativeStone;
import org.millenaire.common.block.MillBlocks;
import org.millenaire.common.item.IMetaBlockName;
import org.millenaire.common.utilities.MillCommonUtilities;

public class BlockWetBrick
extends Block
implements IMetaBlockName {
    static final PropertyEnum<EnumType> PROGRESS = PropertyEnum.func_177709_a((String)"progress", EnumType.class);

    public BlockWetBrick(String blockName) {
        super(Material.field_151578_c);
        this.func_149663_c("millenaire." + blockName);
        this.setRegistryName(blockName);
        this.func_149647_a(MillBlocks.tabMillenaire);
        this.func_149675_a(true);
        this.setHarvestLevel("shovel", 0);
        this.func_149711_c(0.8f);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(PROGRESS, (Comparable)((Object)EnumType.WETBRICK0)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROGRESS});
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(PROGRESS))).getMetadata();
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return "tile.millenaire." + ((EnumType)((Object)this.func_176203_a(stack.func_77960_j()).func_177229_b(PROGRESS))).func_176610_l();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PROGRESS, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, 0));
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        for (EnumType enumtype : EnumType.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)enumtype.getMetadata(), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "progress=" + enumtype.func_176610_l()));
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int currentValue = ((EnumType)((Object)state.func_177229_b(PROGRESS))).getMetadata();
        if (worldIn.func_175671_l(pos.func_177984_a()) > 14) {
            if (++currentValue < 2 && MillCommonUtilities.chanceOn(2)) {
                IBlockState newState = state.func_177226_a(PROGRESS, (Comparable)((Object)EnumType.byMetadata(++currentValue)));
                worldIn.func_175656_a(pos, newState);
            } else if (currentValue < 3) {
                IBlockState newState = state.func_177226_a(PROGRESS, (Comparable)((Object)EnumType.byMetadata(currentValue)));
                worldIn.func_175656_a(pos, newState);
            } else {
                worldIn.func_175656_a(pos, MillBlocks.STONE_DECORATION.func_176223_P().func_177226_a(BlockDecorativeStone.VARIANT, (Comparable)((Object)BlockDecorativeStone.EnumType.MUDBRICK)));
            }
        }
    }

    public static final class EnumType
    extends Enum<EnumType>
    implements IStringSerializable {
        public static final /* enum */ EnumType WETBRICK0;
        public static final /* enum */ EnumType WETBRICK1;
        public static final /* enum */ EnumType WETBRICK2;
        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private static final /* synthetic */ EnumType[] $VALUES;

        public static EnumType[] values() {
            return (EnumType[])$VALUES.clone();
        }

        public static EnumType valueOf(String name) {
            return Enum.valueOf(EnumType.class, name);
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        static {
            EnumType[] var0;
            WETBRICK0 = new EnumType(0, "wetbrick0");
            WETBRICK1 = new EnumType(1, "wetbrick1");
            WETBRICK2 = new EnumType(2, "wetbrick2");
            $VALUES = new EnumType[]{WETBRICK0, WETBRICK1, WETBRICK2};
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = var0 = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType var3;
                EnumType.META_LOOKUP[var3.getMetadata()] = var3 = enumTypeArray[i];
            }
        }
    }
}

