/*
 * Decompiled with CFR 0.152.
 */
package net.smart.properties;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.smart.properties.Properties;
import net.smart.utilities.Name;
import net.smart.utilities.Reflect;

public class Value<T> {
    private int type;
    private T value;
    private Dictionary<String, T> keyValues;
    private List<String> unparsableStrings;
    public static final String Null = "null";
    private static final List<String> _allkeys = new LinkedList<String>();
    public static final Class<?> keyboard = Reflect.LoadClass(Value.class, (Name)new Name("org.lwjgl.input.Keyboard"), (boolean)false);
    public static final Class<?> mouse = Reflect.LoadClass(Value.class, (Name)new Name("org.lwjgl.input.Mouse"), (boolean)false);
    public static final Method _getKeyName = keyboard != null ? Reflect.GetMethod(keyboard, (Name)new Name("getKeyName"), (Class[])new Class[]{Integer.TYPE}) : null;
    public static final Method _getKeyIndex = keyboard != null ? Reflect.GetMethod(keyboard, (Name)new Name("getKeyIndex"), (Class[])new Class[]{String.class}) : null;
    public static final Method _getButtonName = mouse != null ? Reflect.GetMethod(mouse, (Name)new Name("getButtonName"), (Class[])new Class[]{Integer.TYPE}) : null;
    public static final Method _getButtonIndex = mouse != null ? Reflect.GetMethod(mouse, (Name)new Name("getButtonIndex"), (Class[])new Class[]{String.class}) : null;

    public Value(int type) {
        this.type = type;
    }

    public Value(T value) {
        this.value = value;
    }

    public Value(Value<T> value) {
        this.type = value.type;
        this.value = value.value;
        if (value.keyValues != null) {
            this.keyValues = new Hashtable<String, T>();
            Enumeration<String> keys = value.keyValues.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                this.keyValues.put(key, value.keyValues.get(key));
            }
        }
    }

    public Value<T> put(T value) {
        return this.put(null, value);
    }

    public T get(String key) {
        T value;
        if (key != null && this.keyValues != null && (value = this.keyValues.get(key)) != null) {
            return value;
        }
        return this.value;
    }

    public T getStored(String key) {
        if (key == null || key == Null) {
            return this.value;
        }
        if (this.keyValues != null) {
            return this.keyValues.get(key);
        }
        return null;
    }

    private T get(String key, Value<T> defaultValue) {
        T result = this.get(key);
        if (result == null && (result = this.value) == null) {
            result = defaultValue.value;
        }
        return result;
    }

    public Value<T> put(String key, T value) {
        if (key == null || key == Null || key.isEmpty()) {
            this.value = value;
        } else {
            if (this.keyValues == null) {
                this.keyValues = new Hashtable<String, T>();
            }
            this.keyValues.put(key, value);
        }
        return this;
    }

    public void withDependency(Value<T> dependency, Value<T> defaultValue) {
        Iterator<String> iterator = Value.GetAllKeys(this, dependency);
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (!this.get(key, defaultValue).equals(true) || !dependency.get(key).equals(false)) continue;
            this.put(key, false);
        }
    }

    public void withMinimum(Value<T> minimum, Value<T> defaultValue) {
        Iterator<String> iterator = Value.GetAllKeys(this, minimum);
        while (iterator.hasNext()) {
            String key = iterator.next();
            this.put(key, Float.valueOf(Math.max(((Float)this.get(key, defaultValue)).floatValue(), ((Float)minimum.get(key)).floatValue())));
        }
    }

    public void withMaximum(Value<T> maximum, Value<T> defaultValue) {
        Iterator<String> iterator = Value.GetAllKeys(this, maximum);
        while (iterator.hasNext()) {
            String key = iterator.next();
            this.put(key, Float.valueOf(Math.min(((Float)this.get(key, defaultValue)).floatValue(), ((Float)maximum.get(key)).floatValue())));
        }
    }

    public Value<Boolean> is(Value<T> right) {
        Value<int> result = new Value<int>(Properties.Boolean);
        Iterator<String> iterator = Value.GetAllKeys(this, right);
        while (iterator.hasNext()) {
            String key = iterator.next();
            T leftValue = this.get(key);
            T rightValue = right.get(key);
            result.put(key, leftValue == null && rightValue == null || leftValue != null && rightValue != null && leftValue.equals(rightValue) ? 1 : 0);
        }
        return result;
    }

    public Value<Boolean> and(Value<T> right) {
        Value<int> result = new Value<int>(Properties.Boolean);
        Iterator<String> iterator = Value.GetAllKeys(this, right);
        while (iterator.hasNext()) {
            String key;
            result.put(key, (Boolean)this.get(key = iterator.next()) != false && (Boolean)right.get(key) != false ? 1 : 0);
        }
        return result;
    }

    public Value<Boolean> or(Value<T> right) {
        Value<int> result = new Value<int>(Properties.Boolean);
        Iterator<String> iterator = Value.GetAllKeys(this, right);
        while (iterator.hasNext()) {
            String key;
            result.put(key, (Boolean)this.get(key = iterator.next()) != false || (Boolean)right.get(key) != false ? 1 : 0);
        }
        return result;
    }

    public Value<Boolean> not() {
        Value<int> result = new Value<int>(Properties.Boolean);
        Iterator<String> iterator = Value.GetAllKeys(this);
        while (iterator.hasNext()) {
            String key;
            result.put(key, (Boolean)this.get(key = iterator.next()) == false ? 1 : 0);
        }
        return result;
    }

    public Value<Float> plus(Value<T> right) {
        Value<int> result = new Value<int>(Properties.Float);
        Iterator<String> iterator = Value.GetAllKeys(this, right);
        while (iterator.hasNext()) {
            String key = iterator.next();
            result.put(key, (int)Float.valueOf(((Float)this.get(key)).floatValue() + ((Float)right.get(key)).floatValue()));
        }
        return result;
    }

    public Value<T> eitherOr(Value<T> left, Value<T> right) {
        Value<int> result = new Value<int>(Properties.getBaseType(left.type));
        Iterator<String> iterator = Value.GetAllKeys(this, left, right);
        while (iterator.hasNext()) {
            String key;
            result.put(key, (int)((Boolean)this.get(key = iterator.next()) != false ? left.get(key) : right.get(key)));
        }
        return result;
    }

    public Value<Float> maximum(Value<T> right) {
        Value<int> result = new Value<int>(Properties.Float);
        Iterator<String> iterator = Value.GetAllKeys(this, right);
        while (iterator.hasNext()) {
            String key = iterator.next();
            result.put(key, (int)Float.valueOf(Math.max(((Float)this.get(key)).floatValue(), ((Float)right.get(key)).floatValue())));
        }
        return result;
    }

    public Value<Float> minimum(Value<T> right) {
        Value<int> result = new Value<int>(Properties.Float);
        Iterator<String> iterator = Value.GetAllKeys(this, right);
        while (iterator.hasNext()) {
            String key = iterator.next();
            result.put(key, (int)Float.valueOf(Math.min(((Float)this.get(key)).floatValue(), ((Float)right.get(key)).floatValue())));
        }
        return result;
    }

    public Value<String> toKeyName() {
        Value<int> result = new Value<int>(Properties.String);
        Iterator<String> iterator = Value.GetAllKeys(this);
        while (iterator.hasNext()) {
            String key = iterator.next();
            result.put(key, (int)Value.toKeyName((Integer)this.get(key)));
        }
        return result;
    }

    public Value<Integer> toKeyCode() {
        Value<int> result = new Value<int>(Properties.Integer);
        Iterator<String> iterator = Value.GetAllKeys(this);
        while (iterator.hasNext()) {
            String key = iterator.next();
            result.put(key, (int)Value.toKeyCode((String)this.get(key)));
        }
        return result;
    }

    public Value<T> clone() {
        return new Value<T>(this);
    }

    public static Iterator<String> GetAllKeys(Value<?> ... values) {
        return Value.GetAllKeys(null, values);
    }

    public static Iterator<String> GetAllKeys(String[] sorted, Value<?> ... values) {
        int i;
        _allkeys.clear();
        for (i = 0; i < values.length; ++i) {
            Value<?> value = values[i];
            if (value.keyValues == null) continue;
            Enumeration<String> keys = value.keyValues.keys();
            while (keys.hasMoreElements()) {
                _allkeys.add(keys.nextElement());
            }
        }
        Collections.sort(_allkeys);
        _allkeys.add(0, Null);
        int n = 1;
        for (i = 0; sorted != null && i < sorted.length; ++i) {
            String sort = sorted[i];
            if (sort == null || sort == Null || !_allkeys.remove(sort)) continue;
            _allkeys.add(n++, sort);
        }
        return _allkeys.iterator();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Value)) {
            return false;
        }
        Value otherValue = (Value)other;
        if (this.value == null != (otherValue.value == null)) {
            return false;
        }
        if (this.value != null && !this.valuesEqual(this.value, otherValue.value)) {
            return false;
        }
        if ((this.keyValues == null ? 0 : this.keyValues.size()) != (otherValue.keyValues == null ? 0 : otherValue.keyValues.size())) {
            return false;
        }
        if (this.keyValues != null && this.keyValues.size() != 0) {
            Enumeration<String> keys = this.keyValues.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                T otherKeyValue = otherValue.keyValues.get(key);
                if (otherKeyValue == null) {
                    return false;
                }
                T keyValue = this.keyValues.get(key);
                if (this.valuesEqual(keyValue, otherKeyValue)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    private boolean valuesEqual(T first, T second) {
        if (!(first instanceof Object[])) {
            return first.equals(second);
        }
        Object[] firstArray = (Object[])first;
        Object[] secondArray = (Object[])second;
        if (firstArray.length != secondArray.length) {
            return false;
        }
        for (int i = 0; i < firstArray.length; ++i) {
            if (firstArray[i].equals(secondArray[i])) continue;
            return false;
        }
        return true;
    }

    public Value<T> load(String content, boolean singular) {
        if (content == null || singular) {
            this.value = this.parsePropertyElement(content);
            return this;
        }
        String[] elements = content.split(";");
        for (int i = 0; i < elements.length; ++i) {
            String element = elements[i];
            int seperatorIndex = element.indexOf(58);
            String key = null;
            String keyValue = null;
            if (seperatorIndex > 0) {
                key = element.substring(0, seperatorIndex);
                keyValue = element.substring(seperatorIndex + 1);
            } else {
                keyValue = element;
            }
            T value = this.parsePropertyElement(keyValue);
            if (value != null) {
                this.put(key, value);
                continue;
            }
            if (this.unparsableStrings == null) {
                this.unparsableStrings = new ArrayList<String>();
            }
            this.unparsableStrings.add(keyValue);
        }
        return this;
    }

    public Iterator<String> getUnparsableStrings() {
        if (this.unparsableStrings != null) {
            return this.unparsableStrings.iterator();
        }
        return null;
    }

    public void print(PrintWriter printer, String[] sorted) {
        boolean first = true;
        Iterator<String> keys = Value.GetAllKeys(sorted, this);
        while (keys.hasNext()) {
            String key = keys.next();
            if (key == Null && this.value == null) continue;
            if (!first) {
                printer.print(";");
            } else {
                first = false;
            }
            if (key != Null) {
                printer.print(key);
                printer.print(":");
            }
            Value.printDisplayString(printer, this.get(key));
        }
    }

    public String toString() {
        StringWriter result = new StringWriter();
        this.print(new PrintWriter(result), null);
        return result.toString();
    }

    public static String createDisplayString(Object value) {
        if (value instanceof String[] || value instanceof Map) {
            StringWriter result = new StringWriter();
            Value.printDisplayString(new PrintWriter(result), value);
            return result.toString();
        }
        return Value.getDisplayString(value);
    }

    private static void printDisplayString(PrintWriter printer, Object value) {
        if (value instanceof String[]) {
            boolean first = true;
            String[] values = (String[])value;
            for (int i = 0; i < values.length; ++i) {
                if (first) {
                    first = false;
                } else {
                    printer.print(",");
                }
                printer.print(Value.getDisplayString(values[i]));
            }
        } else if (value instanceof Map) {
            boolean first = true;
            Map values = (Map)value;
            ArrayList<String> keys = new ArrayList<String>(values.size());
            for (Object key : values.keySet()) {
                keys.add((String)key);
            }
            Collections.sort(keys);
            for (int i = 0; i < keys.size(); ++i) {
                Object key;
                if (first) {
                    first = false;
                } else {
                    printer.print(",");
                }
                key = (String)keys.get(i);
                printer.print(Value.getDisplayString(key));
                printer.print(",");
                printer.print(Value.getDisplayString(values.get(key)));
            }
        } else {
            printer.print(Value.getDisplayString(value));
        }
    }

    private static String getDisplayString(Object value) {
        String result = value.toString();
        if (result.endsWith(".0")) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }

    private T parsePropertyElement(String stringToParse) {
        int baseType = Properties.getBaseType(this.type);
        if (baseType == Properties.Boolean) {
            return (T)Value.tryParseBoolean(stringToParse);
        }
        if (baseType == Properties.Float) {
            return (T)Value.tryParseFloat(stringToParse);
        }
        if (baseType == Properties.Integer) {
            return (T)Value.tryParseInteger(stringToParse);
        }
        if (baseType == Properties.Strings) {
            return (T)Value.tryParseStrings(stringToParse);
        }
        if (baseType == Properties.StringMap) {
            return (T)Value.tryParseStringMap(stringToParse);
        }
        if (baseType == Properties.IntegerMap) {
            return (T)Value.tryParseIntegerMap(stringToParse);
        }
        if (baseType == Properties.String) {
            return (T)Value.tryParseString(stringToParse);
        }
        return null;
    }

    public static Boolean tryParseBoolean(String value) {
        try {
            if (value != null) {
                return value.equals("true") ? Boolean.TRUE : (value.equals("false") ? Boolean.FALSE : null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Float tryParseFloat(String value) {
        try {
            if (value != null) {
                return Float.valueOf(Float.parseFloat(value));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Integer tryParseInteger(String value) {
        try {
            if (value != null) {
                return Integer.parseInt(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String tryParseString(String value) {
        return value == null ? null : value;
    }

    public static String[] tryParseStrings(String value) {
        return value == null ? null : (value.isEmpty() ? new String[]{} : value.split(","));
    }

    public static Map<String, String> tryParseStringMap(String value) {
        String[] keyValues = value.split(",");
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < keyValues.length; ++i) {
            String key = keyValues[i++];
            if (i >= keyValues.length) continue;
            result.put(key, keyValues[i]);
        }
        return result;
    }

    public static Map<String, Integer> tryParseIntegerMap(String value) {
        String[] keyValues = value.split(",");
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (int i = 0; i < keyValues.length; ++i) {
            String key = keyValues[i++];
            if (i >= keyValues.length) continue;
            result.put(key, Integer.parseInt(keyValues[i]));
        }
        return result;
    }

    public Value<T> e(T e) {
        return this.put("e", e);
    }

    public Value<T> m(T m) {
        return this.put("m", m);
    }

    public Value<T> h(T h) {
        return this.put("h", h);
    }

    public Value<T> c(T c) {
        return this.put("c", c);
    }

    public Value<T> a(T a) {
        return this.put("a", a);
    }

    public static String toKeyName(Integer keyCode) {
        if (keyCode == null) {
            return null;
        }
        if (keyCode >= 0) {
            return (String)Reflect.Invoke((Method)_getKeyName, null, (Object[])new Object[]{keyCode});
        }
        return (String)Reflect.Invoke((Method)_getButtonName, null, (Object[])new Object[]{keyCode + 100});
    }

    private static Integer toKeyCode(String keyName) {
        if (keyName == null) {
            return null;
        }
        keyName = keyName.toUpperCase();
        int keyCode = (Integer)Reflect.Invoke((Method)_getKeyIndex, null, (Object[])new Object[]{keyName});
        if (keyCode > 0) {
            return keyCode;
        }
        keyCode = (Integer)Reflect.Invoke((Method)_getButtonIndex, null, (Object[])new Object[]{keyName});
        if (keyCode >= 0) {
            return keyCode - 100;
        }
        return null;
    }
}

