/*
 * Decompiled with CFR 0.152.
 */
package net.smart.properties;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.smart.properties.Property;
import net.smart.properties.Value;
import net.smart.utilities.Reflect;

public class Properties
extends java.util.Properties {
    private static final long serialVersionUID = 5319578641402091067L;
    private static int i = 0;
    public static final int Boolean = i++;
    public static final int Unmodified = i++;
    public static final int Modified = i++;
    public static final int Float = i++;
    public static final int Positive = i++;
    public static final int Negative = i++;
    public static final int PositiveFactor = i++;
    public static final int NegativeFactor = i++;
    public static final int IncreasingFactor = i++;
    public static final int DecreasingFactor = i++;
    public static final int Integer = i++;
    public static final int String = i++;
    public static final int Strings = i++;
    public static final int Operator = i++;
    public static final int Constant = i++;
    public static final int Key = i++;
    public static final int StringMap = i++;
    public static final int IntegerMap = i++;
    public final String version;

    public Properties() {
        this.version = null;
    }

    public Properties(File file) {
        this.load(file);
        this.version = this.getProperty("move.options.version");
    }

    public Properties(String version, File file) {
        this.load(file);
        this.version = version;
    }

    protected List<Property<?>> getProperties() {
        return this.getProperties(null);
    }

    protected List<Property<?>> getProperties(Class<?> type) {
        ArrayList properties = new ArrayList();
        if (type != null) {
            return this.addProperties(properties, type, false);
        }
        return this.addProperties(properties, this.getClass(), true);
    }

    private List<Property<?>> addProperties(List<Property<?>> list, Class<?> type, boolean base) {
        if (base && type.getSuperclass() != null) {
            this.addProperties(list, type.getSuperclass(), base);
        }
        Field[] fields = type.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            fields[i].setAccessible(true);
            Object value = Reflect.GetField((Field)fields[i], (Object)this);
            this.addProperties(list, value);
        }
        return list;
    }

    private void addProperties(List<Property<?>> list, Object value) {
        if (value instanceof Property) {
            list.add((Property)value);
        } else if (value instanceof Collection) {
            Iterator iterator = ((Collection)value).iterator();
            while (iterator.hasNext()) {
                this.addProperties(list, iterator.next());
            }
        }
    }

    public void write(Properties properties) {
        this.write(properties, null);
    }

    public void write(Properties properties, String key) {
        List<Property<?>> propertiesToWrite = this.getProperties();
        for (int i = 0; i < propertiesToWrite.size(); ++i) {
            Property<?> property = propertiesToWrite.get(i);
            if (!property.isPersistent()) continue;
            properties.put(property.getCurrentKey(), key == null ? property.getValueString() : property.getKeyValueString(key));
        }
    }

    private boolean load(File file) {
        try {
            if (file.exists()) {
                this.load(new FileInputStream(file));
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int getBaseType(int type) {
        if (type == Boolean || type == Unmodified || type == Modified) {
            return Boolean;
        }
        if (type == Float || type == Positive || type == Negative || type == PositiveFactor || type == NegativeFactor || type == IncreasingFactor || type == DecreasingFactor) {
            return Float;
        }
        if (type == Integer) {
            return Integer;
        }
        if (type == Strings) {
            return Strings;
        }
        if (type == StringMap) {
            return StringMap;
        }
        if (type == IntegerMap) {
            return IntegerMap;
        }
        return String;
    }

    public static String getBaseTypeName(int baseType) {
        if (baseType == Boolean) {
            return "boolean";
        }
        if (baseType == Float) {
            return "floating point";
        }
        if (baseType == Integer) {
            return "integer";
        }
        return "string";
    }

    public static Object getDefaultValue(int type) {
        if (type == Boolean) {
            return false;
        }
        if (type == Unmodified) {
            return true;
        }
        if (type == Modified) {
            return false;
        }
        if (type == Integer) {
            return 0;
        }
        if (type == Float) {
            return java.lang.Float.valueOf(0.0f);
        }
        if (type == Positive) {
            return java.lang.Float.valueOf(0.0f);
        }
        if (type == Negative) {
            return java.lang.Float.valueOf(0.0f);
        }
        if (type == PositiveFactor) {
            return java.lang.Float.valueOf(1.0f);
        }
        if (type == NegativeFactor) {
            return java.lang.Float.valueOf(1.0f);
        }
        if (type == IncreasingFactor) {
            return java.lang.Float.valueOf(1.0f);
        }
        if (type == DecreasingFactor) {
            return java.lang.Float.valueOf(1.0f);
        }
        if (type == String) {
            return "";
        }
        if (type == Strings) {
            return new String[0];
        }
        if (type == StringMap) {
            return new HashMap();
        }
        if (type == IntegerMap) {
            return new HashMap();
        }
        return null;
    }

    public static Object getMinimumValue(int type) {
        if (type == Positive) {
            return java.lang.Float.valueOf(0.0f);
        }
        if (type == PositiveFactor) {
            return java.lang.Float.valueOf(0.0f);
        }
        if (type == IncreasingFactor) {
            return java.lang.Float.valueOf(1.0f);
        }
        if (type == DecreasingFactor) {
            return java.lang.Float.valueOf(0.0f);
        }
        return null;
    }

    public static Object getMaximumValue(int type) {
        if (type == Negative) {
            return java.lang.Float.valueOf(0.0f);
        }
        if (type == NegativeFactor) {
            return java.lang.Float.valueOf(0.0f);
        }
        if (type == DecreasingFactor) {
            return java.lang.Float.valueOf(1.0f);
        }
        return null;
    }

    public static Property<Boolean> Unmodified() {
        return Properties.Property(Unmodified);
    }

    public static Property<Boolean> Unmodified(String key, String ... versions) {
        return Properties.Unmodified().key(key, versions);
    }

    public static Property<Boolean> Modified() {
        return Properties.Property(Modified);
    }

    public static Property<Boolean> Modified(String key, String ... versions) {
        return Properties.Modified().key(key, versions);
    }

    public static Property<Integer> Integer() {
        return Properties.Property(Integer);
    }

    public static Property<Integer> Integer(String key, String ... versions) {
        return Properties.Integer().key(key, versions);
    }

    public static Property<Float> Float() {
        return Properties.Property(Float);
    }

    public static Property<Float> Float(String key, String ... versions) {
        return Properties.Float().key(key, versions);
    }

    public static Property<Float> Positive() {
        return Properties.Property(Positive);
    }

    public static Property<Float> Positive(String key, String ... versions) {
        return Properties.Positive().key(key, versions);
    }

    public static Property<Float> Negative() {
        return Properties.Property(Negative);
    }

    public static Property<Float> Negative(String key, String ... versions) {
        return Properties.Negative().key(key, versions);
    }

    public static Property<Float> PositiveFactor() {
        return Properties.Property(PositiveFactor);
    }

    public static Property<Float> PositiveFactor(String key, String ... versions) {
        return Properties.PositiveFactor().key(key, versions);
    }

    public static Property<Float> NegativeFactor() {
        return Properties.Property(NegativeFactor);
    }

    public static Property<Float> NegativeFactor(String key, String ... versions) {
        return Properties.NegativeFactor().key(key, versions);
    }

    public static Property<Float> IncreasingFactor() {
        return Properties.Property(IncreasingFactor);
    }

    public static Property<Float> IncreasingFactor(String key, String ... versions) {
        return Properties.IncreasingFactor().key(key, versions);
    }

    public static Property<Float> DecreasingFactor() {
        return Properties.Property(DecreasingFactor);
    }

    public static Property<Float> DecreasingFactor(String key, String ... versions) {
        return Properties.DecreasingFactor().key(key, versions);
    }

    public static Property<String> String() {
        return Properties.Property(String);
    }

    public static Property<String> String(String key, String ... versions) {
        return Properties.String().key(key, versions);
    }

    public static Property<String[]> Strings() {
        return Properties.Property(Strings);
    }

    public static Property<String[]> Strings(String key, String ... versions) {
        return Properties.Strings().key(key, versions);
    }

    public static Property<Map<String, String>> StringMap() {
        return Properties.Property(StringMap);
    }

    public static Property<Map<String, String>> StringMap(String key, String ... versions) {
        return Properties.StringMap().key(key, versions);
    }

    public static Property<Map<String, Integer>> IntegerMap() {
        return Properties.Property(IntegerMap);
    }

    public static Property<Map<String, Integer>> IntegerMap(String key, String ... versions) {
        return Properties.IntegerMap().key(key, versions);
    }

    private static Property Property(int type) {
        return new Property(type);
    }

    public static Value<Boolean> Value(Boolean base) {
        return new Value<Boolean>(Boolean).put(base);
    }

    public static Value<Float> Value(Float base) {
        return new Value<Float>(Float).put(base);
    }

    public static Value<String> Value(String base) {
        return new Value<String>(String).put(base);
    }

    protected static String[] concat(String left, String[] right) {
        return Properties.concat(new String[]{left}, right);
    }

    protected static String[] concat(String[] left, String[] right) {
        int i;
        String[] result = new String[left.length + right.length];
        for (i = 0; i < left.length; ++i) {
            result[i] = left[i];
        }
        while (i < result.length) {
            result[i] = right[i - left.length];
            ++i;
        }
        return result;
    }
}

