/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving.packet;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.smart.moving.SMComm;
import net.smart.moving.SMPacketHandler;
import net.smart.moving.SMServerComm;
import net.smart.moving.SMServerPlayerBase;

public class ConfigInfoPacket
implements IMessage {
    public static final byte PacketId = 1;
    public String info;

    public ConfigInfoPacket() {
    }

    public ConfigInfoPacket(String info) {
        this.info = info;
    }

    public void fromBytes(ByteBuf buf) {
        int infoLength = buf.readInt();
        this.info = buf.readCharSequence(infoLength, StandardCharsets.UTF_8).toString();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.info.length());
        buf.writeCharSequence((CharSequence)this.info, StandardCharsets.UTF_8);
    }

    public static class ServerHandler
    implements IMessageHandler<ConfigInfoPacket, IMessage> {
        public IMessage onMessage(ConfigInfoPacket message, MessageContext ctx) {
            SMServerPlayerBase serverPlayer = SMServerPlayerBase.getPlayerBase(ctx.getServerHandler().field_147369_b);
            SMPacketHandler.receivePacket(message, SMServerComm.instance, serverPlayer);
            return null;
        }
    }

    public static class ClientHandler
    implements IMessageHandler<ConfigInfoPacket, IMessage> {
        public IMessage onMessage(ConfigInfoPacket message, MessageContext ctx) {
            SMPacketHandler.receivePacket(message, SMComm.instance, null);
            return null;
        }
    }
}

