/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving;

import java.io.PrintStream;
import net.smart.moving.SMClimbGap;

public class SMHandsClimbing {
    public static final int MiddleGrab = 2;
    public static final int UpGrab = 1;
    public static final int NoGrab = 0;
    public static SMHandsClimbing None = new SMHandsClimbing(-3);
    public static SMHandsClimbing Sink = new SMHandsClimbing(-2);
    public static SMHandsClimbing TopHold = new SMHandsClimbing(-1);
    public static SMHandsClimbing BottomHold = new SMHandsClimbing(0);
    public static SMHandsClimbing Up = new SMHandsClimbing(1);
    public static SMHandsClimbing FastUp = new SMHandsClimbing(2);
    private int _value;

    private SMHandsClimbing(int value) {
        this._value = value;
    }

    public boolean IsRelevant() {
        return this._value > SMHandsClimbing.None._value;
    }

    public boolean IsUp() {
        return this == Up || this == FastUp;
    }

    public SMHandsClimbing ToUp() {
        if (this == BottomHold) {
            return Up;
        }
        return this;
    }

    public SMHandsClimbing ToDown() {
        if (this == TopHold) {
            return Sink;
        }
        return this;
    }

    public SMHandsClimbing max(SMHandsClimbing other, SMClimbGap inout_thisClimbGap, SMClimbGap otherClimbGap) {
        if (!otherClimbGap.SkipGaps) {
            inout_thisClimbGap.CanStand |= otherClimbGap.CanStand;
            inout_thisClimbGap.MustCrawl |= otherClimbGap.MustCrawl;
        }
        if (this._value < other._value) {
            inout_thisClimbGap.Block = otherClimbGap.Block;
            inout_thisClimbGap.Meta = otherClimbGap.Meta;
            inout_thisClimbGap.Direction = otherClimbGap.Direction;
        }
        return SMHandsClimbing.get(Math.max(this._value, other._value));
    }

    public String toString() {
        if (this._value <= SMHandsClimbing.None._value) {
            return "None";
        }
        if (this._value == SMHandsClimbing.Sink._value) {
            return "Sink";
        }
        if (this._value == SMHandsClimbing.BottomHold._value) {
            return "BottomHold";
        }
        if (this._value == SMHandsClimbing.TopHold._value) {
            return "TopHold";
        }
        if (this._value == SMHandsClimbing.Up._value) {
            return "Up";
        }
        return "FastUp";
    }

    public void print(String name) {
        PrintStream stream = System.err;
        if (name != null) {
            stream.print(name + " = ");
        }
        stream.println(this);
    }

    private static SMHandsClimbing get(int value) {
        if (value <= SMHandsClimbing.None._value) {
            return None;
        }
        if (value == SMHandsClimbing.Sink._value) {
            return Sink;
        }
        if (value == SMHandsClimbing.BottomHold._value) {
            return BottomHold;
        }
        if (value == SMHandsClimbing.TopHold._value) {
            return TopHold;
        }
        if (value == SMHandsClimbing.Up._value) {
            return Up;
        }
        return FastUp;
    }
}

