/*
 * Decompiled with CFR 0.152.
 */
package sguest.millenairejei.recipes.villagercrafting;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import sguest.millenairejei.MillenaireJei;
import sguest.millenairejei.millenairedata.CultureData;
import sguest.millenairejei.millenairedata.CultureDataLookup;
import sguest.millenairejei.millenairedata.CultureLanguageData;
import sguest.millenairejei.millenairedata.ItemLookup;
import sguest.millenairejei.millenairedata.LanguageLookup;
import sguest.millenairejei.millenairedata.villagercrafting.CraftingGoalData;
import sguest.millenairejei.millenairedata.villagercrafting.GoalLookup;
import sguest.millenairejei.millenairedata.villagercrafting.HarvestGoalData;
import sguest.millenairejei.millenairedata.villagercrafting.SlaughterGoalData;
import sguest.millenairejei.millenairedata.villagercrafting.VillagerData;
import sguest.millenairejei.millenairedata.villagercrafting.VillagerLookup;
import sguest.millenairejei.recipes.IconWithLabel;
import sguest.millenairejei.recipes.villagercrafting.VillagerCraftingRecipeData;
import sguest.millenairejei.recipes.villagercrafting.VillagerSlaughterRecipeData;

public class VillagerCraftingRecipeLookup {
    private final List<VillagerCraftingRecipeData> craftingRecipes = new ArrayList<VillagerCraftingRecipeData>();
    private final List<VillagerCraftingRecipeData> cookingRecipes = new ArrayList<VillagerCraftingRecipeData>();
    private final List<VillagerCraftingRecipeData> harvestRecipes = new ArrayList<VillagerCraftingRecipeData>();
    private final List<VillagerSlaughterRecipeData> slaughterRecipes = new ArrayList<VillagerSlaughterRecipeData>();

    public void BuildRecipes() {
        ItemLookup itemLookup = ItemLookup.getInstance();
        GoalLookup goalLookup = GoalLookup.getInstance();
        Map<String, CultureData> cultureInfo = CultureDataLookup.getInstance().getCultureInfo();
        for (Map.Entry<String, CultureData> cultureEntry : cultureInfo.entrySet()) {
            String cultureKey = cultureEntry.getKey();
            try {
                CultureData cultureData = cultureEntry.getValue();
                Map<String, VillagerData> villagerData = VillagerLookup.getInstance().getVillagers(cultureKey);
                CultureLanguageData languageData = LanguageLookup.getInstance().getLanguageData(cultureKey);
                String cultureName = languageData.getFullName();
                if (cultureName == null) {
                    cultureName = cultureKey;
                }
                ItemStack cultureIcon = null;
                if (cultureData.getIcon() != null) {
                    cultureIcon = ItemLookup.getInstance().getItem(cultureData.getIcon());
                }
                IconWithLabel culture = new IconWithLabel(cultureName, cultureIcon);
                TreeMap villagersByGoal = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                for (Map.Entry<String, VillagerData> entry : villagerData.entrySet()) {
                    VillagerData villager = entry.getValue();
                    String villagerKey = entry.getKey();
                    String villagerName = languageData.getVillagerName(villagerKey);
                    if (villagerName == null) {
                        villagerName = villagerKey;
                    }
                    Object villagerIcon = null;
                    if (villager.getIcon() != null) {
                        villagerIcon = itemLookup.getItem(villager.getIcon());
                    }
                    IconWithLabel iconWithLabel = new IconWithLabel(villagerName, (ItemStack)villagerIcon);
                    for (String goal : villager.getGoals()) {
                        villagersByGoal.putIfAbsent(goal, new ArrayList());
                        ((List)villagersByGoal.get(goal)).add(iconWithLabel);
                    }
                }
                for (Map.Entry<String, VillagerData> entry : villagersByGoal.entrySet()) {
                    SlaughterGoalData slaughterGoalData;
                    HarvestGoalData harvestGoal;
                    String cookingGoal;
                    String goalKey = entry.getKey();
                    CraftingGoalData craftingGoal = goalLookup.getCrafingGoal(goalKey);
                    if (craftingGoal != null) {
                        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
                        for (Map.Entry entry2 : craftingGoal.getInputs().entrySet()) {
                            ItemStack itemStack = itemLookup.getItem((String)entry2.getKey());
                            if (itemStack == null) continue;
                            ItemStack itemStack2 = itemStack.func_77946_l();
                            itemStack2.func_190920_e(((Integer)entry2.getValue()).intValue());
                            inputs.add(itemStack2);
                        }
                        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
                        for (Map.Entry<String, Integer> entry3 : craftingGoal.getOutputs().entrySet()) {
                            ItemStack itemStack = itemLookup.getItem(entry3.getKey());
                            if (itemStack == null) continue;
                            itemStack = itemStack.func_77946_l();
                            itemStack.func_190920_e(entry3.getValue().intValue());
                            outputs.add(itemStack);
                        }
                        for (List list : Lists.partition((List)((List)((Object)entry.getValue())), (int)4)) {
                            this.craftingRecipes.add(new VillagerCraftingRecipeData(inputs, outputs, culture, list));
                        }
                    }
                    if ((cookingGoal = goalLookup.getCookingGoalInput(goalKey)) != null) {
                        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
                        ItemStack itemStack = itemLookup.getItem(cookingGoal);
                        if (itemStack != null) {
                            inputs.add(itemStack);
                            ItemStack itemStack3 = FurnaceRecipes.func_77602_a().func_151395_a(itemStack);
                            if (itemStack3 != null) {
                                ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
                                outputs.add(itemStack3);
                                for (List villagers : Lists.partition((List)((List)((Object)entry.getValue())), (int)4)) {
                                    this.cookingRecipes.add(new VillagerCraftingRecipeData(inputs, outputs, culture, villagers));
                                }
                            }
                        }
                    }
                    if ((harvestGoal = goalLookup.getHarvestGoal(goalKey)) != null) {
                        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
                        if (harvestGoal.getHarvestBlockState() != null) {
                            String[] stringArray = harvestGoal.getHarvestBlockState().split(";", 2);
                            Block harvestBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(stringArray[0]));
                            Item item = Item.func_150898_a((Block)harvestBlock);
                            if (item.func_77614_k()) {
                                IBlockState blockState = harvestBlock.func_176194_O().func_177621_b();
                                if (stringArray.length == 2) {
                                    String[] stateItems = stringArray[1].split(",");
                                    TreeMap<String, String> stateValues = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                                    for (String stateItem : stateItems) {
                                        String[] itemParts = stateItem.split("=", 2);
                                        if (itemParts.length != 2) continue;
                                        stateValues.put(itemParts[0], itemParts[1]);
                                    }
                                    for (IProperty property : blockState.func_177227_a()) {
                                        String propertyName = property.func_177701_a();
                                        if (!stateValues.containsKey(propertyName)) continue;
                                        blockState = this.blockStateSetHelper(blockState, property, (String)stateValues.get(propertyName));
                                    }
                                }
                                int meta = harvestBlock.func_176201_c(blockState);
                                arrayList.add(new ItemStack(Item.func_150898_a((Block)harvestBlock), 1, meta));
                            } else {
                                arrayList.add(new ItemStack(Item.func_150898_a((Block)harvestBlock)));
                            }
                        } else if (harvestGoal.getCropType() != null) {
                            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(harvestGoal.getCropType()));
                            arrayList.add(new ItemStack(Item.func_150898_a((Block)block)));
                        }
                        ArrayList<ItemStack> arrayList2 = new ArrayList<ItemStack>();
                        for (String output : harvestGoal.getOutputs()) {
                            arrayList2.add(itemLookup.getItem(output));
                        }
                        for (List villagers : Lists.partition((List)((List)((Object)entry.getValue())), (int)4)) {
                            this.harvestRecipes.add(new VillagerCraftingRecipeData(arrayList, arrayList2, culture, villagers));
                        }
                    }
                    if ((slaughterGoalData = goalLookup.getSlaugherGoal(goalKey)) == null) continue;
                    Class clazz = EntityList.func_192839_a((String)slaughterGoalData.getAnimal());
                    Entity entity = this.getEntity(clazz);
                    String animalName = "";
                    if (entity != null) {
                        animalName = entity.func_70005_c_();
                    }
                    ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
                    for (String bonusItem : slaughterGoalData.getBonusItems()) {
                        ItemStack item = itemLookup.getItem(bonusItem);
                        if (item == null) continue;
                        outputs.add(item);
                    }
                    for (List villagers : Lists.partition((List)((List)((Object)entry.getValue())), (int)4)) {
                        this.slaughterRecipes.add(new VillagerSlaughterRecipeData(animalName, outputs, culture, villagers));
                    }
                }
            }
            catch (Exception ex) {
                MillenaireJei.getLogger().error("Error loading villager crafting recipes for culture " + cultureKey, (Throwable)ex);
            }
        }
    }

    public List<VillagerCraftingRecipeData> getCraftingRecipes() {
        return this.craftingRecipes;
    }

    public List<VillagerCraftingRecipeData> getCookingRecipes() {
        return this.cookingRecipes;
    }

    public List<VillagerCraftingRecipeData> getHarvestRecipes() {
        return this.harvestRecipes;
    }

    public List<VillagerSlaughterRecipeData> getSlaughterRecipes() {
        return this.slaughterRecipes;
    }

    private <T extends Comparable<T>> IBlockState blockStateSetHelper(IBlockState blockState, IProperty<T> property, String value) {
        Optional propertyValue = property.func_185929_b(value);
        if (propertyValue.isPresent()) {
            blockState = blockState.func_177226_a(property, (Comparable)propertyValue.get());
        }
        return blockState;
    }

    private <T extends Entity> Entity getEntity(Class<T> entityClass) {
        try {
            Constructor<T> constructor = entityClass.getConstructor(World.class);
            return (Entity)constructor.newInstance(Minecraft.func_71410_x().field_71441_e);
        }
        catch (ReflectiveOperationException | RuntimeException ex) {
            return null;
        }
    }
}

