/*
 * Decompiled with CFR 0.152.
 */
package sguest.millenairejei.millenairedata.villagercrafting;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FilenameUtils;
import sguest.millenairejei.MillenaireJei;
import sguest.millenairejei.millenairedata.villagercrafting.VillagerData;
import sguest.millenairejei.util.DataFileHelper;

public class VillagerLookup {
    private static VillagerLookup instance;
    private Map<String, Map<String, VillagerData>> cultureVillagerData = new TreeMap<String, Map<String, VillagerData>>(String.CASE_INSENSITIVE_ORDER);

    public static VillagerLookup getInstance() {
        if (instance == null) {
            instance = new VillagerLookup();
        }
        return instance;
    }

    private VillagerLookup() {
    }

    public void loadVillagers(String cultureKey, Path cultureFolder) {
        this.cultureVillagerData.putIfAbsent(cultureKey, new TreeMap(String.CASE_INSENSITIVE_ORDER));
        Path villagersFolder = cultureFolder.resolve("villagers");
        if (villagersFolder.toFile().exists()) {
            try {
                Files.walk(villagersFolder, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                    String villagerKey = FilenameUtils.getBaseName((String)file.toFile().getName());
                    Map<String, List<String>> fileData = DataFileHelper.loadDataFile(file.toFile());
                    if (fileData != null) {
                        List<String> iconList = fileData.get("icon");
                        String icon = iconList == null ? null : iconList.get(0);
                        List<String> goals = fileData.get("goal");
                        if (goals == null) {
                            goals = new ArrayList<String>();
                        }
                        this.cultureVillagerData.get(cultureKey).put(villagerKey, new VillagerData(icon, goals));
                    }
                });
            }
            catch (IOException ex) {
                MillenaireJei.getLogger().error("Failed to load villagers from folder " + villagersFolder, (Throwable)ex);
            }
        }
    }

    public Map<String, VillagerData> getVillagers(String cultureKey) {
        return this.cultureVillagerData.get(cultureKey);
    }
}

