/*
 * Decompiled with CFR 0.152.
 */
package sguest.millenairejei.millenairedata.villagercrafting;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FilenameUtils;
import sguest.millenairejei.MillenaireJei;
import sguest.millenairejei.millenairedata.villagercrafting.CraftingGoalData;
import sguest.millenairejei.millenairedata.villagercrafting.HarvestGoalData;
import sguest.millenairejei.millenairedata.villagercrafting.SlaughterGoalData;
import sguest.millenairejei.util.AnimalHelper;
import sguest.millenairejei.util.DataFileHelper;

public class GoalLookup {
    private static GoalLookup instance;
    private final Map<String, CraftingGoalData> craftingGoals = new TreeMap<String, CraftingGoalData>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, String> cookingGoals = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, HarvestGoalData> harvestGoals = new TreeMap<String, HarvestGoalData>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, SlaughterGoalData> slaughterGoals = new TreeMap<String, SlaughterGoalData>(String.CASE_INSENSITIVE_ORDER);

    public static GoalLookup getInstance() {
        if (instance == null) {
            instance = new GoalLookup();
        }
        return instance;
    }

    private GoalLookup() {
    }

    public void loadGoals(Path dataFolder) {
        Path slaughterFolder;
        Path cookingFolder;
        Path goalsFolder = dataFolder.resolve("goals");
        Path craftingFolder = goalsFolder.resolve("genericcrafting");
        if (craftingFolder.toFile().exists()) {
            try {
                Files.walk(craftingFolder, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                    String key = FilenameUtils.getBaseName((String)file.toFile().getName());
                    Map<String, List<String>> fileData = DataFileHelper.loadDataFile(file.toFile());
                    if (fileData != null) {
                        TreeMap<String, Integer> inputs = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
                        if (fileData.containsKey("input")) {
                            for (String input : fileData.get("input")) {
                                String[] parts = input.split(",", 2);
                                if (parts.length != 2) continue;
                                inputs.put(parts[0], Integer.parseInt(parts[1]));
                            }
                        }
                        TreeMap<String, Integer> outputs = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
                        if (fileData.containsKey("output")) {
                            for (String output : fileData.get("output")) {
                                String[] parts = output.split(",", 2);
                                if (parts.length != 2) continue;
                                outputs.put(parts[0], Integer.parseInt(parts[1]));
                            }
                        }
                        this.craftingGoals.put(key, new CraftingGoalData(inputs, outputs));
                    }
                });
            }
            catch (IOException ex) {
                MillenaireJei.getLogger().error("Failed to load crafting goals from folder " + goalsFolder, (Throwable)ex);
            }
        }
        if ((cookingFolder = goalsFolder.resolve("genericcooking")).toFile().exists()) {
            try {
                Files.walk(cookingFolder, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                    List<String> toCook;
                    String key = FilenameUtils.getBaseName((String)file.toFile().getName());
                    Map<String, List<String>> fileData = DataFileHelper.loadDataFile(file.toFile());
                    if (fileData != null && (toCook = fileData.get("itemtocook")) != null) {
                        this.cookingGoals.put(key, toCook.get(0));
                    }
                });
            }
            catch (IOException ex) {
                MillenaireJei.getLogger().error("Failed to load cooking goals from folder " + goalsFolder, (Throwable)ex);
            }
        }
        this.loadHarvestGoals(goalsFolder.resolve("genericgatherblocks"));
        this.loadHarvestGoals(goalsFolder.resolve("genericharvesting"));
        Path miningFolder = goalsFolder.resolve("genericmining");
        if (miningFolder.toFile().exists()) {
            try {
                Files.walk(miningFolder, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                    List<String> loot;
                    String key = FilenameUtils.getBaseName((String)file.toFile().getName());
                    Map<String, List<String>> fileData = DataFileHelper.loadDataFile(file.toFile());
                    if (fileData != null && (loot = fileData.get("loot")) != null) {
                        String[] parts = loot.get(0).split(",", 2);
                        ArrayList<String> outputs = new ArrayList<String>();
                        outputs.add(parts[0]);
                        this.harvestGoals.put(key, new HarvestGoalData(null, null, outputs));
                    }
                });
            }
            catch (IOException ex) {
                MillenaireJei.getLogger().error("Failed to load mining goals from folder " + goalsFolder, (Throwable)ex);
            }
        }
        if ((slaughterFolder = goalsFolder.resolve("genericslaughteranimal")).toFile().exists()) {
            try {
                Files.walk(slaughterFolder, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                    String key = FilenameUtils.getBaseName((String)file.toFile().getName());
                    Map<String, List<String>> fileData = DataFileHelper.loadDataFile(file.toFile());
                    if (fileData != null && fileData.containsKey("animalkey")) {
                        String animal = fileData.get("animalKey").get(0);
                        List<String> outputs = AnimalHelper.getPassiveMobDrops(animal);
                        if (fileData.containsKey("bonusitem")) {
                            for (String bonusItem : fileData.get("bonusitem")) {
                                String item = bonusItem.split(",")[0];
                                if (outputs.contains(item)) continue;
                                outputs.add(item);
                            }
                        }
                        this.slaughterGoals.put(key, new SlaughterGoalData(animal, outputs));
                    }
                });
            }
            catch (IOException ex) {
                MillenaireJei.getLogger().error("Failed to load slaughter goals from folder " + goalsFolder, (Throwable)ex);
            }
        }
    }

    public CraftingGoalData getCrafingGoal(String key) {
        return this.craftingGoals.get(key);
    }

    public String getCookingGoalInput(String key) {
        return this.cookingGoals.get(key);
    }

    public HarvestGoalData getHarvestGoal(String key) {
        return this.harvestGoals.get(key);
    }

    public SlaughterGoalData getSlaugherGoal(String key) {
        return this.slaughterGoals.get(key);
    }

    private void loadHarvestGoals(Path loadingFolder) {
        if (loadingFolder.toFile().exists()) {
            try {
                Files.walk(loadingFolder, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                    String key = FilenameUtils.getBaseName((String)file.toFile().getName());
                    Map<String, List<String>> fileData = DataFileHelper.loadDataFile(file.toFile());
                    if (fileData != null) {
                        List<String> toCook;
                        if (fileData.get("leasure") == null || fileData.get("leasure").get(0) != "true") {
                            String gatherBlockState = null;
                            if (fileData.containsKey("gatherBlockState")) {
                                gatherBlockState = fileData.get("gatherBlockState").get(0);
                            } else if (fileData.containsKey("harvestBlockState")) {
                                gatherBlockState = fileData.get("harvestBlockState").get(0);
                            }
                            String cropType = null;
                            if (fileData.containsKey("croptype")) {
                                cropType = fileData.get("croptype").get(0);
                            }
                            ArrayList<String> outputs = new ArrayList<String>();
                            if (fileData.containsKey("harvestitem")) {
                                for (String harvestItem : fileData.get("harvestitem")) {
                                    String[] parts = harvestItem.split(",", 2);
                                    if (parts.length != 2 || Integer.parseInt(parts[1]) <= 0 || outputs.contains(parts[0])) continue;
                                    outputs.add(parts[0]);
                                }
                            }
                            if (outputs.size() > 0) {
                                this.harvestGoals.put(key, new HarvestGoalData(gatherBlockState, cropType, outputs));
                            }
                        }
                        if ((toCook = fileData.get("itemtocook")) != null) {
                            this.cookingGoals.put(key, toCook.get(0));
                        }
                    }
                });
            }
            catch (IOException ex) {
                MillenaireJei.getLogger().error("Failed to load harvest goals from folder " + loadingFolder, (Throwable)ex);
            }
        }
    }
}

