/*
 * Decompiled with CFR 0.152.
 */
package sguest.millenairejei.jei.villagercrafting;

import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import sguest.millenairejei.jei.villagercrafting.VillagerCrafingRecipeWrapper;
import sguest.millenairejei.util.UiHelper;

public abstract class BaseVillagerCraftingRecipeCategory
implements IRecipeCategory<VillagerCrafingRecipeWrapper> {
    private final IDrawable background;
    private final String title;
    private final IDrawable arrow;

    public BaseVillagerCraftingRecipeCategory(IGuiHelper guiHelper, String title) {
        this.title = title;
        this.background = guiHelper.createBlankDrawable(180, 120);
        this.arrow = UiHelper.staticArrow(guiHelper);
    }

    public String getTitle() {
        return this.title;
    }

    public String getModName() {
        return "Millenaire";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, VillagerCrafingRecipeWrapper recipeWrapper, IIngredients ingredients) {
        int i;
        List<ItemStack> inputs = recipeWrapper.getRecipe().getInputs();
        List<ItemStack> outputs = recipeWrapper.getRecipe().getOutputs();
        for (i = 0; i < inputs.size(); ++i) {
            recipeLayout.getItemStacks().init(i, true, 1 + i * 20, 20);
            recipeLayout.getItemStacks().set(i, inputs.get(i));
        }
        for (i = 0; i < outputs.size(); ++i) {
            recipeLayout.getItemStacks().init(i + inputs.size(), false, 86 + i * 20, 20);
            recipeLayout.getItemStacks().set(i + inputs.size(), outputs.get(i));
        }
    }

    public void drawExtras(Minecraft minecraft) {
        this.arrow.draw(minecraft, 61, 20);
    }
}

